/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LECustomPlanPanel;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LECustomPlan;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LECompMatrix;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LESaveCustomPlanDialog
extends Dialog
implements ActionListener {
    public static final String SAVE = "OK";
    public static final String OLD_VALUE = "Old Value";
    public static final String NEW_VALUE = "New Value";
    public static final String VALID_VALUES = "Valid Values";
    LEVector m_keys = new LEVector();
    LEVector m_allKeys;
    LEVector m_panels;
    int m_index;
    LECustomPlanPanel m_panel;
    LECompMatrix m_matrix;
    Frame m_parent;
    Button m_ok;

    public LESaveCustomPlanDialog(Frame parent, LEVector keys, LEVector panels) {
        super(parent, "Apply", true);
        this.m_allKeys = keys;
        this.m_parent = parent;
        this.m_panels = panels;
        this.m_index = 0;
        this.setLayout(new BorderLayout(5, 5));
        this.saveNext();
    }

    public void saveNext() {
        if (this.m_index == this.m_panels.size()) {
            return;
        }
        this.m_panel = (LECustomPlanPanel)this.m_panels.elementAt(this.m_index++);
        this.removeAll();
        this.buildValues(this.m_allKeys, this.m_panel);
        if (this.m_matrix != null) {
            LEPortMaster pm = this.m_panel.getPortMaster();
            Label label = new Label(pm.getDescription(), 1);
            label.setFont(LEFont.getBoldFont());
            this.add("North", label);
            Panel buttons = new Panel();
            buttons.setLayout(new FlowLayout(1));
            Panel sub = new Panel();
            sub.setLayout(new GridLayout(1, 2, 10, 10));
            this.m_ok = new Button(SAVE);
            sub.add(this.m_ok);
            this.m_ok.addActionListener(this);
            Button btn = new Button("Cancel");
            sub.add(btn);
            btn.addActionListener(this);
            buttons.add(sub);
            this.add("South", buttons);
            ((Component)this).setVisible(true);
        } else {
            this.saveNext();
        }
    }

    public void addNotify() {
        super.addNotify();
        Dimension dim = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dim.width, dim.height);
    }

    public void actionPerformed(ActionEvent event) {
        ((Component)this).setVisible(false);
        this.dispose();
        Object errors = null;
        if (event.getSource() == this.m_ok) {
            this.save();
        }
    }

    void save() {
        LECustomPlan config = (LECustomPlan)this.m_panel.getConfig();
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            config.refresh();
            return;
        }
        int len = this.m_keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)this.m_keys.elementAt(i);
            Checkbox box = (Checkbox)this.m_matrix.getComponent(i, 0);
            if (box.getState()) {
                Label label = (Label)this.m_matrix.getComponent(i, 2);
                config.set(key, label.getText());
                config.setPlansChgFlag(true);
            }
            ++i;
        }
        this.m_panel.resetFields(this.m_keys);
        this.saveNext();
    }

    void buildValues(LEVector keys, LECustomPlanPanel panel) {
        int rows;
        LEFormLine fl;
        String key;
        this.m_matrix = null;
        this.m_keys.removeAllElements();
        LEConfig config = panel.getConfig();
        boolean valid = true;
        int len = keys.size();
        int i = 0;
        while (i < len) {
            key = (String)keys.elementAt(i);
            Component comp = panel.getFormComponent(key);
            if (comp instanceof LEFormLine && comp.isEnabled() && !(fl = (LEFormLine)((Object)comp)).equalsField(config.get(key))) {
                this.m_keys.addElement(key);
                if (!fl.isValueValid()) {
                    valid = false;
                }
            }
            ++i;
        }
        int cols = valid ? 3 : 4;
        String[] colTitles = new String[cols];
        colTitles[0] = SAVE;
        colTitles[1] = OLD_VALUE;
        colTitles[2] = NEW_VALUE;
        if (!valid) {
            colTitles[3] = VALID_VALUES;
        }
        if ((rows = this.m_keys.size()) == 0) {
            return;
        }
        String[] rowTitles = new String[rows];
        Component[][] comps = new Component[rows][cols];
        int i2 = 0;
        while (i2 < rows) {
            key = (String)this.m_keys.elementAt(i2);
            rowTitles[i2] = String.valueOf(config.getDescriptionFor(key)) + ":";
            comps[i2][1] = new Label(config.get(key).toString(), 0);
            fl = (LEFormLine)((Object)panel.getFormComponent(key));
            comps[i2][2] = new Label(fl.getValue(), 0);
            if (!fl.isValueValid()) {
                comps[i2][0] = new Checkbox(null, null, false);
                comps[i2][0].setEnabled(false);
                comps[i2][2].setForeground(Color.red);
                comps[i2][3] = new Label(String.valueOf(new String("ERROR: ")) + fl.getValidValues(), 0);
            } else {
                comps[i2][0] = new Checkbox(null, null, true);
            }
            ++i2;
        }
        this.m_matrix = new LECompMatrix(rowTitles, colTitles, comps, true);
        this.add("Center", this.m_matrix);
    }
}

