/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LESubInterface;
import com.lucent.ra.nms.model.LESubInterfaces;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LESubInterfacesForm
extends LETableForm {
    String m_addSub;
    String m_addAddress;
    String m_addNetmask;
    String m_addBroadcast;
    String m_addPortname;

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        Label lbl = new Label("SubInterface Name:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add SubInterface", panel);
        if (dlg.okay()) {
            this.m_addSub = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addSub.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A subinterface name must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LESubInterfaces table = (LESubInterfaces)this.getTable(pm);
        if (table.get(this.m_addSub) == null) {
            LEVector errors = table.add(this.m_addSub);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addSub);
            entry = new LENewEntry(pm, table, this.m_addSub);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains the subinterface " + this.m_addSub);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LESubInterfaces)) {
            return;
        }
        LESubInterfaces subis = (LESubInterfaces)table;
        LEVector errors = subis.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        String name;
        if (!(obj instanceof LESubInterface)) {
            return null;
        }
        LESubInterface subi = (LESubInterface)obj;
        LESubInterfaces subis = (LESubInterfaces)this.getTable(pm);
        if (subis.get(name = subi.getName()) != null) {
            name = LETableForm.GetUniqueKey(subis, name, 12);
        }
        if ((errors = subis.add(name)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }
}

