/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;

public class LEVPNKeyField
extends LETextField {
    boolean m_pad;

    public LEVPNKeyField() {
        this.m_numeric = true;
        this.m_pad = false;
    }

    public LEVPNKeyField(int n) {
        super(n);
        this.setColumns(n);
        this.m_numeric = true;
        this.m_pad = false;
    }

    public LEVPNKeyField(String string) {
        super(string);
        this.m_numeric = true;
        this.m_pad = false;
    }

    public LEVPNKeyField(String string, int n) {
        super(string, n);
        this.setColumns(n);
        this.m_numeric = true;
        this.m_pad = false;
    }

    public void setColumns(int n) {
        this.m_cols = n + 6;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!this.validEditKey(n)) {
            String string;
            if (this.m_hex && !this.validHexKey(n)) {
                if (this.isSetPadKey(n)) {
                    return;
                }
                if (!keyEvent.isControlDown()) {
                    keyEvent.consume();
                    return;
                }
                if (this.validPasteKey(keyEvent, n) && !this.checkPasteHex() && !this.checkPasteNumeric()) {
                    keyEvent.consume();
                    return;
                }
            }
            if (this.m_numeric && !this.validNumericKey(n)) {
                if (this.isSetPadKey(n) || this.isSetHexKey(n)) {
                    return;
                }
                if (!keyEvent.isControlDown()) {
                    keyEvent.consume();
                    return;
                }
                if (this.validPasteKey(keyEvent, n) && !this.checkPasteNumeric() && !this.checkPasteHex()) {
                    keyEvent.consume();
                    return;
                }
            }
            if (this.m_cols > -1 && this.getSelectionEnd() <= this.getSelectionStart() && this.m_limit_length && (string = this.getText()).length() + 1 > this.m_cols) {
                keyEvent.consume();
                return;
            }
        } else if (n == 8 || n == 127) {
            String string = this.getSelectedText();
            if (string.length() > 0) {
                if (string.indexOf("x") > -1 || string.indexOf("X") > -1) {
                    this.m_hex = false;
                    this.m_numeric = true;
                }
                if (string.indexOf("/") > -1) {
                    this.m_pad = false;
                    return;
                }
            } else {
                String string2 = this.getText();
                if (string2.endsWith("x") || string2.endsWith("X")) {
                    this.m_hex = false;
                    this.m_numeric = true;
                    return;
                }
                if (string2.endsWith("/")) {
                    this.m_pad = false;
                }
            }
        }
    }

    private boolean isSetHexKey(int n) {
        boolean bl = false;
        if (n == 88 && this.getText().equals("0")) {
            bl = true;
            this.m_hex = true;
            this.m_numeric = false;
        }
        return bl;
    }

    private boolean isSetPadKey(int n) {
        if (n == 47 && !this.m_pad) {
            this.m_pad = true;
            return true;
        }
        return false;
    }

    private void checkBounds() {
        long l = this.m_min;
        String string = this.getText();
        if (string.length() > 0) {
            try {
                if (this.m_numeric) {
                    l = Long.parseLong(string);
                } else if (this.m_hex) {
                    l = Long.parseLong(string, 16);
                }
                if (l > this.m_max) {
                    if (this.m_numeric) {
                        ((TextComponent)this).setText(Long.toString(this.m_max));
                    } else if (this.m_hex) {
                        ((TextComponent)this).setText(Long.toHexString(this.m_max));
                    }
                    this.selectAll();
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (l < this.m_min) {
                    if (this.m_numeric) {
                        ((TextComponent)this).setText(Long.toString(this.m_min));
                    } else if (this.m_hex) {
                        ((TextComponent)this).setText(Long.toHexString(this.m_min));
                    }
                    this.selectAll();
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.select(0, 0);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                ((TextComponent)this).setText("");
                return;
            }
        }
    }

    private boolean checkPasteHex() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            return false;
        }
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!this.isHexChar(c)) {
                    return false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return true;
    }

    private boolean checkPasteNumeric() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            return false;
        }
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isDigit(c) && c != '/') {
                    return false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return true;
    }

    protected boolean isHexChar(char c) {
        if (c == '/') {
            return true;
        }
        if (Character.toLowerCase(c) == 'x') {
            return true;
        }
        return super.isHexChar(c);
    }
}

