/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.forms.LECustomPlansForm;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LECustomPlan;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEClipboard;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;

public class LECustomPlansView
extends LETableView {
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_UP = "up";
    public static final String ACTION_DOWN = "down";
    Button m_up;
    Button m_down;

    public LECustomPlansView() {
        this.m_form = new LECustomPlansForm();
        LEClipboard.GetClipboard().addObserver(this);
    }

    public void setContext(String string, LEVector lEVector) {
        this.m_form.setContext(string, lEVector);
        this.m_form.addListener(this);
        this.m_panel = new LEScrollPanel(this.m_form);
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 5, 10, 10));
        Button button = new Button("Save");
        panel.add(button);
        button.setActionCommand(ACTION_SAVE);
        button.addActionListener(this);
        button = new Button("Add...");
        panel.add(button);
        button.setActionCommand("add");
        button.addActionListener(this);
        this.m_edit = new Button("Edit...");
        panel.add(this.m_edit);
        this.m_edit.setActionCommand("edit");
        this.m_edit.addActionListener(this);
        this.m_edit.setEnabled(false);
        this.m_delete = new Button("Delete");
        panel.add(this.m_delete);
        this.m_delete.setActionCommand("delete");
        this.m_delete.addActionListener(this);
        this.m_delete.setEnabled(false);
        button = new Button("Refresh");
        panel.add(button);
        button.setActionCommand("refresh");
        button.addActionListener(this);
        this.m_up = new Button("Up");
        panel.add(this.m_up);
        this.m_up.setActionCommand(ACTION_UP);
        this.m_up.addActionListener(this);
        this.m_up.setEnabled(false);
        this.m_down = new Button("Down");
        panel.add(this.m_down);
        this.m_down.setActionCommand(ACTION_DOWN);
        this.m_down.addActionListener(this);
        this.m_down.setEnabled(false);
        this.m_buttons.add(panel);
    }

    public void handleAction(String string) {
        if (string.equals(ACTION_SAVE)) {
            this.save();
            return;
        }
        if (string.equals(ACTION_UP)) {
            ((LECustomPlansForm)this.m_form).up();
            return;
        }
        if (string.equals(ACTION_DOWN)) {
            ((LECustomPlansForm)this.m_form).down();
            return;
        }
        super.handleAction(string);
    }

    public void save() {
        ((LECustomPlansForm)this.m_form).save(LEUiUtils.GetBaseFrame());
    }

    public void going() {
        this.m_form.deleteListener(this);
        LEClipboard.GetClipboard().deleteObserver(this);
    }

    public void gone() {
        this.m_form.gone();
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_form.setPortMasters(lEPortMasterArray);
    }

    boolean pasteable(Object object) {
        LEVector lEVector;
        if (object instanceof LEVector && (lEVector = (LEVector)object).size() > 0) {
            object = lEVector.elementAt(0);
        }
        return object instanceof LECustomPlan;
    }

    void edit(int n) {
        if (this.m_listener == null) {
            return;
        }
        String string = this.m_form.getCellString(n, 0);
        String string2 = this.m_form.getCellString(n, 1);
        this.m_listener.onLEViewEvent(new LEConfigViewEvent(1, this.m_form.getTable(string), string2));
    }

    void setState() {
        int[] nArray = this.m_form.getSelectedRows();
        int n = this.m_form.getNumberOfPM();
        if (nArray.length > 0) {
            if (this.m_delete != null) {
                this.m_delete.setEnabled(true);
            }
            if (this.m_edit != null) {
                if (nArray.length == 1) {
                    this.m_edit.setEnabled(true);
                } else {
                    this.m_edit.setEnabled(false);
                }
            }
            if (this.m_up != null) {
                if (nArray.length == 1 && n == 1) {
                    if (nArray[0] == 0) {
                        this.m_up.setEnabled(false);
                    } else {
                        this.m_up.setEnabled(true);
                    }
                } else {
                    this.m_up.setEnabled(false);
                }
            }
            if (this.m_down != null) {
                if (nArray.length == 1 && n == 1) {
                    if (nArray[0] == this.m_form.getNumRows() - 1) {
                        this.m_down.setEnabled(false);
                    } else {
                        this.m_down.setEnabled(true);
                    }
                } else {
                    this.m_down.setEnabled(false);
                }
            }
        } else {
            if (this.m_delete != null) {
                this.m_delete.setEnabled(false);
            }
            if (this.m_edit != null) {
                this.m_edit.setEnabled(false);
            }
            if (this.m_up != null) {
                this.m_up.setEnabled(false);
            }
            if (this.m_down != null) {
                this.m_down.setEnabled(false);
            }
        }
        this.checkClipboard();
    }

    void copy() {
        int[] nArray = this.m_form.getSelectedRows();
        if (nArray.length > 1) {
            LEVector lEVector = new LEVector();
            int n = 0;
            while (n < nArray.length) {
                Object object = this.m_form.getEntry(nArray[n]);
                if (object instanceof LEConfig) {
                    object = ((LEConfig)object).clone();
                }
                lEVector.addElement(object);
                ++n;
            }
            LEClipboard.GetClipboard().setContents(lEVector);
            return;
        }
        if (nArray.length == 1) {
            Object object = this.m_form.getEntry(nArray[0]);
            if (object instanceof LEConfig) {
                object = ((LEConfig)object).clone();
            }
            LEClipboard.GetClipboard().setContents(object);
        }
    }

    void paste() {
        Object object = LEClipboard.GetClipboard().getContents();
        if (object != null) {
            this.m_form.paste(object);
        }
    }

    void delete() {
        this.m_form.delete();
    }

    void checkClipboard() {
        int[] nArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        LEClipboard lEClipboard = LEClipboard.GetClipboard();
        Object object = lEClipboard.getContents();
        if (this.pasteable(object)) {
            bl3 = true;
        }
        if ((nArray = this.m_form.getSelectedRows()).length > 0) {
            bl2 = true;
            if (this.m_delete != null) {
                bl = true;
                bl4 = true;
            }
        }
        lEClipboard.setState(bl, bl2, bl3, bl4);
    }
}

