/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEAlarmFactory;
import com.lucent.ra.nms.backend.LEAlarmMessage;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEVector;
import java.util.Hashtable;

public class LEMonAlarmsView
extends LEMonitorPanel {
    static int[] s_monitors = null;
    Hashtable m_alarms = new Hashtable();

    public LEMonAlarmsView() {
        this.m_buttons.remove(this.m_reset);
        this.m_buttons.remove(this.m_restore);
        this.initialize(1, 1, 4);
        this.setCellJustification(2, 2);
        this.setCellJustification(3, 2);
        this.setCellJustification(4, 2);
        this.m_resetCols = new int[1];
        this.m_resetCols[0] = 4;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEAlarmMessage) {
            this.updateAlarm(string, (LEAlarmMessage)object);
            this.repaint();
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    public void updateStatus(String string, LEStatusMessage lEStatusMessage) {
        super.updateStatus(string, lEStatusMessage);
        if (lEStatusMessage.getStatus() == 1) {
            LEPortMaster lEPortMaster = this.getPM(string);
            if (lEPortMaster == null) {
                return;
            }
            LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
            if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
                return;
            }
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            lEPMConnectionFacade.getAlarms();
        }
    }

    void updateAlarm(String string, LEAlarmMessage lEAlarmMessage) {
        String string2 = lEAlarmMessage.getName();
        String string3 = lEAlarmMessage.getState();
        Integer n = this.getRow(string, string2);
        if (n == null) {
            if (!string3.equals("Cleared")) {
                this.createRow(string, string2, lEAlarmMessage);
                return;
            }
        } else {
            if (string3.equals("Cleared")) {
                this.deleteRow(n);
                return;
            }
            this.updateRow(string, n, lEAlarmMessage);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Message");
        objectArray[n2++] = new String("Severity");
        objectArray[n2++] = new String("Time");
        objectArray[n2++] = new String("Count");
    }

    void createRow(String string, String string2, LEAlarmMessage lEAlarmMessage) {
        String[] stringArray = new String[this.getNumColumns()];
        int n = 0;
        LEPortMaster lEPortMaster = this.getPM(string);
        stringArray[n++] = lEPortMaster.getDescription();
        stringArray[n++] = lEAlarmMessage.getMessage();
        stringArray[n++] = lEAlarmMessage.getSeverity();
        lEAlarmMessage.checkForTicks(lEPortMaster.getSoftwareVersion());
        stringArray[n++] = lEAlarmMessage.getFormatedTime();
        stringArray[n++] = Long.toString(lEAlarmMessage.getCount());
        this.addRow(string, string2, stringArray);
    }

    void updateRow(String string, int n, LEAlarmMessage lEAlarmMessage) {
        int n2 = 0;
        int n3 = ++n2;
        this.setCellString(n, n3, lEAlarmMessage.getMessage());
        int n4 = ++n2;
        this.setCellString(n, n4, lEAlarmMessage.getSeverity());
        lEAlarmMessage.checkForTicks(this.getPM(string).getSoftwareVersion());
        int n5 = ++n2;
        ++n2;
        this.setCellString(n, n5, lEAlarmMessage.getFormatedTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellString(n, n2, lEMonitorData.getCounter(n2, lEAlarmMessage.getCount()).toString());
        ++n2;
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonAlarmsView.s_monitors[0] = 655360;
        }
        return s_monitors;
    }

    void startMonitoringNow(LEPortMaster lEPortMaster, String string) {
        if (!lEPortMaster.isConnected()) {
            return;
        }
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        String string2 = lEPortMaster.getResourceID();
        LEVector lEVector = lEPMConnectionFacade.getAlarms();
        int n = lEVector == null ? 0 : lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            this.updateAlarm(string2, (LEAlarmMessage)lEVector.elementAt(n2));
            ++n2;
        }
        this.repaint();
        LEAlarmFactory.GetFactory().addObserver(string2, this);
        LEStatusFactory.GetFactory().addObserver(string2, this);
    }

    void stopMonitoringNow(LEPortMaster lEPortMaster, String string) {
        String string2 = lEPortMaster.getResourceID();
        LEAlarmFactory.GetFactory().deleteObserver(string2, this);
        LEStatusFactory.GetFactory().deleteObserver(string2, this);
        this.remove(string2);
        this.repaint();
    }

    String getMonitorName() {
        return "Monitor Alarms";
    }
}

