/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSFlatFile_R;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LECipher;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.util.Date;

public class LEDSSFlatFile_RI
extends UnicastRemoteObject
implements LEDSSFlatFile_R {
    protected static final String PASSWORD_KEY = "## PASS_ENC ";
    private static final String PASSWORD = "password";
    private static final String USER_PASSWORD = "set\\s+user\\s+\\w*\\s+password\\s+(\\S+)";
    private static final String LOC_PASSWORD = "set\\s+location\\s+\\w*\\s+password\\s+(\\S+)";
    private static final String RADIUS_SECRET = "set\\s+secret\\s+(\\S+)";
    private static final String CHOICENET_SECRET = "set\\s+choicenet-secret\\s+(\\S+)";
    private static final String RIP_PASSWORD = "set\\s+rip-password\\s+\\\"([a-zA-Z _0-9]*)";
    private static final String REV_RIP_PASSWORD = "set\\s+rip-password\\s+\\\"(\\S*)\\\"";
    private static final String OSPF_MD5SECRET = "set\\s+ospf area\\s+\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}\\s+md5\\s+\\w*\\s+(\\S+)";
    private static final String OSPF_PASSWORD = "set\\s+ospf area\\s+\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}\\s+password\\s+(\\S+)";
    private static final String CALL_PASSWORD = "set\\s+call-check\\s+password\\s+(\\S*)";
    String m_fullpath;
    String m_id;
    BufferedReader m_reader;
    BufferedWriter m_writer;
    int m_mode;
    Perl5Matcher m_matcher;
    Perl5Pattern m_locpasswordPattern;
    Perl5Pattern m_userpasswordPattern;
    Perl5Pattern m_radiussecretPattern;
    Perl5Pattern m_choicesecretPattern;
    Perl5Pattern m_rippasswordPattern;
    Perl5Pattern m_revrippasswordPattern;
    Perl5Pattern m_ospfmd5secretPattern;
    Perl5Pattern m_ospfpasswordPattern;
    Perl5Pattern m_callpasswordPattern;

    public LEDSSFlatFile_RI(String fullpath, int mode) throws RemoteException {
        this.m_fullpath = fullpath;
        this.m_id = LEResourceID.CreateFile_ID(fullpath);
        this.m_mode = mode;
        this.m_matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_locpasswordPattern = (Perl5Pattern)compiler.compile(LOC_PASSWORD, 1);
            this.m_userpasswordPattern = (Perl5Pattern)compiler.compile(USER_PASSWORD, 1);
            this.m_radiussecretPattern = (Perl5Pattern)compiler.compile(RADIUS_SECRET, 1);
            this.m_choicesecretPattern = (Perl5Pattern)compiler.compile(CHOICENET_SECRET, 1);
            this.m_rippasswordPattern = (Perl5Pattern)compiler.compile(RIP_PASSWORD, 1);
            this.m_revrippasswordPattern = (Perl5Pattern)compiler.compile(REV_RIP_PASSWORD, 1);
            this.m_ospfmd5secretPattern = (Perl5Pattern)compiler.compile(OSPF_MD5SECRET, 1);
            this.m_ospfpasswordPattern = (Perl5Pattern)compiler.compile(OSPF_PASSWORD, 1);
            this.m_callpasswordPattern = (Perl5Pattern)compiler.compile(CALL_PASSWORD, 1);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public String getResourceID() throws RemoteException {
        return this.m_id;
    }

    public void writeHeader() throws RemoteException {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        prw.println('#');
        prw.println("# PortMaster Configuration File");
        prw.println('#');
        prw.print("# This file was generated by: ");
        prw.print(LEAppInfo.getAppName());
        prw.print(" v");
        prw.println(LEAppInfo.getAppVersion());
        prw.print("# ");
        Date date = new Date();
        DateFormat format = DateFormat.getDateTimeInstance(3, 1);
        prw.println(format.format(date));
        prw.println('#');
        prw.println("# NOTE: User passwords, RADIUS and ChoiceNet secrets");
        prw.println("#       are encrypted and saved if allowed by user.");
        prw.println("#       Location passwords, RIP passwords and OSPF ");
        prw.println("#       area passwords and secrets are encrypted.");
        prw.println("#       Security Association (SA) keys are not saved.");
        prw.println("#       The administrator !root password is not saved.");
        prw.println('#');
        prw.println("# DO NOT EDIT");
        prw.println('#');
    }

    /*
     * Unable to fully structure code
     */
    public void writeComments(String comments) throws RemoteException {
        if (this.m_writer == null || comments == null) {
            return;
        }
        prw = new PrintWriter(this.m_writer);
        len = comments.length();
        ptr = 0;
        last = 0;
        ** GOTO lbl14
        {
            ++ptr;
            do {
                if (ptr < len && comments.charAt(ptr) != '\n') continue block0;
                prw.print("# ");
                prw.println(comments.substring(last, ptr++));
                last = ptr;
lbl14:
                // 2 sources

            } while (ptr < len);
        }
        prw.println('#');
        prw.flush();
    }

    public synchronized void writeSection(String section, LEVector commands) throws RemoteException {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        prw.println('#');
        prw.print("# ");
        prw.println(section);
        prw.println('#');
        int len = 0;
        if (commands != null) {
            len = commands.size();
        }
        int i = 0;
        while (i < len) {
            this.writeCommand(prw, (String)commands.elementAt(i));
            ++i;
        }
        prw.flush();
        prw = null;
    }

    public synchronized void writeConfig(LEVector commands) throws RemoteException {
        if (this.m_writer == null || commands == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        int len = commands.size();
        int i = 0;
        while (i < len) {
            String command = (String)commands.elementAt(i);
            this.writeCommand(prw, command);
            ++i;
        }
        prw.flush();
        prw = null;
    }

    public synchronized LEVector getCommands() throws RemoteException {
        return this.loadCommands();
    }

    public boolean isConnected() throws RemoteException {
        return this.m_reader != null || this.m_writer != null;
    }

    public void disconnect() throws RemoteException {
        try {
            if (this.m_reader != null) {
                this.m_reader.close();
                this.m_reader = null;
            } else if (this.m_writer != null) {
                this.m_writer.close();
                this.m_writer = null;
            }
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void connect() throws IOException, RemoteException {
        if (this.m_mode == 0 && this.m_reader == null) {
            if (this.m_fullpath == null) {
                throw new IOException("Null path");
            }
            File file = new File(this.m_fullpath);
            try {
                FileReader reader = new FileReader(file);
                this.m_reader = new BufferedReader(reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.m_reader = null;
                String msg = String.valueOf(this.m_fullpath) + " not found";
                throw new IOException(msg);
            }
            catch (SecurityException securityException) {
                this.m_reader = null;
                String msg = "No permission to read " + this.m_fullpath;
                throw new IOException(msg);
            }
        } else if (this.m_mode == 1 && this.m_writer == null) {
            if (this.m_fullpath == null) {
                PrintWriter pw = new PrintWriter(System.out, true);
                try {
                    this.m_writer = new BufferedWriter(pw);
                    this.writeHeader();
                }
                catch (SecurityException securityException) {
                    this.m_writer = null;
                    String msg = "No permission to write to stdout";
                    throw new IOException(msg);
                }
            } else {
                File file = new File(this.m_fullpath);
                try {
                    FileWriter writer = new FileWriter(file);
                    this.m_writer = new BufferedWriter(writer);
                    this.writeHeader();
                }
                catch (IOException e) {
                    this.m_writer = null;
                    throw e;
                }
                catch (SecurityException securityException) {
                    this.m_writer = null;
                    String msg = "No permission to write to " + this.m_fullpath;
                    throw new IOException(msg);
                }
            }
        } else {
            LEDebug.getLog().log(30, "Connect called when already connected to: ");
            LEDebug.getLog().log(30, this.m_fullpath);
        }
    }

    protected LEVector loadCommands() {
        LEVector cmds = new LEVector();
        try {
            String line = this.m_reader.readLine();
            while (line != null) {
                if (line.length() > 3) {
                    if (line.startsWith(PASSWORD_KEY)) {
                        line = this.convertPasswordLine(line);
                    }
                    cmds.addElement(line);
                }
                line = this.m_reader.readLine();
            }
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
        }
        return cmds;
    }

    protected String convertPasswordLine(String line) {
        try {
            if (this.m_matcher.contains(line, (Pattern)this.m_userpasswordPattern) || this.m_matcher.contains(line, (Pattern)this.m_locpasswordPattern) || this.m_matcher.contains(line, (Pattern)this.m_radiussecretPattern) || this.m_matcher.contains(line, (Pattern)this.m_choicesecretPattern) || this.m_matcher.contains(line, (Pattern)this.m_revrippasswordPattern) || this.m_matcher.contains(line, (Pattern)this.m_ospfmd5secretPattern) || this.m_matcher.contains(line, (Pattern)this.m_ospfpasswordPattern) || this.m_matcher.contains(line, (Pattern)this.m_callpasswordPattern)) {
                MatchResult result = this.m_matcher.getMatch();
                int loc = result.begin(1) + PASSWORD_KEY.length();
                String password = line.substring(PASSWORD_KEY.length(), loc);
                String encrypt = result.group(1);
                if (encrypt.length() > 0) {
                    password = String.valueOf(password) + LECipher.Decrypt(encrypt);
                    if (this.m_matcher.contains(line, (Pattern)this.m_revrippasswordPattern)) {
                        password = String.valueOf(password) + "\"";
                    }
                    line = password;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return line;
    }

    protected void writeCommand(PrintWriter prw, String command) {
        try {
            if (this.m_matcher.contains(command, (Pattern)this.m_userpasswordPattern) || this.m_matcher.contains(command, (Pattern)this.m_locpasswordPattern) || this.m_matcher.contains(command, (Pattern)this.m_radiussecretPattern) || this.m_matcher.contains(command, (Pattern)this.m_choicesecretPattern) || this.m_matcher.contains(command, (Pattern)this.m_rippasswordPattern) || this.m_matcher.contains(command, (Pattern)this.m_ospfmd5secretPattern) || this.m_matcher.contains(command, (Pattern)this.m_ospfpasswordPattern) || this.m_matcher.contains(command, (Pattern)this.m_callpasswordPattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String pass = result.group(1);
                if (pass.length() > 16) {
                    command = "## ERROR - Password is longer than allowed length of 16 characters and has not been saved.";
                } else {
                    int loc = result.begin(1);
                    if (loc == -1) {
                        loc = command.length();
                        if (this.m_matcher.contains(command, (Pattern)this.m_rippasswordPattern)) {
                            --loc;
                        }
                    }
                    StringBuffer password = new StringBuffer();
                    password.append(PASSWORD_KEY);
                    password.append(command.substring(0, loc));
                    password.append(LECipher.Encrypt(pass));
                    if (this.m_matcher.contains(command, (Pattern)this.m_rippasswordPattern)) {
                        password.append("\"");
                    }
                    command = password.toString();
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        prw.println(command);
    }
}

