/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEMonModemsMessage;
import com.lucent.ra.nms.backend.LEMonSessionsMessage;
import com.lucent.ra.nms.util.LEMessageType;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.Serializable;

public class LEEntityFilter
implements Serializable {
    LEVector m_conditions = new LEVector();

    private int getCount() {
        return this.m_conditions.size();
    }

    private int getAttrAt(int idx) {
        Condition cond = (Condition)this.m_conditions.elementAt(idx);
        return cond.m_attr;
    }

    private String getStringValueAt(int idx) {
        Condition cond = (Condition)this.m_conditions.elementAt(idx);
        return cond.m_string;
    }

    private int getIntValueAt(int idx) {
        Condition cond = (Condition)this.m_conditions.elementAt(idx);
        return cond.m_int;
    }

    public void addCondition(int attr, String value) {
        Condition cond = new Condition(attr, value);
        this.m_conditions.add(cond);
    }

    public void addCondition(int attr, int value) {
        Condition cond = new Condition(attr, value);
        this.m_conditions.add(cond);
    }

    public boolean match(LEMessageType msg) {
        boolean success;
        block27: {
            int attrCount;
            block26: {
                success = true;
                attrCount = this.getCount();
                if (!(msg instanceof LEMonSessionsMessage)) break block26;
                LEMonSessionsMessage sessMsg = (LEMonSessionsMessage)msg;
                int idx = 0;
                while (idx < attrCount && success) {
                    int attr = this.getAttrAt(idx);
                    String testStr = this.getStringValueAt(idx);
                    switch (attr) {
                        case 493: {
                            success = sessMsg.getCalledNo().equals(testStr);
                            break;
                        }
                        case 275: {
                            success = sessMsg.getBoard().equals(testStr);
                            break;
                        }
                        case 23: {
                            success = sessMsg.getModem().equals(testStr);
                            break;
                        }
                        case 1: {
                            success = sessMsg.getPortName().equals(testStr);
                            break;
                        }
                        case 3: {
                            success = sessMsg.getHostname().equals(testStr);
                            break;
                        }
                        case 482: {
                            success = sessMsg.getL2TPTunnelId().equals(testStr);
                            break;
                        }
                    }
                    ++idx;
                }
                break block27;
            }
            if (!(msg instanceof LEMonModemsMessage)) break block27;
            LEMonModemsMessage modemMsg = (LEMonModemsMessage)msg;
            int idx = 0;
            while (idx < attrCount && success) {
                int attr = this.getAttrAt(idx);
                String testStr = this.getStringValueAt(idx);
                int testInt = this.getIntValueAt(idx);
                switch (attr) {
                    case 275: {
                        success = modemMsg.getBoard().equals(testStr);
                        break;
                    }
                    case 11: {
                        success = LEResourceID.ExtractHost(modemMsg.getResourceID()).equals(testStr);
                        break;
                    }
                    case 40: {
                        success = modemMsg.getPortName().equals(testStr);
                        break;
                    }
                    case 41: {
                        success = modemMsg.getState().equals(testStr);
                        break;
                    }
                    case 42: {
                        success = modemMsg.getProtocol().equals(testStr);
                        break;
                    }
                    case 43: {
                        success = modemMsg.getCompression().equals(testStr);
                        break;
                    }
                    case 44: {
                        success = modemMsg.getRXRate().equals(testStr);
                        break;
                    }
                    case 45: {
                        success = modemMsg.getTXRate().equals(testStr);
                        break;
                    }
                    case 46: {
                        success = modemMsg.getRXCount() == testInt;
                        break;
                    }
                    case 47: {
                        success = modemMsg.getTXCount() == testInt;
                        break;
                    }
                    case 48: {
                        success = modemMsg.getRenegotiate() == testInt;
                        break;
                    }
                    case 49: {
                        success = modemMsg.getRetrain() == testInt;
                        break;
                    }
                    case 50: {
                        success = modemMsg.getCalls() == testInt;
                        break;
                    }
                    case 493: {
                        success = modemMsg.getCalledNo().equals(testStr);
                        break;
                    }
                }
                ++idx;
            }
        }
        return success;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int attrCount = this.getCount();
        int idx = 0;
        while (idx < attrCount) {
            int attr = this.getAttrAt(idx);
            buff.append(attr);
            buff.append(" = ");
            String stringValue = this.getStringValueAt(idx);
            if (stringValue != null) {
                buff.append(stringValue);
            } else {
                buff.append(this.getIntValueAt(idx));
            }
            ++idx;
        }
        return buff.toString();
    }

    class Condition
    implements Serializable {
        public int m_attr;
        public String m_string;
        public boolean m_is_int;
        public int m_int;

        Condition(int attr, String value) {
            LEEntityFilter.this = LEEntityFilter.this;
            this.m_attr = attr;
            this.m_is_int = false;
            this.m_string = value;
        }

        Condition(int attr, int value) {
            LEEntityFilter.this = LEEntityFilter.this;
            this.m_attr = attr;
            this.m_is_int = true;
            this.m_int = value;
        }
    }
}

