/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import java.io.Serializable;

public class LEPortIOMessage
extends LEEntityMessage
implements Serializable {
    long m_time;
    String m_state;
    String m_modemStatus;
    long m_inBytes;
    long m_outBytes;
    long m_pendingBytes;
    long m_overrunErrors;
    long m_parityErrors;
    long m_framingErrors;
    long m_sessionTermination;
    long m_disconnectCode;
    String m_destination;
    String m_user;

    public LEPortIOMessage(String id, int request, String name) {
        super(id, request, name);
        this.m_messageType = "MONITOR";
        this.m_user = "";
    }

    public String getResourceID() {
        return this.m_id;
    }

    public long getTimestamp() {
        return this.m_time;
    }

    public String getPortName() {
        return this.m_name;
    }

    public String getState() {
        return this.m_state;
    }

    public String getModemStatus() {
        return this.m_modemStatus;
    }

    public long getInputBytes() {
        return this.m_inBytes;
    }

    public long getOutputBytes() {
        return this.m_outBytes;
    }

    public long getPendingBytes() {
        return this.m_pendingBytes;
    }

    public long getOverrunErrors() {
        return this.m_overrunErrors;
    }

    public long getParityErrors() {
        return this.m_parityErrors;
    }

    public long getFramingErrors() {
        return this.m_framingErrors;
    }

    public long getSessionTermination() {
        return this.m_sessionTermination;
    }

    public long getDisconnectCode() {
        return this.m_disconnectCode;
    }

    public String getDestination() {
        return this.m_destination;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public void setTimestamp(long timestamp) {
        this.m_time = timestamp;
    }

    public void setPortName(String name) {
        this.m_name = name;
    }

    public void setState(String state) {
        this.m_state = state;
    }

    public void setModemStatus(String status) {
        this.m_modemStatus = status;
    }

    public void setInputBytes(long bytes) {
        this.m_inBytes = bytes;
    }

    public void setOutputBytes(long bytes) {
        this.m_outBytes = bytes;
    }

    public void setPendingBytes(long bytes) {
        this.m_pendingBytes = bytes;
    }

    public void setOverrunErrors(long errors) {
        this.m_overrunErrors = errors;
    }

    public void setParityErrors(long errors) {
        this.m_parityErrors = errors;
    }

    public void setFramingErrors(long errors) {
        this.m_framingErrors = errors;
    }

    public void setSessionTermination(long errors) {
        this.m_sessionTermination = errors;
    }

    public void setDisconnectCode(long errors) {
        this.m_disconnectCode = errors;
    }

    public void setDestination(String destination) {
        this.m_destination = destination;
    }

    public void setAttribute(int attribute, String value) {
        try {
            switch (attribute) {
                case 275: {
                    this.setBoard(value);
                    break;
                }
                case 1: {
                    this.setName(value);
                    break;
                }
                case 96: {
                    this.m_state = value;
                    break;
                }
                case 20: {
                    this.m_inBytes = Long.parseLong(value);
                    break;
                }
                case 21: {
                    this.m_outBytes = Long.parseLong(value);
                    break;
                }
                case 22: {
                    this.m_pendingBytes = Long.parseLong(value);
                    break;
                }
                case 545: {
                    this.m_parityErrors = Long.parseLong(value);
                    break;
                }
                case 544: {
                    this.m_overrunErrors = Long.parseLong(value);
                    break;
                }
                case 543: {
                    this.m_framingErrors = Long.parseLong(value);
                    break;
                }
                case 74: {
                    this.m_destination = value;
                    break;
                }
                case 2: {
                    this.m_user = value;
                    break;
                }
                case 41: {
                    this.m_modemStatus = value;
                    break;
                }
                case 261: {
                    this.m_sessionTermination = Long.parseLong(value, 16);
                    break;
                }
                case 262: {
                    this.m_disconnectCode = Long.parseLong(value, 16);
                    break;
                }
                case 560: {
                    this.setStartReceived();
                    break;
                }
                case 561: {
                    this.setEndReceived();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

