/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEIPIPSA;
import com.lucent.ra.nms.model.LEIPIPSAs;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEIPSecProfileRule;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEIPSecSA;
import com.lucent.ra.nms.model.LEIPSecSAs;
import com.lucent.ra.nms.model.LEProxySA;
import com.lucent.ra.nms.model.LEProxySAs;
import com.lucent.ra.nms.model.LESA;
import com.lucent.ra.nms.model.LESAs;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;

public class LEVPNFileParser {
    private static final String ADD_SA_STRING = "add\\s+sa\\s+(\\S+)";
    private static final String PROPOSAL_STRING = "set\\s+sa\\s+(\\S+)\\s+sec-p\\w*\\s+(\\S+)\\s*(\\S*)";
    private static final String ESP_IN_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-inb\\w*-key\\s+(\\S+)";
    private static final String ESP_OUT_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-outb\\w*-key\\s+(\\S+)";
    private static final String ESP_IN_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-inb\\w*-spi\\s+(\\S+)";
    private static final String ESP_OUT_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-outb\\w*-spi\\s+(\\S+)";
    private static final String AH_IN_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-inb\\w*-key\\s+(\\S+)";
    private static final String AH_OUT_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-outb\\w*-key\\s+(\\S+)";
    private static final String AH_IN_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-inb\\w*-spi\\s+(\\S+)";
    private static final String AH_OUT_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-outb\\w*-spi\\s+(\\S+)";
    private static final String SA_LOCALADDR_STRING = "set\\s+sa\\s+(\\S+)\\s+local\\S*\\s+(\\S+)";
    private static final String SA_LOCALPROXY_STRING = "set\\s+sa\\s+(\\S+)\\s+proxy-localp\\w*\\s+(\\S+)";
    private static final String SA_DESTPROXY_STRING = "set\\s+sa\\s+(\\S+)\\s+proxy-destp\\w*\\s+(\\S+)";
    private static final String SA_IPSECMODE_STRING = "set\\s+sa\\s+(\\S+)\\s+mo\\w*\\s+sec-ipip\\S*";
    private static final String SA_IPIPMODE_STRING = "set\\s+sa\\s+(\\S+)\\s+mo\\w*\\s+ipip\\S*";
    private static final String SA_PROXYMODE_STRING = "set\\s+sa\\s+(\\S+)\\s+mo\\w*\\s+pr\\S*";
    private static final String SA_PROXY_SECRET_STRING = "set\\s+sa\\s+(\\S+)\\s+proxy-secret\\s+(\\S+)";
    private static final String SA_PEER_IDENT_STRING = "set\\s+sa\\s+(\\S+)\\s+peer\\S*\\s+(\\S+)";
    private static final String ADD_PROFILE_STRING = "add\\s+sec-prof\\w*\\s+(\\S+)";
    private static final String SEC_PFILTER_STRING = "set\\s+sec-prof\\w*\\s+(\\S+)\\s+(\\d+)\\s+p\\S*f\\w*\\s+(\\S+)";
    private static final String SEC_SA_STRING = "set\\s+sec-prof\\w*\\s+(\\S+)\\s+(\\d+)\\s+static\\S+\\s+(\\S+)";
    LESAs m_sas = new LESAs(null);
    LESA m_sa;
    LEIPSecSAs m_ipsecsas = new LEIPSecSAs(null);
    LEIPIPSAs m_ipipsas = new LEIPIPSAs(null);
    LEProxySAs m_proxysas = new LEProxySAs(null);
    LETable m_table;
    LEIPSecProfiles m_profiles;
    LEIPSecProfile m_profile;
    LEIPSecProfileRule m_profileRule;
    String m_name;
    String m_mode;
    Perl5Matcher m_matcher;
    MatchResult m_result;
    Perl5Pattern m_addsaPattern;
    Perl5Pattern m_proposalPattern;
    Perl5Pattern m_espinkeyPattern;
    Perl5Pattern m_espoutkeyPattern;
    Perl5Pattern m_espinspiPattern;
    Perl5Pattern m_espoutspiPattern;
    Perl5Pattern m_ahinkeyPattern;
    Perl5Pattern m_ahoutkeyPattern;
    Perl5Pattern m_ahinspiPattern;
    Perl5Pattern m_ahoutspiPattern;
    Perl5Pattern m_salocaladdrPattern;
    Perl5Pattern m_salocalproxyPattern;
    Perl5Pattern m_sadestproxyPattern;
    Perl5Pattern m_saipsecmodePattern;
    Perl5Pattern m_saipipmodePattern;
    Perl5Pattern m_saproxymodePattern;
    Perl5Pattern m_saproxysecretPattern;
    Perl5Pattern m_sapeeridentPattern;
    Perl5Pattern m_addprofilePattern;
    Perl5Pattern m_secfilterPattern;
    Perl5Pattern m_secsaPattern;

    public LEVPNFileParser() {
        this.m_sas.setField("ipsec", this.m_ipsecsas);
        this.m_sas.setField("ipip", this.m_ipipsas);
        this.m_sas.setField("proxy", this.m_proxysas);
        this.m_table = new LETable(null);
        this.m_profiles = new LEIPSecProfiles(null);
        this.m_matcher = new Perl5Matcher();
        this.m_name = "";
    }

    public boolean createPatterns() {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            this.m_addsaPattern = (Perl5Pattern)perl5Compiler.compile(ADD_SA_STRING, 1);
            this.m_proposalPattern = (Perl5Pattern)perl5Compiler.compile(PROPOSAL_STRING, 1);
            this.m_espinkeyPattern = (Perl5Pattern)perl5Compiler.compile(ESP_IN_KEY_STRING, 1);
            this.m_espoutkeyPattern = (Perl5Pattern)perl5Compiler.compile(ESP_OUT_KEY_STRING, 1);
            this.m_espinspiPattern = (Perl5Pattern)perl5Compiler.compile(ESP_IN_SPI_STRING, 1);
            this.m_espoutspiPattern = (Perl5Pattern)perl5Compiler.compile(ESP_OUT_SPI_STRING, 1);
            this.m_ahinkeyPattern = (Perl5Pattern)perl5Compiler.compile(AH_IN_KEY_STRING, 1);
            this.m_ahoutkeyPattern = (Perl5Pattern)perl5Compiler.compile(AH_OUT_KEY_STRING, 1);
            this.m_ahinspiPattern = (Perl5Pattern)perl5Compiler.compile(AH_IN_SPI_STRING, 1);
            this.m_ahoutspiPattern = (Perl5Pattern)perl5Compiler.compile(AH_OUT_SPI_STRING, 1);
            this.m_salocaladdrPattern = (Perl5Pattern)perl5Compiler.compile(SA_LOCALADDR_STRING, 1);
            this.m_salocalproxyPattern = (Perl5Pattern)perl5Compiler.compile(SA_LOCALPROXY_STRING, 1);
            this.m_sadestproxyPattern = (Perl5Pattern)perl5Compiler.compile(SA_DESTPROXY_STRING, 1);
            this.m_saipsecmodePattern = (Perl5Pattern)perl5Compiler.compile(SA_IPSECMODE_STRING, 1);
            this.m_saipipmodePattern = (Perl5Pattern)perl5Compiler.compile(SA_IPIPMODE_STRING, 1);
            this.m_saproxymodePattern = (Perl5Pattern)perl5Compiler.compile(SA_PROXYMODE_STRING, 1);
            this.m_saproxysecretPattern = (Perl5Pattern)perl5Compiler.compile(SA_PROXY_SECRET_STRING, 1);
            this.m_sapeeridentPattern = (Perl5Pattern)perl5Compiler.compile(SA_PEER_IDENT_STRING, 1);
            this.m_addprofilePattern = (Perl5Pattern)perl5Compiler.compile(ADD_PROFILE_STRING, 1);
            this.m_secfilterPattern = (Perl5Pattern)perl5Compiler.compile(SEC_PFILTER_STRING, 1);
            this.m_secsaPattern = (Perl5Pattern)perl5Compiler.compile(SEC_SA_STRING, 1);
        }
        catch (MalformedPatternException malformedPatternException) {
            LEDebug.getLog().logln(20, malformedPatternException);
            return false;
        }
        return true;
    }

    public void readVPN(LEVector lEVector) {
        int n = lEVector.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                String string = (String)lEVector.elementAt(n2);
                if (!string.startsWith("#") && string.length() >= 3 && !string.equals("save all")) {
                    int n3 = string.length();
                    String string2 = string.substring(3, n3).toLowerCase();
                    if (string.regionMatches(true, 0, "add ", 0, 4)) {
                        MatchResult matchResult;
                        if (this.m_matcher.contains(string, (Pattern)this.m_addsaPattern)) {
                            matchResult = this.m_matcher.getMatch();
                            this.addSA(matchResult.group(1));
                        } else if (this.m_matcher.contains(string, (Pattern)this.m_addprofilePattern)) {
                            matchResult = this.m_matcher.getMatch();
                            this.addSecProfile(matchResult.group(1));
                        }
                    } else if (string.regionMatches(true, 0, "set ", 0, 4)) {
                        this.parseVPN(string);
                    }
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public LESAs getSecurityAssociations() {
        return this.m_sas;
    }

    public LEIPSecProfiles getSecProfiles() {
        return this.m_profiles;
    }

    protected void setSA(MatchResult matchResult) {
        String string = matchResult.group(1);
        if (!string.equals(this.m_name)) {
            this.m_sa = this.m_sas.getSA(string);
            this.m_name = string;
        }
        if (this.m_sa == null) {
            this.m_sa = (LESA)this.m_table.get(string);
        }
    }

    protected void setSAParameter(String string, MatchResult matchResult) {
        this.setSA(matchResult);
        String string2 = matchResult.group(2);
        if (string2 != null && this.m_sa != null) {
            this.m_sa.setField(string, matchResult.group(2));
        }
    }

    protected void setIPSecModeParameter(MatchResult matchResult) {
        String string = matchResult.group(1);
        this.setSA(matchResult);
        LEIPSecSA lEIPSecSA = new LEIPSecSA(null, string);
        lEIPSecSA.copy(this.m_sa);
        lEIPSecSA.setField("289", "sec-ipip-tunnel");
        this.m_ipsecsas.setField(string, lEIPSecSA);
        this.m_sa = lEIPSecSA;
    }

    protected void setIPIPModeParameter(MatchResult matchResult) {
        String string = matchResult.group(1);
        this.setSA(matchResult);
        LEIPIPSA lEIPIPSA = new LEIPIPSA(null, string);
        lEIPIPSA.copy(this.m_sa);
        lEIPIPSA.setField("289", "ipip-tunnel");
        this.m_ipipsas.setField(string, lEIPIPSA);
        this.m_sa = lEIPIPSA;
    }

    protected void setProxyModeParameter(MatchResult matchResult) {
        String string = matchResult.group(1);
        this.setSA(matchResult);
        LEProxySA lEProxySA = new LEProxySA(null, string);
        lEProxySA.copy(this.m_sa);
        lEProxySA.setField("289", "proxy-tunnel");
        this.m_proxysas.setField(string, lEProxySA);
        this.m_sa = lEProxySA;
    }

    protected void addSA(String string) {
        this.m_sa = new LESA(null, string);
        this.m_table.set(string, this.m_sa);
    }

    protected void addSecProfile(String string) {
        this.m_profile = new LEIPSecProfile(null, string);
        this.m_profiles.setField(string, this.m_profile);
    }

    protected void setProfileRule(MatchResult matchResult) {
        String string = matchResult.group(1);
        this.m_profile = (LEIPSecProfile)this.m_profiles.get(string);
        String string2 = matchResult.group(2);
        this.m_profileRule = (LEIPSecProfileRule)this.m_profile.get(string2);
        if (this.m_profileRule == null) {
            this.m_profileRule = new LEIPSecProfileRule(null, string, string2);
            this.m_profile.setField(string2, this.m_profileRule);
        }
    }

    protected void setProfileParameter(String string, MatchResult matchResult) {
        this.setProfileRule(matchResult);
        if (this.m_profileRule != null) {
            String string2 = matchResult.group(3);
            this.m_profileRule.setField(string, string2);
        }
    }

    protected void parseVPN(String string) {
        try {
            if (this.m_matcher.contains(string, (Pattern)this.m_proposalPattern)) {
                MatchResult matchResult = this.m_matcher.getMatch();
                String string2 = matchResult.group(2);
                String string3 = matchResult.group(3);
                this.setSA(matchResult);
                if (string2.startsWith("esp")) {
                    this.m_sa.setField("226", string2);
                    if (string3 != null) {
                        this.m_sa.setField("227", string3);
                        return;
                    }
                } else {
                    this.m_sa.setField("227", string2);
                }
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_saipsecmodePattern)) {
                this.setIPSecModeParameter(this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_saipipmodePattern)) {
                this.setIPIPModeParameter(this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_saproxymodePattern)) {
                this.setProxyModeParameter(this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_espinkeyPattern)) {
                this.setSAParameter("232", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_espoutkeyPattern)) {
                this.setSAParameter("234", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_espinspiPattern)) {
                this.setSAParameter("228", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_espoutspiPattern)) {
                this.setSAParameter("230", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ahinkeyPattern)) {
                this.setSAParameter("233", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ahoutkeyPattern)) {
                this.setSAParameter("235", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ahinspiPattern)) {
                this.setSAParameter("229", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ahoutspiPattern)) {
                this.setSAParameter("231", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_salocaladdrPattern)) {
                this.setSAParameter("236", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_salocalproxyPattern)) {
                this.setSAParameter("238", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_sadestproxyPattern)) {
                this.setSAParameter("239", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_sapeeridentPattern)) {
                this.setSAParameter("74", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_secfilterPattern)) {
                this.setProfileParameter("505", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_secsaPattern)) {
                this.setProfileParameter("506", this.m_matcher.getMatch());
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }
}

