/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEMonModemsMessage;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEModem;
import com.lucent.ra.nms.model.LEPortMaster;

public class LEMonModemsView
extends LEMonitorDetailPanel {
    static int[] s_monitors = null;

    public LEMonModemsView() {
        this.initialize(1, 3, 11);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 8;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[5];
        int n3 = 0;
        while (n3 < 5) {
            this.m_resetCols[n3] = n3 + 9;
            ++n3;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null || !this.validMessage(string, object)) {
            return;
        }
        if (object instanceof LEMonModemsMessage) {
            LEMonModemsMessage lEMonModemsMessage = (LEMonModemsMessage)object;
            if (!this.isCurrentBoard(lEMonModemsMessage.getBoard())) {
                return;
            }
            if (lEMonModemsMessage.getName().equals("M")) {
                return;
            }
            String string2 = String.valueOf(lEMonModemsMessage.getBoard()) + lEMonModemsMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n == null) {
                this.createRow(string, string2, lEMonModemsMessage);
            } else {
                this.updateRow(n, lEMonModemsMessage);
            }
            this.repaint();
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("Modem");
        objectArray[n2++] = new String("Port");
        objectArray[n2++] = new String("State");
        objectArray[n2++] = new String("Protocol");
        objectArray[n2++] = new String("Compression");
        objectArray[n2++] = new String("RD Rate");
        objectArray[n2++] = new String("TR Rate");
        objectArray[n2++] = new String("RD Count");
        objectArray[n2++] = new String("TR Count");
        objectArray[n2++] = new String("Renegotiate");
        objectArray[n2++] = new String("Retrain");
        objectArray[n2++] = new String("Calls");
    }

    void createRow(String string, String string2, LEMonModemsMessage lEMonModemsMessage) {
        LEPortMaster lEPortMaster = this.getPM(string);
        if (lEPortMaster == null) {
            return;
        }
        String[] stringArray = new String[14];
        int n = 0;
        stringArray[n++] = lEPortMaster.getDescription();
        stringArray[n++] = lEMonModemsMessage.getBoard();
        stringArray[n++] = lEMonModemsMessage.getName();
        stringArray[n++] = lEMonModemsMessage.getPortName();
        stringArray[n++] = LEModem.GetStateString(LEModem.ConvertState(lEMonModemsMessage.getState(), false, false));
        stringArray[n++] = lEMonModemsMessage.getProtocol();
        stringArray[n++] = lEMonModemsMessage.getCompression();
        stringArray[n++] = lEMonModemsMessage.getRXRate();
        stringArray[n++] = lEMonModemsMessage.getTXRate();
        stringArray[n++] = Long.toString(lEMonModemsMessage.getRXCount());
        stringArray[n++] = Long.toString(lEMonModemsMessage.getTXCount());
        stringArray[n++] = Long.toString(lEMonModemsMessage.getRenegotiate());
        stringArray[n++] = Long.toString(lEMonModemsMessage.getRetrain());
        stringArray[n++] = Long.toString(lEMonModemsMessage.getCalls());
        this.addRow(string, string2, stringArray);
    }

    void updateRow(int n, LEMonModemsMessage lEMonModemsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        int n3 = ++n2;
        this.setCellString(n, n3, lEMonModemsMessage.getPortName());
        int n4 = ++n2;
        this.setCellString(n, n4, LEModem.GetStateString(LEModem.ConvertState(lEMonModemsMessage.getState(), false, false)));
        int n5 = ++n2;
        this.setCellString(n, n5, lEMonModemsMessage.getProtocol());
        int n6 = ++n2;
        this.setCellString(n, n6, lEMonModemsMessage.getCompression());
        int n7 = ++n2;
        this.setCellString(n, n7, lEMonModemsMessage.getRXRate());
        int n8 = ++n2;
        ++n2;
        this.setCellString(n, n8, lEMonModemsMessage.getTXRate());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellString(n, n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getRXCount()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getTXCount()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getRenegotiate()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getRetrain()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getCalls()).toString());
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonModemsView.s_monitors[0] = 196608;
        }
        return s_monitors;
    }

    boolean isValidBoardType(String string) {
        return string.equals("Quad T1") || string.equals("Tri E1");
    }

    String getMonitorName() {
        return "Monitor Modem Details";
    }
}

