/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LETreeItem;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewTree;
import java.io.IOException;
import java.util.Hashtable;

public class LEControlTree
extends LEViewTree {
    public static final String ALARMS = new String("alarms");
    public static final String BINDING = new String("binding");
    public static final String COMMAND = new String("command");
    public static final String CONFIG = new String("config");
    public static final String DEBUG = new String("debug");
    public static final String DETAILS = new String("details");
    public static final String DIAGNOSE = new String("diagnose");
    public static final String ETHERS_GRAPH = new String("ethers_graph");
    public static final String GRAPHS = new String("graph");
    public static final String IFACES = new String("interfaces");
    public static final String INSTALL = new String("install");
    public static final String LINES = new String("lines");
    public static final String L2TP = new String("l2tp");
    public static final String L2TP_SESSIONS = new String("l2tp_sessions");
    public static final String L2TP_TUNNELS = new String("l2tp_tunnels");
    public static final String MAINTAIN = new String("maintain");
    public static final String MODEM_GRAPH = new String("modem_graph");
    public static final String MODEM_SUM = new String("modem_summary");
    public static final String MODEMS = new String("modems");
    public static final String MONITOR = new String("monitor");
    public static final String MON_ETHERS = new String("mon_ethers");
    public static final String MUX_CHANNELS = new String("mux_channels");
    public static final String MUX_STATS = new String("mux_stats");
    public static final String NAT_SESS = new String("nat_sess");
    public static final String NAT_STATS = new String("nat_stats");
    public static final String NET_CONN = new String("net_conn");
    public static final String OSPF_NEIGHBOR = new String("ospf_neighbor");
    public static final String OSPF_LINKS = new String("ospf_links");
    public static final String RESTORE = new String("restore");
    public static final String ROOT = "pm";
    public static final String SAVE = new String("save");
    public static final String SESSION_GRAPH = new String("session_graph");
    public static final String SESSION_SUM = new String("session_summary");
    public static final String SESSIONS = new String("sessions");
    public static final String STATUS = new String("status");
    public static final String SUMMARY = new String("summary");
    public static final String SYSLOG = new String("syslog");
    public static final String TOTALS = new String("totals");
    public static final String UPGRADE = new String("upgrade");
    public static final String MON_USERS = new String("mon_users");
    public static final String ITSROOT = "its";
    public static final String RTXROOT = "rtx";
    Hashtable m_roots = new Hashtable();

    public LEControlTree(Hashtable hashtable) {
        Hashtable<String, LETreeItem> hashtable2 = new Hashtable<String, LETreeItem>();
        this.m_roots.put(ROOT, hashtable2);
        String string = (String)hashtable.get(ROOT);
        LETreeItem lETreeItem = this.createItem(null, "PortMaster", ROOT, this.determineCollapse(string));
        hashtable2.put(ROOT, lETreeItem);
        string = (String)hashtable.get(ROOT + MONITOR);
        LETreeItem lETreeItem2 = this.createItem(lETreeItem, "Monitor", MONITOR, this.determineCollapse(string));
        hashtable2.put(MONITOR, lETreeItem2);
        this.createItem(lETreeItem2, "Chassis", STATUS);
        this.createItem(lETreeItem2, "Users", MON_USERS);
        this.createItem(lETreeItem2, "Modem Summary", MODEM_SUM);
        this.createItem(lETreeItem2, "Modem Details", MODEMS);
        this.createItem(lETreeItem2, "Session Summary", SESSION_SUM);
        this.createItem(lETreeItem2, "Session Details", SESSIONS);
        this.createItem(lETreeItem2, "Lines", LINES);
        this.createItem(lETreeItem2, "Interfaces", IFACES);
        this.createItem(lETreeItem2, "Alarms", ALARMS);
        this.createItem(lETreeItem2, "NAT Sessions", NAT_SESS);
        this.createItem(lETreeItem2, "NAT Statistics", NAT_STATS);
        this.createItem(lETreeItem2, "OSPF Neighbors", OSPF_NEIGHBOR);
        this.createItem(lETreeItem2, "Network Connections", NET_CONN);
        this.createItem(lETreeItem2, "MUX Channels", MUX_CHANNELS);
        this.createItem(lETreeItem2, "MUX Stats", MUX_STATS);
        this.createItem(lETreeItem2, "Ethernet", MON_ETHERS);
        this.createItem(lETreeItem2, "DHCP Bindings", BINDING);
        string = (String)hashtable.get(ROOT + L2TP);
        LETreeItem lETreeItem3 = this.createItem(lETreeItem2, "L2TP", L2TP, this.determineCollapse(string));
        hashtable2.put(L2TP, lETreeItem3);
        this.createItem(lETreeItem3, "L2TP Tunnels", L2TP_TUNNELS);
        this.createItem(lETreeItem3, "L2TP Sessions", L2TP_SESSIONS);
        string = (String)hashtable.get(ROOT + GRAPHS);
        lETreeItem3 = this.createItem(lETreeItem, "Graph", GRAPHS, this.determineCollapse(string));
        hashtable2.put(GRAPHS, lETreeItem3);
        this.createItem(lETreeItem3, "Modems", MODEM_GRAPH);
        this.createItem(lETreeItem3, "Sessions", SESSION_GRAPH);
        string = (String)hashtable.get(ROOT + DIAGNOSE);
        lETreeItem3 = this.createItem(lETreeItem, "Diagnose", DIAGNOSE, this.determineCollapse(string));
        hashtable2.put(DIAGNOSE, lETreeItem3);
        this.createItem(lETreeItem3, "Debug", DEBUG);
        string = (String)hashtable.get(ROOT + MAINTAIN);
        lETreeItem3 = this.createItem(lETreeItem, "Maintain", MAINTAIN, this.determineCollapse(string));
        hashtable2.put(MAINTAIN, lETreeItem3);
        this.createItem(lETreeItem3, "Back Up", SAVE);
        this.createItem(lETreeItem3, "Restore", RESTORE);
        this.createItem(lETreeItem3, "Upgrade", UPGRADE);
        LETreeItem lETreeItem4 = this.createItem(lETreeItem, "Command", COMMAND);
        lETreeItem4 = this.createConfigTree(lETreeItem, ROOT, (String)hashtable.get(ROOT + CONFIG));
        hashtable2.put(CONFIG, lETreeItem4);
        this.addTree(lETreeItem);
        Hashtable<String, LETreeItem> hashtable3 = new Hashtable<String, LETreeItem>();
        this.m_roots.put(RTXROOT, hashtable3);
        string = (String)hashtable.get(RTXROOT);
        LETreeItem lETreeItem5 = this.createItem(null, "INA", RTXROOT, this.determineCollapse(string));
        hashtable3.put(RTXROOT, lETreeItem5);
        string = (String)hashtable.get(RTXROOT + MONITOR);
        LETreeItem lETreeItem6 = this.createItem(lETreeItem5, "Monitor", MONITOR, this.determineCollapse(string));
        this.createItem(lETreeItem6, "Ethernet", MON_ETHERS);
        this.createItem(lETreeItem6, "Lines", LINES);
        this.createItem(lETreeItem6, "Alarms", ALARMS);
        this.createItem(lETreeItem6, "NAT Sessions", NAT_SESS);
        this.createItem(lETreeItem6, "NAT Statistics", NAT_STATS);
        this.createItem(lETreeItem6, "DHCP Bindings", BINDING);
        string = (String)hashtable.get(RTXROOT + MAINTAIN);
        lETreeItem3 = this.createItem(lETreeItem5, "Maintain", MAINTAIN, this.determineCollapse(string));
        hashtable3.put(MAINTAIN, lETreeItem3);
        this.createItem(lETreeItem3, "Back Up", SAVE);
        this.createItem(lETreeItem3, "Restore", RESTORE);
        this.createItem(lETreeItem3, "Upgrade", UPGRADE);
        lETreeItem4 = this.createItem(lETreeItem5, "Command", COMMAND);
        lETreeItem4 = this.createConfigTree(lETreeItem5, RTXROOT, (String)hashtable.get(RTXROOT + CONFIG));
        hashtable3.put(CONFIG, lETreeItem4);
        this.addTree(lETreeItem5);
    }

    public boolean selectChild(LEConfig lEConfig, String string, String string2, boolean bl) {
        LETreeItem lETreeItem = this.findChild(this.getSelectedItem(), lEConfig, string, string2);
        if (lETreeItem == null) {
            return false;
        }
        this.select(lETreeItem, bl);
        return true;
    }

    LETreeItem createConfigTree(LETreeItem lETreeItem, String string, String string2) {
        LETreeItem lETreeItem2 = null;
        try {
            LEDataSpec lEDataSpec = LEDataSpecFactory.GetSpec(string);
            if (lEDataSpec != null && lEDataSpec.getAllSpecs() != null) {
                lETreeItem2 = this.createItem(lETreeItem, "Configure", CONFIG, this.determineCollapse(string2));
                this.addSpec(lETreeItem2, lEDataSpec);
            }
        }
        catch (IOException iOException) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), iOException.getMessage());
            LEDebug.getLog().logln(20, iOException);
        }
        return lETreeItem2;
    }

    void addSpec(LETreeItem lETreeItem, LEDataSpec lEDataSpec) {
        LEVector lEVector = lEDataSpec.getAllSpecs();
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n2);
            if (lEDataSpec2.getAllSpecs() != null) {
                LETreeItem lETreeItem2 = this.createItem(lETreeItem, lEDataSpec2.getDescription(), lEDataSpec2.getTag());
                if (lEDataSpec2.getSpecFor("entry") == null) {
                    this.addSpec(lETreeItem2, lEDataSpec2);
                    if (lETreeItem2.m_children != null) {
                        lETreeItem2.m_collapsed = true;
                    }
                }
            }
            ++n2;
        }
    }

    LETreeItem findChild(LETreeItem lETreeItem, LEConfig lEConfig, String string, String string2) {
        LETreeItem lETreeItem2 = null;
        if (lETreeItem.m_children != null) {
            int n = lETreeItem.m_children.size();
            int n2 = 0;
            while (n2 < n) {
                lETreeItem2 = (LETreeItem)lETreeItem.m_children.elementAt(n2);
                if (string.equals((String)lETreeItem2.m_object)) break;
                lETreeItem2 = null;
                ++n2;
            }
        }
        if (lETreeItem2 == null && lEConfig != null) {
            LEDataSpec lEDataSpec = lEConfig.getSpecFor(string);
            if (lEConfig instanceof LETable) {
                if (lETreeItem.m_children != null) {
                    lETreeItem.m_children.removeAllElements();
                }
                lETreeItem2 = new LETreeItem(string2, string);
                if (lEDataSpec != null && lEDataSpec.getAllSpecs() != null) {
                    this.addSpec(lETreeItem2, lEDataSpec);
                }
                lETreeItem.addChild(lETreeItem2);
            }
            if (lETreeItem2 == null) {
                lETreeItem2 = new LETreeItem(string2, string);
                if (lEDataSpec != null && lEDataSpec.getAllSpecs() != null) {
                    this.addSpec(lETreeItem2, lEDataSpec);
                }
                lETreeItem.addChild(lETreeItem2);
            }
        }
        lETreeItem.m_collapsed = false;
        this.recalcTree();
        return lETreeItem2;
    }

    Hashtable getTreeSettings() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = (Hashtable)this.m_roots.get(ROOT);
        LETreeItem lETreeItem = (LETreeItem)hashtable2.get(ROOT);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(ROOT, "off");
        } else {
            hashtable.put(ROOT, "on");
        }
        lETreeItem = (LETreeItem)hashtable2.get(MONITOR);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(ROOT + MONITOR, "off");
        } else {
            hashtable.put(ROOT + MONITOR, "on");
        }
        lETreeItem = (LETreeItem)hashtable2.get(L2TP);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(ROOT + L2TP, "off");
        } else {
            hashtable.put(ROOT + L2TP, "on");
        }
        lETreeItem = (LETreeItem)hashtable2.get(GRAPHS);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(ROOT + GRAPHS, "off");
        } else {
            hashtable.put(ROOT + GRAPHS, "on");
        }
        lETreeItem = (LETreeItem)hashtable2.get(DIAGNOSE);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(ROOT + DIAGNOSE, "off");
        } else {
            hashtable.put(ROOT + DIAGNOSE, "on");
        }
        lETreeItem = (LETreeItem)hashtable2.get(MAINTAIN);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(ROOT + MAINTAIN, "off");
        } else {
            hashtable.put(ROOT + MAINTAIN, "on");
        }
        lETreeItem = (LETreeItem)hashtable2.get(CONFIG);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(ROOT + CONFIG, "off");
        } else {
            hashtable.put(ROOT + CONFIG, "on");
        }
        Hashtable hashtable3 = (Hashtable)this.m_roots.get(RTXROOT);
        lETreeItem = (LETreeItem)hashtable3.get(RTXROOT);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(RTXROOT, "off");
        } else {
            hashtable.put(RTXROOT, "on");
        }
        lETreeItem = (LETreeItem)hashtable3.get(MONITOR);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(RTXROOT + MONITOR, "off");
        } else {
            hashtable.put(RTXROOT + MONITOR, "on");
        }
        lETreeItem = (LETreeItem)hashtable3.get(MAINTAIN);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(RTXROOT + MAINTAIN, "off");
        } else {
            hashtable.put(RTXROOT + MAINTAIN, "on");
        }
        lETreeItem = (LETreeItem)hashtable3.get(CONFIG);
        if (lETreeItem != null && lETreeItem.m_collapsed) {
            hashtable.put(RTXROOT + CONFIG, "off");
        } else {
            hashtable.put(RTXROOT + CONFIG, "on");
        }
        return hashtable;
    }

    protected boolean determineCollapse(String string) {
        return string == null || !string.equals("on");
    }
}

