/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.bootp;

import COM.livingston.util.LEByteArray;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEOctets;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class LEBootPPacket {
    public static final int PACKET_SIZE = 300;
    public static final int CLIENT_HARDWARE_ADDRESS_LENGTH = 16;
    public static final int SERVER_HOSTNAME_LENGTH = 64;
    public static final int FILENAME_LENGTH = 128;
    public static final int VENDOR_INFO_LENGTH = 64;
    byte m_opcode;
    byte m_hardwareType;
    byte m_hardwareAddressLength;
    byte m_hopCount;
    int m_transactionID;
    short m_numberSeconds;
    short m_pad;
    int m_clientIPAddress;
    int m_yourIPAddress;
    int m_serverIPAddress;
    int m_gatewayIPAddress;
    byte[] m_clientHardwareAddress = new byte[16];
    String m_serverHostname;
    String m_bootFilename;
    byte[] m_vendorInfo;

    public LEBootPPacket() {
        this.m_serverHostname = new String("");
        this.m_bootFilename = new String("");
        this.m_vendorInfo = new byte[64];
    }

    public LEBootPPacket(byte[] byArray) {
        this.m_vendorInfo = new byte[64];
        this.readData(byArray);
    }

    void readData(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            this.m_opcode = dataInputStream.readByte();
            this.m_hardwareType = dataInputStream.readByte();
            this.m_hardwareAddressLength = dataInputStream.readByte();
            this.m_hopCount = dataInputStream.readByte();
            this.m_transactionID = dataInputStream.readInt();
            this.m_numberSeconds = dataInputStream.readShort();
            this.m_pad = dataInputStream.readShort();
            this.m_clientIPAddress = dataInputStream.readInt();
            this.m_yourIPAddress = dataInputStream.readInt();
            this.m_serverIPAddress = dataInputStream.readInt();
            this.m_gatewayIPAddress = dataInputStream.readInt();
            byte[] byArray2 = new byte[300];
            dataInputStream.read(this.m_clientHardwareAddress, 0, 16);
            dataInputStream.read(byArray2, 0, 64);
            this.m_serverHostname = new String(byArray2, 0, 64);
            dataInputStream.read(byArray2, 0, 128);
            this.m_bootFilename = new String(byArray2, 0, 128);
            dataInputStream.read(this.m_vendorInfo, 0, 64);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void setRequest() {
        this.m_opcode = 1;
    }

    public void setReply() {
        this.m_opcode = (byte)2;
    }

    public void setHardware(byte by, byte by2) {
        this.m_hardwareType = by;
        this.m_hardwareAddressLength = by2;
    }

    public void setClientIPAddress(LEOctets lEOctets) {
        this.m_clientIPAddress = lEOctets.toInt();
    }

    public void setYourIPAddress(LEOctets lEOctets) {
        this.m_yourIPAddress = lEOctets.toInt();
    }

    public void setServerIPAddress(LEOctets lEOctets) {
        this.m_serverIPAddress = lEOctets.toInt();
    }

    public void setGatewayIPAddress(LEOctets lEOctets) {
        this.m_gatewayIPAddress = lEOctets.toInt();
    }

    public void setClientHardwareAddress(byte[] byArray) {
        LEByteArray.CopyBytes(byArray, this.m_clientHardwareAddress, 0, byArray.length);
    }

    public void setServerHostName(String string) {
        this.m_serverHostname = new String(string);
    }

    public void setBootFilename(String string) {
        this.m_bootFilename = new String(string);
    }

    public void setVendorInfo(byte[] byArray) {
        LEByteArray.CopyBytes(byArray, this.m_vendorInfo, 0, 64);
    }

    public byte[] dumpData() {
        byte[] byArray = new byte[300];
        int n = 0;
        byArray[n++] = this.m_opcode;
        byArray[n++] = this.m_hardwareType;
        byArray[n++] = this.m_hardwareAddressLength;
        byArray[n++] = this.m_hopCount;
        LEByteArray.CopyInt(this.m_transactionID, byArray, n);
        LEByteArray.CopyShort(this.m_numberSeconds, byArray, n += 4);
        LEByteArray.CopyShort(this.m_pad, byArray, n += 2);
        LEByteArray.CopyInt(this.m_clientIPAddress, byArray, n += 2);
        LEByteArray.CopyInt(this.m_yourIPAddress, byArray, n += 4);
        LEByteArray.CopyInt(this.m_serverIPAddress, byArray, n += 4);
        LEByteArray.CopyInt(this.m_gatewayIPAddress, byArray, n += 4);
        LEByteArray.CopyBytes(this.m_clientHardwareAddress, byArray, n += 4, 16);
        LEByteArray.CopyBytes(this.m_serverHostname.getBytes(), byArray, n += 16, this.m_serverHostname.length());
        LEByteArray.CopyBytes(this.m_bootFilename.getBytes(), byArray, n += 64, this.m_bootFilename.length());
        LEByteArray.CopyBytes(this.m_vendorInfo, byArray, n += 128, 64);
        n += 64;
        return byArray;
    }

    public boolean isRequest() {
        return this.m_opcode == 1;
    }

    public boolean isReply() {
        return this.m_opcode == 2;
    }

    public int size() {
        return 300;
    }

    public byte getHardwareType() {
        return this.m_hardwareType;
    }

    public byte getHardwareAddressLength() {
        return this.m_hardwareAddressLength;
    }

    public byte getHopCount() {
        return this.m_hopCount;
    }

    public LEOctets getClientIPAddress() {
        LEOctets lEOctets = new LEOctets(this.m_clientIPAddress);
        return lEOctets;
    }

    public LEOctets getYourIPAddress() {
        LEOctets lEOctets = new LEOctets(this.m_yourIPAddress);
        return lEOctets;
    }

    public LEOctets getServerIPAddress() {
        LEOctets lEOctets = new LEOctets(this.m_serverIPAddress);
        return lEOctets;
    }

    public LEOctets getGatewayIPAddress() {
        LEOctets lEOctets = new LEOctets(this.m_gatewayIPAddress);
        return lEOctets;
    }

    public byte[] getClientHardwareAddress() {
        return this.m_clientHardwareAddress;
    }

    public String getServerHostName() {
        return this.m_serverHostname;
    }

    public String getBootFilename() {
        return this.m_bootFilename;
    }

    public byte[] getVendorInfo() {
        return this.m_vendorInfo;
    }
}

