/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Vector;

class PopupHandler
implements LayoutManager2 {
    private boolean _dontInvalidate;
    private LayoutManager _wrappedLayout;
    private Vector _popups = new Vector(1);

    public void setLayout(LayoutManager layoutManager) {
        this._wrappedLayout = layoutManager;
    }

    public void addPopup(Container container, Component component) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                this._popups.addElement(component);
                component.setVisible(false);
                this._dontInvalidate = true;
                container.add(component, this._popups.size() - 1);
                this._dontInvalidate = false;
            }
            return;
        }
    }

    public void showPopup(Container container, Component component, int n, int n2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                Dimension dimension = container.getSize();
                Dimension dimension2 = component.getSize();
                if (n + dimension2.width > dimension.width) {
                    n = dimension.width - dimension2.width;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n2 + dimension2.height > dimension.height) {
                    n2 = dimension.height - dimension2.height;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                this._dontInvalidate = true;
                component.setLocation(n, n2);
                component.setVisible(true);
                this._dontInvalidate = false;
            }
            return;
        }
    }

    public void removePopup(Container container, Component component) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                if (this._popups.contains(component)) {
                    this._popups.removeElement(component);
                    Rectangle rectangle = component.getBounds();
                    this._dontInvalidate = true;
                    container.remove(component);
                    this._dontInvalidate = false;
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
            return;
        }
    }

    public void setPopupBounds(Container container, Component component, int n, int n2, int n3, int n4) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this._dontInvalidate = true;
            component.setBounds(n, n2, n3, n4);
            this._dontInvalidate = false;
            return;
        }
    }

    public boolean shouldInvalidate() {
        return !this._dontInvalidate;
    }

    public void addLayoutComponent(String string, Component component) {
        if (!this._popups.contains(component) && this._wrappedLayout != null) {
            this._wrappedLayout.addLayoutComponent(string, component);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (!this._popups.contains(component) && this._wrappedLayout != null) {
            this._wrappedLayout.removeLayoutComponent(component);
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this._wrappedLayout != null) {
            Dimension dimension = this._wrappedLayout.preferredLayoutSize(container);
            return dimension;
        }
        return container.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this._wrappedLayout != null) {
            Dimension dimension = this._wrappedLayout.minimumLayoutSize(container);
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container container) {
        if (this._wrappedLayout != null) {
            this._removeAllPopups(container);
            this._wrappedLayout.layoutContainer(container);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!this._popups.contains(component) && this._wrappedLayout != null) {
            if (this._wrappedLayout instanceof LayoutManager2) {
                ((LayoutManager2)this._wrappedLayout).addLayoutComponent(component, object);
                return;
            }
            this.addLayoutComponent((String)object, component);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            Dimension dimension = ((LayoutManager2)this._wrappedLayout).maximumLayoutSize(container);
            return dimension;
        }
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            return ((LayoutManager2)this._wrappedLayout).getLayoutAlignmentX(container);
        }
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            return ((LayoutManager2)this._wrappedLayout).getLayoutAlignmentY(container);
        }
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            ((LayoutManager2)this._wrappedLayout).invalidateLayout(container);
        }
    }

    private void _removeAllPopups(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                this._dontInvalidate = true;
                int n = this._popups.size();
                int n2 = 0;
                while (n2 < n) {
                    container.remove((Component)this._popups.elementAt(n2));
                    ++n2;
                }
                this._popups.removeAllElements();
                this._dontInvalidate = false;
            }
            return;
        }
    }
}

