/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabBar;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarEvent;
import oracle.ewt.tabBar.TabBarValidateEvent;

public class TabBarItem
implements ImageObserver {
    private String _label;
    private Image _image;
    private TabBar _parent;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private boolean _disabled;
    private boolean _selected;
    private boolean _hidden;
    private int _imageWd;
    private int _imageHt;

    public TabBarItem(String string) {
        this._label = string;
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public Rectangle getOuterBounds() {
        Point point = this.getParent().convertCanvasToOuter(0, 0);
        return new Rectangle(this._x + point.x, this._y + point.y, this._width, this._height);
    }

    public synchronized void setEnabled(boolean bl) {
        if (bl == this._disabled) {
            TabBar tabBar;
            boolean bl2 = false;
            if (!bl && this.isEnabled()) {
                bl2 = true;
            }
            boolean bl3 = this._disabled = !bl;
            if (bl && this.isEnabled()) {
                bl2 = true;
            }
            if (!bl && this.isSelected() && (tabBar = this.getParent()) != null) {
                tabBar._moveSelection(true);
            }
            if (bl2) {
                this.repaint();
            }
        }
    }

    public synchronized void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            TabBar tabBar = this.getParent();
            if (!bl && this.isSelected() && tabBar != null) {
                tabBar._moveSelection(true);
            }
            boolean bl2 = this._hidden = !bl;
            if (tabBar != null) {
                tabBar.invalidateCanvas();
            }
        }
    }

    public boolean contains(int n, int n2) {
        return n >= this._x && n < this._x + this._width && n2 >= this._y && n2 < this._y + this._height;
    }

    public boolean isVisible() {
        return !this._hidden;
    }

    public boolean isEnabled() {
        TabBar tabBar;
        boolean bl = this.isItemEnabled();
        if (bl && (tabBar = this.getParent()) != null) {
            bl = tabBar.isEnabled();
        }
        return bl;
    }

    public Dimension getSize() {
        return new Dimension(this._width, this._height);
    }

    public int indexOf() {
        TabBar tabBar = this.getParent();
        if (tabBar == null) {
            return -1;
        }
        return this.getParent().getIndexOf(this);
    }

    public String getLabel() {
        return this._label;
    }

    public Image getIcon() {
        return this._image;
    }

    TabBar getParent() {
        return this._parent;
    }

    public void setIcon(Image image) {
        if (image != this._image) {
            if (image == null) {
                this._image = null;
                this.setImageSize(0, 0);
                return;
            }
            this._image = image;
            TabBarItem tabBarItem = this;
            synchronized (tabBarItem) {
                this.setImageSize(image.getWidth(this), image.getHeight(this));
                return;
            }
        }
    }

    public void setLabel(String string) {
        this._label = string;
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            tabBar.invalidateCanvas();
        }
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            int n6 = this._imageWd;
            int n7 = this._imageHt;
            if ((n & 1) != 0) {
                n6 = n4;
            }
            if ((n & 2) != 0) {
                n7 = n5;
            }
            this.setImageSize(n6, n7);
        }
        if ((n & 0x20) != 0) {
            this.repaint();
            return false;
        }
        return true;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean bl) {
        if (bl != this.isSelected()) {
            TabBar tabBar = this.getParent();
            if (!bl) {
                this._selected = false;
                if (tabBar != null) {
                    tabBar.itemDeselected(this);
                }
                this.repaint();
                return;
            }
            if (tabBar != null) {
                TabBarValidateEvent tabBarValidateEvent = new TabBarValidateEvent(tabBar, 2000, this);
                tabBar.dispatchEvent(tabBarValidateEvent);
                if (!tabBarValidateEvent.isCancelled()) {
                    this.makeSelected();
                    tabBar.scrollIntoView(this);
                    this.repaint();
                }
            }
        }
    }

    public void setSize(int n, int n2) {
        this._width = n;
        this._height = n2;
    }

    public void setLocation(int n, int n2) {
        this._x = n;
        this._y = n2;
    }

    public void repaint() {
        TabBar tabBar = this.getParent();
        if (tabBar == null) {
            return;
        }
        int n = this.getParent().getAllowedHorizGrowth();
        tabBar.repaintCanvas(this._x - n, this._y, this._width + 2 * n + 1, this._height);
    }

    protected void makeSelected() {
        this._selected = true;
        TabBar tabBar = this.getParent();
        if (tabBar != null) {
            tabBar.dispatchEvent(new TabBarEvent(tabBar, 2001, this));
        }
    }

    protected void mousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.isItemEnabled() && this.contains(n, n2) && !this.isSelected()) {
            this.setSelected(true);
        }
    }

    protected synchronized void setImageSize(int n, int n2) {
        if (n != this._imageWd || n2 != this._imageHt) {
            this._imageWd = n;
            this._imageHt = n2;
            TabBar tabBar = this.getParent();
            if (tabBar != null) {
                tabBar.invalidateCanvas();
            }
        }
    }

    protected boolean isItemEnabled() {
        return !this._disabled;
    }

    void setParent(TabBar tabBar) {
        this._parent = tabBar;
    }
}

