/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAsyncMessage;
import COM.livingston.backend.LEDebugMessage;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LETokenizer;
import COM.livingston.util.LEVector;
import java.io.EOFException;

public class LEDebugFactory
extends LEAMFactory {
    public static final String DEBUG = "DEBUG";
    static LEDebugFactory s_factory = null;

    public static LEAMFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEDebugFactory();
        }
        return s_factory;
    }

    public static void Register() {
        LEDebugFactory.GetFactory();
    }

    LEDebugFactory() {
        LEAMFactory.GetFactory().register(DEBUG, this);
    }

    protected void produce(LEAsyncMessage msg, LEVector observers) {
        if (observers == null) {
            return;
        }
        LETokenizer tok = (LETokenizer)msg.getData();
        if (tok == null) {
            return;
        }
        int request = -1;
        try {
            request = tok.getNextInt();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            return;
        }
        String host = msg.getHost();
        long timestamp = msg.getTimestamp();
        try {
            while (true) {
                int tmp = tok.getNextInt();
                String value = tok.getNextQuotedString();
                if (tmp != 120) continue;
                this.notify(observers, host, new LEDebugMessage(request, timestamp, value, host));
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

