/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.bootp;

import COM.livingston.bootp.LEBootPClient;
import COM.livingston.bootp.LEBootPPacket;
import COM.livingston.bootp.LEBootPServer;
import java.net.SocketException;

public class LEBootPPacketHandler
implements LEBootPClient {
    public static final byte[] LE_VENDOR_CODE = new byte[]{0, -64, 5};

    public LEBootPPacketHandler() throws SecurityException, SocketException {
        LEBootPServer.GetServer().setClient(this);
    }

    public void receivedPacket(LEBootPPacket lEBootPPacket) {
        if (this.isLEBootPPacket(lEBootPPacket)) {
            this.receivedLEBootPPacket(lEBootPPacket);
            return;
        }
        this.receivedNonLEBootPPacket(lEBootPPacket);
    }

    private boolean isLEBootPPacket(LEBootPPacket lEBootPPacket) {
        int n = 0;
        while (n < 3) {
            byte by = LE_VENDOR_CODE[n];
            byte by2 = lEBootPPacket.getClientHardwareAddress()[n];
            if (LE_VENDOR_CODE[n] != lEBootPPacket.getClientHardwareAddress()[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void receivedLEBootPPacket(LEBootPPacket lEBootPPacket) {
    }

    public void receivedNonLEBootPPacket(LEBootPPacket lEBootPPacket) {
    }

    public void disconnect() {
        try {
            LEBootPServer.GetServer().stopServer();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

