/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.graphics.ImageUtils;

public class DTreeButtonDecoration
implements DTreeDecoration,
ImageObserver {
    private Image _expandedImage;
    private Image _collapsedImage;

    public Insets getDecorationInsets(DTree dTree) {
        return new Insets(0, dTree.getIndentWidth(), 0, 0);
    }

    public Image getCollapsedImage() {
        if (this._collapsedImage == null) {
            this._collapsedImage = ImageUtils.getCommonImage("collapse");
        }
        return this._collapsedImage;
    }

    public Image getExpandedImage() {
        if (this._expandedImage == null) {
            this._expandedImage = ImageUtils.getCommonImage("expand");
        }
        return this._expandedImage;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xA0) == 0;
    }

    public void processMouseEvent(MouseEvent mouseEvent, DTreeItem dTreeItem) {
        if (mouseEvent.getID() == 501 && (mouseEvent.getModifiers() & 0x10) != 0) {
            DTree dTree = dTreeItem.getTree();
            int n = dTreeItem.getX();
            int n2 = dTree.getIndentWidth();
            int n3 = mouseEvent.getX();
            if (dTreeItem.isExpandable() && n3 > n - n2 && n3 < n) {
                dTreeItem.setExpanded(!dTreeItem.isExpanded());
                mouseEvent.consume();
                return;
            }
        }
    }

    public void paintDecoration(Graphics graphics, DTreeItem dTreeItem, int n, int n2) {
        if (this.getHasButton(dTreeItem)) {
            Image image;
            Image image2 = image = dTreeItem.isExpanded() ? this.getExpandedImage() : this.getCollapsedImage();
            if (image == null || !dTreeItem.isExpandable()) {
                return;
            }
            int n3 = image.getWidth(this);
            int n4 = image.getHeight(this);
            DTree dTree = dTreeItem.getTree();
            int n5 = dTree.getIndentWidth();
            int n6 = n - n5 + (n5 - n3) / 2;
            int n7 = (n2 - n4) / 2;
            Color color = graphics.getColor();
            graphics.setColor(dTree.getBackground());
            graphics.fillRect(n6, n7, n3, n4);
            graphics.setColor(color);
            graphics.drawImage(image, n6, n7, this);
        }
    }

    public void setCollapsedImage(Image image) {
        if (image != null) {
            ImageUtils.loadImage(image);
        }
        this._collapsedImage = image;
    }

    public void setExpandedImage(Image image) {
        if (image != null) {
            ImageUtils.loadImage(image);
        }
        this._expandedImage = image;
    }

    protected boolean getHasButton(DTreeItem dTreeItem) {
        return true;
    }
}

