/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEISDNSwitch;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.util.PropertyResourceBundle;

public class LEISDNSwitchPage
extends LEWizardDataPage {
    public static final String INVALID_SWITCH = new String("The selected ISDN Switch is invalid.");
    private static final String INSTRUCTION_TAG = "ISDN_SWITCH_INST";
    private static final String HELP_TAG = "ISDN_Switch_Type";
    private static final String TITLE_TAG = "ISDN_SWITCH_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    Choice m_switchChoice;
    PropertyResourceBundle m_resource;

    public LEISDNSwitchPage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        this.m_component = new Label(new String("Select your ISDN switch type:"));
        this.m_panel.add(this.m_component, this.m_gbc);
        this.m_switchChoice = new Choice();
        this.addSwitchTypes();
        this.m_panel.add((Component)this.m_switchChoice, this.m_gbc);
        this.m_gbc.insets.right = 0;
        this.m_gbc.insets.left = 0;
        this.m_switchChoice.select(LEISDNSwitch.GetPRISwitchLabel(this.m_model.get(LEPMDataModel.ISDN_SWITCH)));
        return this.m_panel;
    }

    public boolean processPanelData() {
        String string = this.m_model.get(LEPMDataModel.ISDN_SWITCH);
        String string2 = this.m_switchChoice.getSelectedItem();
        String string3 = LEISDNSwitch.GetPRISwitchType(string2);
        if (string3.equals("")) {
            this.m_problem = INVALID_SWITCH;
            return false;
        }
        if (string == null) {
            this.m_model.set(LEPMDataModel.ISDN_SWITCH, string3);
        } else if (!string.equals(string3)) {
            this.m_model.set(LEPMDataModel.ISDN_SWITCH, string3);
        }
        return true;
    }

    private void addSwitchTypes() {
        int n = 0;
        while (n < 8) {
            this.m_switchChoice.addItem(LEISDNSwitch.GetPRISwitchLabel(n));
            ++n;
        }
    }
}

