/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Image;
import java.awt.event.MouseEvent;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarRadioGroup;
import oracle.ewt.toolBar.ToolBarToggleButton;

public class ToolBarRadio
extends ToolBarToggleButton {
    ToolBarRadioGroup _group;

    public ToolBarRadio() {
        this(-1, null);
    }

    public ToolBarRadio(int n, Image image) {
        this.setID(n);
        this.setIcon(image);
    }

    public ToolBarRadio(int n, Image image, ToolBarRadioGroup toolBarRadioGroup) {
        this.setID(n);
        this.setIcon(image);
        this._group = toolBarRadioGroup;
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.getState()) {
            return true;
        }
        return super.mousePressed(mouseEvent, n, n2);
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this.getState()) {
            return true;
        }
        return super.mouseDragged(mouseEvent, n, n2);
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2) {
        if (this.getState()) {
            return true;
        }
        return super.mouseReleased(mouseEvent, n, n2);
    }

    public void activate() {
        if (!this.getState()) {
            this.setState(true);
            super.activate();
        }
    }

    public void setState(boolean bl) {
        super.setState(bl);
        if (bl && (this.getParent() != null || this._group != null)) {
            this._autocoordinate();
        }
    }

    public ToolBarRadioGroup getGroup() {
        return this._group;
    }

    protected void setParent(ToolBar toolBar) {
        super.setParent(toolBar);
        if ((toolBar != null || this._group != null) && this.getState()) {
            this._autocoordinate();
        }
    }

    private void _autocoordinate() {
        ToolBarRadioGroup toolBarRadioGroup = this.getGroup();
        if (toolBarRadioGroup != null) {
            toolBarRadioGroup.setCurrentRadio(this);
            return;
        }
        ToolBar toolBar = this.getParent();
        int n = toolBar.getItemCount();
        ToolBarItem[] toolBarItemArray = toolBar.getItems();
        int n2 = toolBar.getItemIndex(this);
        int n3 = n2 + 1;
        while (n3 < n) {
            if (!(toolBarItemArray[n3] instanceof ToolBarRadio)) break;
            ((ToolBarRadio)toolBarItemArray[n3]).setState(false);
            ++n3;
        }
        n3 = n2 - 1;
        while (n3 >= 0) {
            if (!(toolBarItemArray[n3] instanceof ToolBarRadio)) break;
            ((ToolBarRadio)toolBarItemArray[n3]).setState(false);
            --n3;
        }
    }
}

