/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import oracle.help.search.ResultObject;

public class QueryObject {
    private URL _url;
    private InputStream _inStream;
    private char[] _alphabet;
    private long[] _alphaOffsets;
    private long _eowOffset;
    private long _fsOffset;
    private String _productTitle;
    private int _version;
    private String _encoding;
    private boolean _fileCase;
    private boolean _scoreAvailable;
    private boolean _titlesAvailable;
    private String _rootPath;
    private boolean _titlesNeeded;
    private boolean _caseSensitive = true;
    private String _title;
    private int _maxHitCount;
    private long _pos;
    private Vector _results;
    private static Vector _freeObjects;
    private static final int FREEOBJECTS_CACHE_SIZE = 250;
    private boolean _stopSearch;
    private static final int VERSION_10 = 10;
    private static final int VERSION_11 = 11;
    private static final int VERSION_20 = 20;
    static final String INDEX_VERSION = "OIN-INDEX-VERSION";
    static final String CHARACTER_SET = "CHARACTER-SET";
    static final String PRODUCT_TITLE = "PRODUCT-TITLE";
    static final String CASESENSITIVE = "CASESENSITIVE";
    static final String TITLES = "TITLES";
    static final String BLOCK_SIZE = "BLOCK-SIZE";
    static final String SCORES = "SCORES";
    static final String ROOT_PATH = "ROOTPATH";
    static final String TRUE = "TRUE";

    public static QueryObject getQueryObject(URL uRL) {
        if (_freeObjects == null) {
            _freeObjects = new Vector();
        }
        QueryObject queryObject = null;
        try {
            queryObject = new QueryObject(uRL);
            return queryObject;
        }
        catch (Exception exception) {
            System.out.println("IOException when accessing " + uRL.toString());
            return null;
        }
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }

    public boolean getCaseSensitive() {
        return this._caseSensitive;
    }

    public void setMaxHitCount(int n) {
        this._maxHitCount = n;
    }

    public int getMaxHitCount() {
        return this._maxHitCount;
    }

    public URL getIndexFileUrl() {
        return this._url;
    }

    public void setStopSearch() {
        this._stopSearch = true;
    }

    public void setTitlesNeeded(boolean bl) {
        this._titlesNeeded = bl;
    }

    public boolean titlesAvailable() {
        return this._titlesAvailable;
    }

    public boolean scoreAvailable() {
        return this._scoreAvailable;
    }

    public String productTitle() {
        return this._productTitle;
    }

    public synchronized Enumeration executeQuery(String[] stringArray, boolean bl) throws IOException {
        this._stopSearch = false;
        try {
            if (this._fileCase && !this._caseSensitive) {
                return this.executeComplexQuery(stringArray, bl);
            }
            return this.executeSimpleQuery(stringArray, bl);
        }
        catch (ThreadDeath threadDeath) {
            return null;
        }
    }

    private void checkStopSearch() {
        if (this._stopSearch) {
            throw new ThreadDeath();
        }
    }

    /*
     * Unable to fully structure code
     */
    private Enumeration executeSimpleQuery(String[] var1_1, boolean var2_2) throws IOException {
        var3_3 = new String[var1_1.length];
        if (this._fileCase) {
            var5_4 = 0;
            while (var5_4 < var1_1.length) {
                var3_3[var5_4] = var1_1[var5_4];
                ++var5_4;
            }
        } else {
            var5_4 = 0;
            while (var5_4 < var1_1.length) {
                var3_3[var5_4] = var1_1[var5_4].toLowerCase();
                ++var5_4;
            }
        }
        this._bubbleSort(var3_3);
        var7_5 = 0;
        var8_6 = new byte[1000];
        var9_7 = 0;
        var10_8 = 0;
        var11_9 = 0;
        var12_10 = new byte[255];
        var15_11 = 0;
        var17_12 = false;
        this._pos = 0L;
        var4_13 = new long[var3_3.length];
        this._inStream = this._openInputStream(this._url);
        if (this._inStream == null) {
            System.out.println("index file missing : " + this._url.toString());
            return null;
        }
        var18_14 = !var2_2;
        while (!var17_12) {
            var13_16 = var14_17 = var7_5;
            var5_4 = var7_5;
            while (var5_4 < var3_3.length) {
                if (var3_3[var7_5].charAt(0) != var3_3[var5_4].charAt(0)) break;
                ++var14_17;
                ++var5_4;
            }
            if ((var20_20 = this._getAlphabetIndex(var3_3[var13_16].charAt(0))) == -1) {
                if (var2_2) {
                    var18_14 = true;
                    break;
                }
                var5_4 = var13_16;
                while (var5_4 < var14_17) {
                    var4_13[var5_4] = 0L;
                    ++var5_4;
                }
                var7_5 = var14_17;
                if (var14_17 != var3_3.length) continue;
                var17_12 = true;
                continue;
            }
            var21_21 = this._alphaOffsets[var20_20];
            var23_23 = var20_20 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[var20_20 + 1];
            this._inStream.skip(var21_21 - this._pos);
            this._pos = var21_21;
            var16_18 = false;
            while (!var17_12 && !var16_18) {
                block49: {
                    var25_24 = 0;
                    if ((long)var10_8 + (var23_23 - this._pos) > (long)var8_6.length) {
                        var9_7 = var8_6.length - var10_8;
                    } else {
                        var9_7 = (int)(var23_23 - this._pos);
                        var16_18 = true;
                    }
                    this._read(var8_6, var10_8, var9_7);
                    var11_9 = var9_7 + var10_8;
                    var10_8 = 0;
                    try {
                        var15_11 = var13_16;
                        var26_25 = 0;
                        var27_26 = 0;
                        var28_27 = null;
                        do {
                            var19_19 = 0;
                            var25_24 = var26_25;
                            if (this._version < 20) {
                                while ((var12_10[var19_19++] = var8_6[var26_25++]) != 32) {
                                }
                                var28_27 = new String(var12_10, 0, var19_19 - 1);
                            } else {
                                var27_26 = var8_6[var26_25++];
                                while (var27_26 != 0) {
                                    var12_10[var19_19++] = var8_6[var26_25++];
                                    --var27_26;
                                }
                                var28_27 = this.bytesToString(var12_10, 0, var19_19);
                            }
                            if (var3_3[var15_11].equals(var28_27)) {
                                var6_15 = 0;
                                while (var6_15 < 4) {
                                    var29_28 = var8_6[var26_25 + var6_15];
                                    if (var29_28 < 0) {
                                        var29_28 = 256 + var29_28;
                                    }
                                    v0 = var15_11;
                                    var4_13[v0] = var4_13[v0] | (long)(var29_28 << 8 * (3 - var6_15));
                                    ++var6_15;
                                }
                                ++var15_11;
                                if (!var2_2) {
                                    var18_14 = false;
                                }
                            } else if (var3_3[var15_11].compareTo(var28_27) < 0) {
                                var4_13[var15_11] = 0L;
                                ++var15_11;
                                if (var2_2) {
                                    var18_14 = true;
                                    var17_12 = true;
                                    break block49;
                                }
                            }
                            if ((var26_25 += 4) <= var11_9) continue;
                            throw new IndexOutOfBoundsException();
                        } while (var15_11 != var14_17);
                        break block49;
                    }
                    catch (IndexOutOfBoundsException v1) {
                        var10_8 = var11_9 - var25_24;
                        var5_4 = 0;
                        ** while (var5_4 < var10_8)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var8_6[var5_4] = var8_6[var25_24 + var5_4];
                        ++var5_4;
                        continue;
                    }
                }
                if (var15_11 == var3_3.length) {
                    var17_12 = true;
                }
                if (var15_11 == var14_17) break;
            }
            var7_5 = var14_17;
            if (!this._stopSearch) continue;
            throw new ThreadDeath();
        }
        if (var18_14) {
            return null;
        }
        if (this._results.size() > 0) {
            var5_4 = 0;
            while (var5_4 < this._results.size()) {
                QueryObject._freeObjects.addElement(this._results.elementAt(var5_4));
                ++var5_4;
            }
            this._results.removeAllElements();
        }
        var5_4 = 0;
        while (var5_4 < var3_3.length) {
            if (var4_13[var5_4] != 0L) {
                this._inStream.skip(var4_13[var5_4] - this._pos);
                this._pos = var4_13[var5_4];
                if (var5_4 == 0) {
                    this._readFileIndices(this._results, true);
                } else if (var2_2) {
                    this._readFileIndices(this._results, false);
                    if (this._results.size() == 0) {
                        break;
                    }
                } else {
                    this._readFileIndices(this._results, true);
                }
                if (this._stopSearch) {
                    throw new ThreadDeath();
                }
            }
            ++var5_4;
        }
        if (QueryObject._freeObjects.size() > 250) {
            var5_4 = QueryObject._freeObjects.size() - 250;
            while (var5_4 != 0) {
                QueryObject._freeObjects.removeElementAt(--var5_4);
            }
        }
        if (this._results.size() == 0) {
            return null;
        }
        this._inStream.skip(this._fsOffset - this._pos);
        var20_20 = this._readUb2();
        var5_4 = 0;
        while (var5_4 < var20_20) {
            var21_22 = this._readUb1();
            this._read(var8_6, 0, var21_22);
            var22_29 = this._findFileIndex(this._results, var5_4);
            if (var22_29 != null) {
                var22_29.fileName = this._version < 20 ? new String(var8_6, 0, var21_22) : this.bytesToString(var8_6, 0, var21_22);
            }
            if (this._titlesAvailable) {
                var21_22 = this._readUb1();
                this._read(var8_6, 0, var21_22);
                if (this._titlesNeeded && var22_29 != null) {
                    var22_29.title = this._version < 20 ? new String(var8_6, 0, var21_22) : this.bytesToString(var8_6, 0, var21_22);
                }
            }
            if (var5_4 % 20 == 0 && this._stopSearch) {
                throw new ThreadDeath();
            }
            ++var5_4;
        }
        this._results.trimToSize();
        if (this._scoreAvailable) {
            ResultObject.QuickSort(this._results, 0, this._results.size() - 1);
        }
        return this._results.elements();
    }

    /*
     * Unable to fully structure code
     */
    private Enumeration executeComplexQuery(String[] var1_1, boolean var2_2) throws IOException {
        var3_3 = new String[var1_1.length];
        var7_4 = 0;
        while (var7_4 < var1_1.length) {
            var3_3[var7_4] = var1_1[var7_4].toLowerCase();
            ++var7_4;
        }
        this._bubbleSort(var3_3);
        var11_5 = 0;
        var12_6 = new byte[1000];
        var13_7 = 0;
        var14_8 = 0;
        var15_9 = 0;
        var16_10 = new byte[50];
        var19_11 = 0;
        var21_12 = false;
        this._pos = 0L;
        this._inStream = this._openInputStream(this._url);
        if (this._inStream == null) {
            System.out.println("index file missing : " + this._url.toString());
            return null;
        }
        var4_13 = new Vector<String>();
        var5_14 = new Vector<Long>();
        var22_15 = var2_2 == false;
        var24_16 = 0;
        while (var24_16 < 2) {
            var11_5 = 0;
            var21_12 = false;
            while (!var21_12) {
                var17_20 = var18_21 = var11_5;
                if (var24_16 == 0) {
                    var26_26 = Character.toUpperCase(var3_3[var11_5].charAt(0));
                    var7_4 = var11_5;
                    while (var7_4 < var3_3.length) {
                        if (var26_26 != Character.toUpperCase(var3_3[var7_4].charAt(0))) break;
                        ++var18_21;
                        ++var7_4;
                    }
                    var6_17 = new Character(var26_26).toString();
                    var6_17 = var6_17.concat(var3_3[var18_21 - 1].substring(1));
                    var25_24 = this._getAlphabetIndex(var26_26);
                } else {
                    var26_26 = var3_3[var11_5].charAt(0);
                    var7_4 = var11_5;
                    while (var7_4 < var3_3.length) {
                        if (var26_26 != var3_3[var7_4].charAt(0)) break;
                        ++var18_21;
                        ++var7_4;
                    }
                    var6_17 = var3_3[var18_21 - 1];
                    var25_24 = this._getAlphabetIndex(var26_26);
                }
                if (var25_24 == -1) {
                    var11_5 = var18_21;
                    if (var18_21 != var3_3.length) continue;
                    var21_12 = true;
                    continue;
                }
                var9_19 = this._alphaOffsets[var25_24];
                if (this._pos > var9_19) {
                    var11_5 = var18_21;
                    if (var18_21 != var3_3.length) continue;
                    var21_12 = true;
                    continue;
                }
                var26_27 = var25_24 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[var25_24 + 1];
                this._inStream.skip(var9_19 - this._pos);
                this._pos = var9_19;
                var20_22 = false;
                block9: while (!var21_12 && !var20_22) {
                    var28_31 = 0;
                    if ((long)var14_8 + (var26_27 - this._pos) > (long)var12_6.length) {
                        var13_7 = var12_6.length - var14_8;
                    } else {
                        var13_7 = (int)(var26_27 - this._pos);
                        var20_22 = true;
                    }
                    this._read(var12_6, var14_8, var13_7);
                    var15_9 = var13_7 + var14_8;
                    var14_8 = 0;
                    try {
                        var19_11 = var17_20;
                        var29_34 = 0;
                        var30_35 = null;
                        do {
                            var23_23 = 0;
                            var28_31 = var29_34;
                            if (this._version < 20) {
                                while ((var16_10[var23_23++] = var12_6[var29_34++]) != 32) {
                                }
                                var30_35 = new String(var16_10, 0, var23_23 - 1);
                            } else {
                                var32_37 = var12_6[var29_34++];
                                while (var32_37 != 0) {
                                    var16_10[var23_23++] = var12_6[var29_34++];
                                    --var32_37;
                                }
                                try {
                                    var30_35 = new String(var16_10, 0, var23_23, this._encoding);
                                }
                                catch (UnsupportedEncodingException v0) {
                                    var30_35 = new String(var16_10, 0, var23_23);
                                }
                            }
                            var31_36 = true;
                            var7_4 = var17_20;
                            while (var7_4 < var18_21) {
                                if (var30_35.equalsIgnoreCase(var3_3[var7_4])) {
                                    var31_36 = false;
                                    break;
                                }
                                ++var7_4;
                            }
                            if (!var31_36) {
                                var33_38 = 0L;
                                var8_18 = 0;
                                while (var8_18 < 4) {
                                    var35_39 = var12_6[var29_34 + var8_18];
                                    if (var35_39 < 0) {
                                        var35_39 = 256 + var35_39;
                                    }
                                    var33_38 |= (long)(var35_39 << 8 * (3 - var8_18));
                                    ++var8_18;
                                }
                                var4_13.addElement(var30_35);
                                var5_14.addElement(new Long(var33_38));
                                continue;
                            }
                            if (var6_17.compareTo(var30_35) >= 0) continue;
                            var20_22 = true;
                            continue block9;
                        } while ((var29_34 += 4) <= var15_9);
                        throw new IndexOutOfBoundsException();
                    }
                    catch (IndexOutOfBoundsException v1) {
                        var14_8 = var15_9 - var28_31;
                        var7_4 = 0;
                        ** while (var7_4 < var14_8)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var12_6[var7_4] = var12_6[var28_31 + var7_4];
                        ++var7_4;
                        continue;
lbl132:
                        // 1 sources

                    }
                }
                if (var18_21 == var3_3.length) {
                    var21_12 = true;
                }
                var11_5 = var18_21;
                if (!this._stopSearch) continue;
                throw new ThreadDeath();
            }
            ++var24_16;
        }
        if (var4_13.size() == 0 || var2_2 && var4_13.size() < var3_3.length) {
            return null;
        }
        if (this._results.size() > 0) {
            var7_4 = 0;
            while (var7_4 < this._results.size()) {
                QueryObject._freeObjects.addElement(this._results.elementAt(var7_4));
                ++var7_4;
            }
            this._results.removeAllElements();
        }
        var25_25 = new Vector[var3_3.length];
        var7_4 = 0;
        while (var7_4 < var4_13.size()) {
            var8_18 = 0;
            while (var8_18 < var3_3.length) {
                if (var3_3[var8_18].equalsIgnoreCase((String)var4_13.elementAt(var7_4))) break;
                ++var8_18;
            }
            if ((var9_19 = ((Long)var5_14.elementAt(var7_4)).longValue()) != 0L) {
                if (var25_25[var8_18] == null) {
                    var25_25[var8_18] = new Vector<E>();
                }
                this._inStream.skip(var9_19 - this._pos);
                this._pos = var9_19;
                this._readFileIndices(var25_25[var8_18], true);
                if (this._stopSearch) {
                    throw new ThreadDeath();
                }
            }
            ++var7_4;
        }
        if (var2_2) {
            var7_4 = 0;
            while (var7_4 < var3_3.length) {
                if (var25_25[var7_4] == null) {
                    return null;
                }
                ++var7_4;
            }
        }
        this._results = var25_25[0];
        if (this._results == null) {
            this._results = new Vector<E>();
        }
        if (var1_1.length > 1) {
            if (var2_2) {
                var7_4 = 0;
                while (var7_4 < this._results.size()) {
                    var26_28 = (ResultObject)this._results.elementAt(var7_4);
                    var26_28.useful = true;
                    var8_18 = 1;
                    while (var8_18 < var1_1.length) {
                        if (this._findFileIndex(var25_25[var8_18], var26_28.fileno) == null) {
                            var26_28.useful = false;
                        }
                        if (this._stopSearch) {
                            throw new ThreadDeath();
                        }
                        ++var8_18;
                    }
                    ++var7_4;
                }
                var8_18 = 1;
                while (var8_18 < var1_1.length) {
                    this._filterResults(var25_25[var8_18], true);
                    ++var8_18;
                }
                this._filterResults(this._results, false);
            } else {
                var7_4 = 1;
                while (var7_4 < var1_1.length) {
                    if (var25_25[var7_4] != null) {
                        var8_18 = 0;
                        while (var8_18 < var25_25[var7_4].size()) {
                            var26_29 = (ResultObject)var25_25[var7_4].elementAt(var8_18);
                            if (this._findFileIndex(this._results, var26_29.fileno) == null) {
                                this._results.addElement(var26_29);
                            } else {
                                var26_29.useful = false;
                            }
                            ++var8_18;
                        }
                        this._filterResults(var25_25[var7_4], false);
                    }
                    if (this._stopSearch) {
                        throw new ThreadDeath();
                    }
                    ++var7_4;
                }
            }
        }
        if (QueryObject._freeObjects.size() > 250) {
            var7_4 = QueryObject._freeObjects.size() - 250;
            while (var7_4 != 0) {
                QueryObject._freeObjects.removeElementAt(--var7_4);
            }
        }
        if (this._results.size() == 0) {
            return null;
        }
        this._inStream.skip(this._fsOffset - this._pos);
        var26_30 = this._readUb2();
        var7_4 = 0;
        while (var7_4 < var26_30) {
            var27_40 = this._readUb1();
            this._read(var12_6, 0, var27_40);
            var28_33 = this._findFileIndex(this._results, var7_4);
            if (var28_33 != null) {
                var28_33.fileName = this._version < 20 ? new String(var12_6, 0, var27_40) : this.bytesToString(var12_6, 0, var27_40);
            }
            if (this._titlesAvailable) {
                var27_40 = this._readUb1();
                this._read(var12_6, 0, var27_40);
                if (this._titlesNeeded && var28_33 != null) {
                    var28_33.title = this._version < 20 ? new String(var12_6, 0, var27_40) : this.bytesToString(var12_6, 0, var27_40);
                }
            }
            if (var7_4 % 20 == 0 && this._stopSearch) {
                throw new ThreadDeath();
            }
            ++var7_4;
        }
        this._results.trimToSize();
        if (this._scoreAvailable) {
            ResultObject.QuickSort(this._results, 0, this._results.size() - 1);
        }
        return this._results.elements();
    }

    private String bytesToString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this._encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    protected QueryObject(URL uRL) throws IOException {
        this._url = uRL;
        this._inStream = this._openInputStream(this._url);
        if (this._inStream == null) {
            throw new IOException(String.valueOf(this._url.toString()) + " file not found ");
        }
        this._parseHeader();
        this._inStream.close();
        this._inStream = null;
        this._maxHitCount = 50;
        this._results = new Vector();
    }

    private InputStream _openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {}
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    private long _readUb4() throws IOException {
        long l = 0L;
        l = (long)this._readUb1() << 24 | (long)this._readUb1() << 16 | (long)this._readUb1() << 8 | (long)this._readUb1();
        return l;
    }

    private int _readUb2() throws IOException {
        int n = this._readUb1() << 8 | this._readUb1();
        return n;
    }

    private int _readUb1() throws IOException {
        int n = this._inStream.read();
        if (n < 0) {
            n += 256;
        }
        ++this._pos;
        return n;
    }

    private String _readLine() throws IOException {
        char c;
        int n = 40;
        StringBuffer stringBuffer = new StringBuffer(n);
        while ((c = (char)this._inStream.read()) != '\n') {
            if (stringBuffer.length() == n) {
                stringBuffer.setLength(n += 40);
            }
            stringBuffer.append(c);
            ++this._pos;
        }
        ++this._pos;
        return stringBuffer.toString();
    }

    private void _read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 != n2) {
            int n4 = this._inStream.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                throw new IOException();
            }
            n3 += n4;
            this._pos += (long)n4;
        }
    }

    private void _parseHeader() throws IOException {
        String string = this._readLine();
        if (!string.startsWith(INDEX_VERSION)) {
            throw new IOException("Illegal Index File");
        }
        if (string.equals("OIN-INDEX-VERSION 1.0")) {
            this._version = 10;
        } else if (string.equals("OIN-INDEX-VERSION 1.1")) {
            this._version = 11;
        } else if (string.equals("OIN-INDEX-VERSION 2.0")) {
            this._version = 20;
        } else {
            throw new IOException(String.valueOf(string) + "END");
        }
        string = this._readLine();
        if (this._version >= 20) {
            this._encoding = string.substring(CHARACTER_SET.length() + 1);
        }
        if (!(string = this._readLine()).startsWith(PRODUCT_TITLE)) {
            throw new IOException("Corrupted Index File :" + string);
        }
        this._productTitle = string.substring(PRODUCT_TITLE.length() + 1);
        string = this._readLine();
        if (!string.startsWith(TITLES)) {
            throw new IOException("Corrupted Index File");
        }
        this._titlesAvailable = string.endsWith(TRUE);
        this._titlesNeeded = this._titlesAvailable;
        string = this._readLine();
        if (!string.startsWith(CASESENSITIVE)) {
            throw new IOException("Corrupted Index File");
        }
        this._fileCase = string.endsWith(TRUE);
        this._readLine();
        if (this._version > 10) {
            string = this._readLine();
            if (!string.startsWith(SCORES)) {
                throw new IOException("Corrupted Index File");
            }
            this._scoreAvailable = string.endsWith(TRUE);
        }
        if (!(string = this._readLine()).startsWith(ROOT_PATH)) {
            throw new IOException("Corrupted Index File");
        }
        this._rootPath = string.substring(ROOT_PATH.length() + 1);
        int n = this._readUb2();
        this._alphabet = new char[n];
        this._alphaOffsets = new long[n];
        byte[] byArray = new byte[2];
        int n2 = 0;
        while (n2 < n) {
            if (this._version < 20) {
                this._alphabet[n2] = (char)this._readUb1();
            } else if (this._readUb1() == 1) {
                this._alphabet[n2] = (char)this._readUb1();
            } else {
                byArray[0] = (byte)this._readUb1();
                byArray[1] = (byte)this._readUb1();
                String string2 = new String(byArray, this._encoding);
                this._alphabet[n2] = string2.charAt(0);
            }
            this._alphaOffsets[n2] = this._readUb4();
            ++n2;
        }
        this._eowOffset = this._readUb4();
        this._fsOffset = this._readUb4();
    }

    private int _getAlphabetIndex(char c) {
        int n = 0;
        while (n < this._alphabet.length) {
            if (this._alphabet[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void _readFileIndices(Vector vector, boolean bl) throws IOException {
        int n;
        ResultObject resultObject;
        int n2 = 0;
        new Vector(10, 10);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            resultObject = (ResultObject)enumeration.nextElement();
            resultObject.useful = bl;
        }
        while ((n = this._readUb2()) != 65535) {
            if (this._scoreAvailable) {
                n2 = this._readUb1();
            }
            if ((resultObject = this._findFileIndex(vector, n)) == null) {
                if (!bl) continue;
                if (_freeObjects.size() != 0) {
                    resultObject = (ResultObject)_freeObjects.elementAt(0);
                    _freeObjects.removeElementAt(0);
                } else {
                    resultObject = new ResultObject();
                }
                resultObject.fileno = n;
                resultObject.score = n2;
                resultObject.useful = true;
                resultObject.title = null;
                resultObject.fileName = null;
                vector.addElement(resultObject);
                continue;
            }
            resultObject.useful = true;
            resultObject.score += n2;
        }
        this._filterResults(vector, false);
    }

    private void _filterResults(Vector vector, boolean bl) {
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        while (n < n2) {
            ResultObject resultObject = (ResultObject)vector.elementAt(n - n3);
            if (!resultObject.useful || bl) {
                _freeObjects.addElement(resultObject);
                vector.removeElementAt(n - n3);
                ++n3;
            }
            ++n;
        }
    }

    private ResultObject _findFileIndex(Vector vector, int n) {
        if (vector.isEmpty()) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResultObject resultObject = (ResultObject)enumeration.nextElement();
            if (resultObject.fileno != n) continue;
            return resultObject;
        }
        return null;
    }

    private void _bubbleSort(String[] stringArray) {
        if (stringArray.length == 1) {
            return;
        }
        if (stringArray.length == 2) {
            if (stringArray[0].compareTo(stringArray[1]) > 0) {
                String string = stringArray[1];
                stringArray[1] = stringArray[0];
                stringArray[0] = string;
            }
            return;
        }
        int n = stringArray.length - 1;
        while (n >= 1) {
            int n2 = 1;
            while (n2 <= n) {
                if (stringArray[n2 - 1].compareTo(stringArray[n2]) > 0) {
                    String string = stringArray[n2 - 1];
                    stringArray[n2 - 1] = stringArray[n2];
                    stringArray[n2] = string;
                }
                ++n2;
            }
            --n;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("usage : QueryObject indexFileURL word1 word2..");
            System.exit(0);
        }
        try {
            URL uRL = new URL(stringArray[0]);
            QueryObject queryObject = QueryObject.getQueryObject(uRL);
            queryObject.setCaseSensitive(false);
            String[] stringArray2 = new String[stringArray.length - 1];
            int n = 0;
            while (n < stringArray.length - 1) {
                stringArray2[n] = stringArray[n + 1];
                ++n;
            }
            Enumeration enumeration = queryObject.executeQuery(stringArray2, false);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    ResultObject resultObject = (ResultObject)enumeration.nextElement();
                    if (resultObject.getTitle() != null) {
                        System.out.println(String.valueOf(resultObject.getTitle()) + " " + resultObject.getFilePath() + " " + resultObject.getScore() + " " + resultObject.fileno);
                        continue;
                    }
                    System.out.println(String.valueOf(resultObject.getFilePath()) + " " + resultObject.getScore());
                }
                return;
            }
            System.out.println("Search failed");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

