/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class OhtParser {
    private byte[] buffer = new byte[256];
    private final int BUF_SIZE = 256;
    private final String IDMAP_BEGIN = "<ID_MAP>";
    private final String IDMAP_END = "</ID_MAP>";
    private boolean _eof = false;
    private static final boolean _debug = false;

    public static Hashtable getTopicsHashtable(URL uRL) {
        OhtParser ohtParser = new OhtParser();
        Hashtable hashtable = null;
        try {
            hashtable = ohtParser.parseOht(uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            System.out.println("Exception in parseOht()");
            exception.printStackTrace();
        }
        return hashtable;
    }

    private OhtParser() {
    }

    private Hashtable parseOht(URL uRL) throws IOException {
        String string;
        InputStream inputStream = this.openInputStream(uRL);
        boolean bl = false;
        while (!this._eof) {
            string = this.readLine(inputStream);
            if (string.toUpperCase().indexOf("<ID_MAP>") == -1) continue;
            bl = true;
            break;
        }
        if (this._eof) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
        while (true) {
            string = this.readLine(inputStream);
            if (this._eof || string.toUpperCase().indexOf("</ID_MAP>") != -1) break;
            if (string.length() == 0 || string.charAt(0) == ';') continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " :\"");
            try {
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.nextToken().equals("=")) break;
                String string3 = stringTokenizer.nextToken();
                hashtable.put(string2, string3);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        inputStream.close();
        return hashtable;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int n = 0;
        while (true) {
            int n2 = inputStream.read();
            if (n == this.buffer.length) {
                int n3 = this.buffer.length << 1;
                byte[] byArray = this.buffer;
                this.buffer = new byte[n3];
                System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            }
            if (n2 == 10) break;
            if (n2 < 0) {
                this._eof = true;
                break;
            }
            this.buffer[n++] = (byte)n2;
        }
        return new String(this.buffer, 0, n);
    }

    private InputStream openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {}
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("OhtParser <oht-url>");
            System.exit(0);
        }
        try {
            Hashtable hashtable = OhtParser.getTopicsHashtable(new URL(stringArray[0]));
            String string = (String)hashtable.get("a10prpeddb");
            System.out.println("a10prpeddb " + string);
            return;
        }
        catch (Exception exception) {
            System.out.println("invalid URL");
            return;
        }
    }
}

