/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.alert.BaseAlert;
import oracle.ewt.button.EwtButton;
import oracle.ewt.button.TextContent;
import oracle.ewt.event.HelpEvent;
import oracle.ewt.event.HelpListener;
import oracle.ewt.event.ListenerManager;

public class Alert
extends BaseAlert
implements ActionListener {
    public static final int BUTTON_YES = 1;
    public static final int BUTTON_NO = 2;
    public static final int BUTTON_CANCEL = 4;
    public static final int BUTTON_HELP = 8;
    public static final int BUTTON_USER = 0;
    public static final int TYPE_STOP = 0;
    public static final int TYPE_CAUTION = 1;
    public static final int TYPE_NOTE = 2;
    public static final int TYPE_MISC = 3;
    private EwtButton _yes;
    private EwtButton _no;
    private EwtButton _cancel;
    private EwtButton _help;
    private ListenerManager _helpListeners;
    private static final int _ALL_BUTTONS_MASK = 15;
    private static final String _YES_KEY = "YES";
    private static final String _OK_KEY = "OK";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _NO_KEY = "NO";
    private static final String _HELP_KEY = "HELP";

    public Alert(Frame frame, int n, int n2) {
        this(frame, "", n, n2);
    }

    public Alert(Dialog dialog, String string, int n, int n2) {
        this((Frame)dialog.getParent(), string, n, n2);
        this.setCenterOver(dialog);
    }

    public Alert(Frame frame, String string, int n, int n2) {
        super(frame, string, n);
        if ((n2 & 0xF) == 0 || (n2 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("Illegal button bitmask");
        }
        if ((n2 & 1) != 0) {
            this._yes = this.createButton(1, n2);
            this._yes.addActionListener(this);
            this.addUserButton("Yes", this._yes);
            this.setDefaultComponent(this._yes);
            if ((n2 & 6) == 0) {
                this.setCancelComponent(this._yes);
            }
        }
        if ((n2 & 2) != 0) {
            this._no = this.createButton(2, n2);
            this._no.addActionListener(this);
            this.addUserButton("No", this._no);
            if ((n2 & 4) == 0) {
                this.setCancelComponent(this._no);
            }
        }
        if ((n2 & 4) != 0) {
            this._cancel = this.createButton(4, n2);
            this._cancel.addActionListener(this);
            this.addUserButton("Cancel", this._cancel);
            if ((n2 & 1) == 0) {
                this.setDefaultComponent(this._cancel);
            }
            this.setCancelComponent(this._cancel);
        }
        if ((n2 & 8) != 0) {
            this._help = this.createButton(8, n2);
            this._help.addActionListener(this);
            this.addUserButton("Help", this._help);
            this.setHelpComponent(this._help);
        }
        this.setCenterOver(frame);
        this.loadButtonText(this.getLocale());
    }

    public int runAlert() {
        ((Component)this).setVisible(true);
        return this._whichButton(this.getPressed());
    }

    public String getButtonLabel(int n) {
        TextContent textContent = (TextContent)this._whichComponent(n).getContent();
        return textContent.getText();
    }

    public void setButtonLabel(int n, String string) {
        TextContent textContent = (TextContent)this._whichComponent(n).getContent();
        textContent.setText(string);
    }

    public int getDefaultButton() {
        return this._whichButton(this.getDefaultComponent());
    }

    public void setDefaultButton(int n) {
        this.setDefaultComponent(this._whichComponent(n));
    }

    public synchronized void addHelpListener(HelpListener helpListener) {
        if (this._helpListeners == null) {
            this._helpListeners = new ListenerManager();
        }
        this._helpListeners.addListener(helpListener);
    }

    public synchronized void removeHelpListener(HelpListener helpListener) {
        this._helpListeners.removeListener(helpListener);
    }

    public Component addDismissButton(String string, EwtButton ewtButton) {
        ewtButton.addActionListener(this);
        return this.addUserButton(string, ewtButton);
    }

    public final Component addDismissButton(EwtButton ewtButton) {
        return this.addDismissButton(null, ewtButton);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.loadButtonText(locale);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component != this._help) {
            this.dismissAlert(component);
            return;
        }
        this.processEvent(new HelpEvent(this, 2000));
    }

    protected void doComponentKey(Component component) {
        if (component instanceof EwtButton) {
            ((EwtButton)component).simulatePush();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof HelpEvent) {
            this.processHelpEvent((HelpEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processHelpEvent(HelpEvent helpEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._helpListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                switch (helpEvent.getID()) {
                    case 2000: {
                        ((HelpListener)e).helpRequested(helpEvent);
                        break;
                    }
                }
            }
        }
    }

    protected void loadButtonText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.alert.resource.AlertBundle", locale);
        if (this._yes != null) {
            String string = this._no != null ? _YES_KEY : _OK_KEY;
            ((TextContent)this._yes.getContent()).setText(resourceBundle.getString(string));
        }
        if (this._no != null) {
            ((TextContent)this._no.getContent()).setText(resourceBundle.getString(_NO_KEY));
        }
        if (this._cancel != null) {
            ((TextContent)this._cancel.getContent()).setText(resourceBundle.getString(_CANCEL_KEY));
        }
        if (this._help != null) {
            ((TextContent)this._help.getContent()).setText(resourceBundle.getString(_HELP_KEY));
        }
    }

    protected EwtButton createButton(int n, int n2) {
        return new EwtButton("");
    }

    private EwtButton _whichComponent(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this._yes;
            }
            case 2: {
                return this._no;
            }
            case 4: {
                return this._cancel;
            }
            case 8: {
                return this._help;
            }
        }
        throw new IllegalArgumentException();
    }

    private int _whichButton(Component component) {
        if (component == this._yes) {
            return 1;
        }
        if (component == this._no) {
            return 2;
        }
        if (component == this._cancel) {
            return 4;
        }
        if (component == this._help) {
            return 8;
        }
        return 0;
    }
}

