/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import oracle.ewt.border.Border;
import oracle.ewt.border.BorderManager;
import oracle.ewt.border.FrameBorder;
import oracle.ewt.button.ButtonContent;
import oracle.ewt.button.ImageContent;
import oracle.ewt.button.TextContent;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.graphics.frame.ArmedButtonFramePainter;
import oracle.ewt.graphics.frame.ButtonFramePainter;
import oracle.ewt.lwAWT.LWComponent;

public class EwtButton
extends LWComponent
implements ImageObserver,
BorderManager {
    private transient int _lastModifiers;
    private Border _border;
    private Border _pressedBorder;
    private Insets _insets;
    private ButtonContent _content;
    private boolean _armed;
    private boolean _interacting;
    private boolean _keyDown;
    private ListenerManager _listeners;
    private boolean _focusable = true;
    private boolean _default;
    private static Border _sDefaultBorder;
    private static Border _sDefaultPressedBorder;
    private static String _sDefaultName;
    private static int _sInstanceCounter;
    private static final int _DEFAULT_BORDER_THICKNESS = 2;
    private static final int _FOCUS_RING_MARGIN = 2;
    private static final int _SIMULATE_PUSH_PAUSE = 100;

    public EwtButton() {
        this("");
    }

    public EwtButton(ButtonContent buttonContent) {
        this(buttonContent, EwtButton.getDefaultBorder(), EwtButton.getDefaultPressedBorder());
    }

    public EwtButton(Image image) {
        this(new ImageContent(image));
    }

    public EwtButton(String string) {
        this(new TextContent(string));
    }

    public EwtButton(ButtonContent buttonContent, Border border, Border border2) {
        this.setContent(buttonContent);
        this._initializeBorders(border, border2);
        this.enableEvents(60L);
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void setContent(ButtonContent buttonContent) {
        this.storeContent(buttonContent);
        this.invalidate();
        this.repaint();
    }

    public ButtonContent getContent() {
        return this._content;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listeners.removeListener(actionListener);
    }

    public void simulatePush() {
        this.setInteracting(true);
        this.setArmed(true);
        this._doSyncPaint();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.setArmed(false);
        this.setInteracting(false);
        this._doSyncPaint();
        this.activate();
    }

    public void setFocusable(boolean bl) {
        if (bl != this._focusable) {
            this._focusable = bl;
            this.invalidate();
        }
    }

    public boolean isFocusable() {
        return this._focusable;
    }

    public static Border getDefaultBorder() {
        if (_sDefaultBorder == null) {
            _sDefaultBorder = new FrameBorder(2, ButtonFramePainter.getFramePainter());
        }
        return _sDefaultBorder;
    }

    public static Border getDefaultPressedBorder() {
        if (_sDefaultPressedBorder == null) {
            _sDefaultPressedBorder = new FrameBorder(2, ArmedButtonFramePainter.getFramePainter());
        }
        return _sDefaultPressedBorder;
    }

    public void paintInterior(Graphics graphics) {
        Border border;
        Rectangle rectangle = this.getPaintRectangle();
        Border border2 = border = this.isDrawnPressed() ? this._pressedBorder : this._border;
        if (border != null) {
            border.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        }
        Insets insets = this._insets;
        this.paintInside(graphics, rectangle.x + insets.left, rectangle.y + insets.right, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        ButtonContent buttonContent = this.getContent();
        if (buttonContent == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = buttonContent.getPreferredSize();
        Insets insets = this._insets;
        int n = 2 * this.getFocusMargin();
        return new Dimension(dimension.width + insets.left + insets.right + n, dimension.height + insets.top + insets.bottom + n);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidate();
            this.repaint();
        } else if ((n & 0x30) != 0) {
            Dimension dimension = this.getSize();
            Insets insets = this._insets;
            if (insets != null) {
                int n6 = 2 * this.getFocusMargin();
                this.repaint(insets.left, insets.right, dimension.width - (insets.left + insets.right + n6), dimension.height - (insets.top + insets.bottom + n6));
            } else {
                this.repaint();
            }
        }
        return (n & 0xA0) == 0;
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.terminateInteraction()) {
                this._doSyncPaint();
                return;
            }
            this.repaint();
        }
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaint();
        }
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font2 != this.getFont()) {
            this.invalidate();
            this.repaint();
        }
    }

    public void activate() {
        this.processEvent(new ActionEvent(this, 1001, null, this._lastModifiers));
    }

    public boolean isFocusTraversable() {
        return this.isFocusable();
    }

    public Color getBorderBackground() {
        return this.getBackground();
    }

    public Color getBorderForeground() {
        return this.getForeground();
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            super.requestFocus();
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!this.hasFocus()) {
            this.terminateInteraction();
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        this._lastModifiers = keyEvent.getModifiers();
        if (!keyEvent.isConsumed() && this.isEnabled()) {
            int n = keyEvent.getID();
            if (n == 401 && !this.isInteracting()) {
                int n2 = keyEvent.getKeyCode();
                if (n2 == 10 || n2 == 32) {
                    keyEvent.consume();
                    this.setInteracting(true);
                    this.setArmed(true);
                    this._keyDown = true;
                    this._doSyncPaint();
                }
                return;
            }
            if (n == 402 && this._keyDown) {
                this.setInteracting(false);
                this.setArmed(false);
                this._keyDown = false;
                this._doSyncPaint();
                this.activate();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        this._lastModifiers = mouseEvent.getModifiers();
        if (!mouseEvent.isConsumed() && !this._keyDown) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 505: {
                    bl = this.processMouseExited(mouseEvent, n, n2);
                    break;
                }
                case 501: {
                    bl = this.processMousePressed(mouseEvent, n, n2);
                    break;
                }
                case 502: {
                    bl = this.processMouseReleased(mouseEvent, n, n2);
                    break;
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        this._lastModifiers = mouseEvent.getModifiers();
        if (!mouseEvent.isConsumed() && !this._keyDown) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 503: {
                    bl = this.processMouseMoved(mouseEvent, n, n2);
                    break;
                }
                case 506: {
                    bl = this.processMouseDragged(mouseEvent, n, n2);
                    break;
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected boolean processMousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && (mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.isFocusable()) {
                this.requestFocus();
            }
            this.setInteracting(true);
            this.setArmed(true);
            this._doSyncPaint();
        }
        return false;
    }

    protected boolean processMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this.isInteracting()) {
            boolean bl = this.isArmed();
            this.setArmed(false);
            if (bl) {
                this._doSyncPaint();
            }
            this.setInteracting(false);
            if (this.contains(n, n2)) {
                this.activate();
            }
            return true;
        }
        return false;
    }

    protected boolean processMouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this.isInteracting()) {
            boolean bl = this.contains(n, n2);
            if (this.isArmed() != bl) {
                this.setArmed(bl);
                this._doSyncPaint();
            }
            return true;
        }
        return false;
    }

    protected boolean processMouseMoved(MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    protected boolean processMouseExited(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this.isArmed()) {
            this.setArmed(false);
            this._doSyncPaint();
        }
        return false;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                switch (actionEvent.getID()) {
                    case 1001: {
                        actionListener.actionPerformed(actionEvent);
                        break;
                    }
                }
            }
        }
    }

    public void borderRepaintNotify() {
        this.repaint();
    }

    public void borderResizeNotify() {
        this._insets = this._border.getInsets();
        this.invalidate();
        this.repaint();
    }

    protected void paintInside(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.getBackground();
        int n5 = this.getFocusMargin();
        graphics.setColor(this.isDrawnPressed() ? ColorUtils.darkerShadeColor(color) : color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(this.getForeground());
        n3 -= 2 * n5;
        n4 -= 2 * n5;
        if (this.hasFocus()) {
            GraphicUtils.drawFocusRect(graphics, n, n2, n3 + 2, n4 + 2);
        }
        graphics.clipRect(n += n5, n2 += n5, n3, n4);
        ButtonContent buttonContent = this.getContent();
        if (buttonContent != null) {
            buttonContent.paint(graphics, n, n2, n3, n4);
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",content=" + this._content;
    }

    protected boolean isDrawnPressed() {
        return this.isArmed();
    }

    protected void setArmed(boolean bl) {
        this._armed = bl;
    }

    protected void setInteracting(boolean bl) {
        this._interacting = bl;
    }

    protected boolean isInteracting() {
        return this._interacting;
    }

    protected boolean terminateInteraction() {
        boolean bl = this.isArmed();
        if (bl) {
            this.setArmed(false);
        }
        if (this.isInteracting()) {
            this.setInteracting(false);
        }
        this._keyDown = false;
        return bl;
    }

    protected void storeContent(ButtonContent buttonContent) {
        if (buttonContent != null) {
            buttonContent.setParent(this);
        }
        this._content = buttonContent;
    }

    protected Rectangle getPaintRectangle() {
        Rectangle rectangle = this.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        return rectangle;
    }

    protected int getFocusMargin() {
        if (this.isFocusable()) {
            return 2;
        }
        return 0;
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    private void _initializeBorders(Border border, Border border2) {
        this._border = border;
        this._pressedBorder = border2;
        if (border != null) {
            this._insets = border.getInsets();
            return;
        }
        this._insets = new Insets(0, 0, 0, 0);
    }

    private void _doSyncPaint() {
        this.paintImmediate();
    }

    static {
        _sDefaultName = null;
    }
}

