/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import oracle.ewt.button.ButtonContent;
import oracle.ewt.graphics.GrayFilter;

public class ImageContent
implements ButtonContent {
    private Component _parent;
    private Image _image;
    private Image _disabledImage;
    private boolean _scaling;

    public ImageContent(Image image) {
        this._image = image;
    }

    public void setParent(Component component) {
        this._parent = component;
        if (this._image != null) {
            component.prepareImage(this._image, component);
        }
    }

    public Component getParent() {
        return this._parent;
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
        this._disabledImage = null;
        Component component = this.getParent();
        if (component != null) {
            if (image != null) {
                component.prepareImage(image, component);
            }
            component.invalidate();
            component.repaint();
        }
    }

    public void setScaling(boolean bl) {
        if (bl != this._scaling) {
            this._scaling = bl;
            Component component = this.getParent();
            if (component != null) {
                component.repaint();
            }
        }
    }

    public boolean isScaling() {
        return this._scaling;
    }

    public Dimension getPreferredSize() {
        Image image = this.getImage();
        if (image != null) {
            Component component = this.getParent();
            return new Dimension(image.getWidth(component), image.getHeight(component));
        }
        return new Dimension(0, 0);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        Image image;
        if (this._image == null) {
            return;
        }
        Component component = this.getParent();
        if (component.isEnabled()) {
            image = this._image;
        } else {
            if (this._disabledImage == null) {
                FilteredImageSource filteredImageSource = new FilteredImageSource(this._image.getSource(), GrayFilter.getFilter());
                this._disabledImage = this.getParent().createImage(filteredImageSource);
            }
            image = this._disabledImage;
        }
        if (image != null) {
            if (this.isScaling()) {
                graphics.drawImage(image, n, n2, n3, n4, component);
                return;
            }
            int n5 = image.getWidth(component);
            int n6 = image.getHeight(component);
            if (n5 != -1 && n6 != -1) {
                graphics.drawImage(image, n += (n3 - n5) / 2, n2 += (n4 - n6) / 2, component);
            }
        }
    }
}

