/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import oracle.ewt.EwtComponent;
import oracle.ewt.dTree.DTreeActivateListener;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeEmptyDecoration;
import oracle.ewt.dTree.DTreeEvent;
import oracle.ewt.dTree.DTreeExpandedEnumeration;
import oracle.ewt.dTree.DTreeExpansionListener;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeItemValidateEvent;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSelValidateEvent;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dTree.DTreeSelectionListener;
import oracle.ewt.dTree.DTreeSingleSelection;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.scrolling.ScrollableException;

public class DTree
extends EwtComponent {
    private DTreeRootItem _root;
    private DTreeItem _focused;
    private int _indentwd;
    private int _rowheight;
    private int _nositems;
    private int _noslevels;
    private int _layoutFrozenLevel;
    private DTreeSelection _selection;
    private DTreeDecoration _decoration;
    private ListenerManager _activatelm;
    private ListenerManager _expandlm;
    private ListenerManager _selectlm;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private static final int _DEFAULT_INDENTWIDTH = 18;
    private static final int _DEFAULT_ITEMS_ON_SCREEN = 20;
    private static final int _DEFAULT_LEVELS_ON_SCREEN = 5;
    private static final int _PREFERRED_WIDTH_ADJUSTMENT = 100;

    public static DTreeItem getCommonAncestor(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        DTreeItem dTreeItem3 = dTreeItem;
        while (dTreeItem3 != null) {
            if (DTree.isItemDescendent(dTreeItem2, dTreeItem3)) {
                return dTreeItem3;
            }
            dTreeItem3 = dTreeItem3.getParent();
        }
        return null;
    }

    public static boolean isItemBefore(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        DTreeItem dTreeItem3 = DTree.getCommonAncestor(dTreeItem, dTreeItem2);
        if (dTreeItem3 == dTreeItem) {
            return true;
        }
        if (dTreeItem3 == dTreeItem2) {
            return false;
        }
        DTreeItem dTreeItem4 = dTreeItem;
        DTreeItem dTreeItem5 = dTreeItem2;
        while (dTreeItem4.getParent() != dTreeItem3) {
            dTreeItem4 = dTreeItem4.getParent();
        }
        while (dTreeItem5.getParent() != dTreeItem3) {
            dTreeItem5 = dTreeItem5.getParent();
        }
        return dTreeItem4.getIndex() < dTreeItem5.getIndex();
    }

    public static boolean isItemDescendent(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        while (dTreeItem != null) {
            if (dTreeItem == dTreeItem2) {
                return true;
            }
            dTreeItem = dTreeItem.getParent();
        }
        return false;
    }

    public static boolean isItemVisible(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem.getParent();
        if (dTreeItem2 == null) {
            return dTreeItem.getTree() != null;
        }
        return dTreeItem2.isExpanded() && DTree.isItemVisible(dTreeItem2);
    }

    public DTree() {
        this(null);
    }

    public DTree(DTreeRootItem dTreeRootItem) {
        this._setRoot(dTreeRootItem);
        this._selection = new DTreeSingleSelection();
        this._selection.setTree(this);
        this._decoration = DTreeEmptyDecoration.getInstance();
        this._indentwd = 18;
        this._nositems = 20;
        this._noslevels = 5;
        this.enableEvents(24L);
    }

    public final void addActivateListener(DTreeActivateListener dTreeActivateListener) {
        if (this._activatelm == null) {
            this._activatelm = new ListenerManager();
        }
        this._activatelm.addListener(dTreeActivateListener);
    }

    public final void addExpansionListener(DTreeExpansionListener dTreeExpansionListener) {
        if (this._expandlm == null) {
            this._expandlm = new ListenerManager();
        }
        this._expandlm.addListener(dTreeExpansionListener);
    }

    public final void addSelectionListener(DTreeSelectionListener dTreeSelectionListener) {
        if (this._selectlm == null) {
            this._selectlm = new ListenerManager();
        }
        this._selectlm.addListener(dTreeSelectionListener);
    }

    public void freezeLayouts() {
        ++this._layoutFrozenLevel;
    }

    public DTreeDecoration getDecoration() {
        return this._decoration;
    }

    public Enumeration getExpandedEnumeration() {
        return new DTreeExpandedEnumeration(this);
    }

    public DTreeItem getFocusedItem() {
        if (this._focused == null || this._focused.getParent() == null || this._focused.getTree() == null) {
            DTreeRootItem dTreeRootItem = this.getRoot();
            this._focused = dTreeRootItem == null || dTreeRootItem.getItemCount() <= 0 ? null : dTreeRootItem.getItem(0);
        }
        return this._focused;
    }

    public int getIndentWidth() {
        return this._indentwd;
    }

    public DTreeItem getItemAt(int n, int n2) {
        if (this._root == null) {
            return null;
        }
        return this._root.getItemAt(n, n2);
    }

    public int getPreferredItemsOnScreen() {
        return this._nositems;
    }

    public int getPreferredLevelsOnScreen() {
        return this._noslevels;
    }

    public DTreeItem getPreviousVisibleItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        DTreeItem dTreeItem3 = dTreeItem.getParent();
        int n = dTreeItem.getIndex();
        if (n > 0) {
            dTreeItem2 = dTreeItem3.getItem(n - 1);
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = dTreeItem3;
        } else if (dTreeItem2.isExpanded()) {
            dTreeItem2 = this._getLastVisibleItem(dTreeItem2);
        }
        if (dTreeItem2 == this.getRoot()) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    /*
     * Unable to fully structure code
     */
    public final DTreeItem getNextVisibleItem(DTreeItem var1_1) {
        if (var1_1.isExpanded() && var1_1.getItemCount() > 0) {
            return var1_1.getItem(0);
        }
        var2_2 = var1_1.getParent();
        var3_3 = var1_1.getIndex();
        if (var3_3 >= var2_2.getItemCount() - 1) ** GOTO lbl11
        return var2_2.getItem(var3_3 + 1);
lbl-1000:
        // 1 sources

        {
            var4_4 = var2_2.getParent();
            if (var4_4 != null && (var3_3 = var2_2.getIndex()) < var4_4.getItemCount() - 1) {
                return var4_4.getItem(var3_3 + 1);
            }
            var2_2 = var4_4;
lbl11:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl12:
        // 1 sources

        return null;
    }

    public DTreeRootItem getRoot() {
        return this._root;
    }

    public DTreeSelection getSelection() {
        return this._selection;
    }

    public void itemActivate(DTreeItem dTreeItem) {
        this.processEvent(new DTreeItemEvent(this, 2004, dTreeItem));
    }

    public void itemExpansionChanged(DTreeItem dTreeItem, boolean bl) {
        int n = bl ? 2001 : 2003;
        this.processEvent(new DTreeItemEvent(this, n, dTreeItem));
        this.invalidateCanvas();
        if (n == 2003) {
            DTreeItem dTreeItem2 = this.getFocusedItem();
            if (DTree.isItemDescendent(dTreeItem2, dTreeItem)) {
                this.setFocusedItem(dTreeItem);
                return;
            }
        } else if (this._layoutFrozenLevel == 0) {
            this.repaintCanvas();
            this._makeChildrenVisible(dTreeItem);
        }
    }

    public boolean itemExpansionChanging(DTreeItem dTreeItem, boolean bl) {
        int n = bl ? 2000 : 2002;
        DTreeItemValidateEvent dTreeItemValidateEvent = new DTreeItemValidateEvent(this, n, dTreeItem);
        this.processEvent(dTreeItemValidateEvent);
        if (!dTreeItemValidateEvent.isCancelled() && n == 2002) {
            DTreeSelection dTreeSelection = this.getSelection();
            dTreeSelection.itemCollapsing(dTreeItemValidateEvent);
        }
        return dTreeItemValidateEvent.isCancelled();
    }

    public void itemsAdded(DTreeItem dTreeItem, int n, int n2) {
        if (!DTree.isItemVisible(dTreeItem) || !dTreeItem.isExpanded()) {
            return;
        }
        DTreeSelection dTreeSelection = this.getSelection();
        dTreeSelection.itemsAdded(dTreeItem, n, n2);
        if (this._layoutFrozenLevel > 0) {
            return;
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        Point point = this.getCanvasOrigin();
        Dimension dimension2 = this.getInnerSize();
        DTreeItem dTreeItem2 = dTreeItem.getItem(n);
        if (dTreeItem2 == null) {
            return;
        }
        int n3 = dTreeItem2.getY();
        if (n3 < -point.y) {
            this.repaint();
            return;
        }
        if (n3 < -point.y + dimension2.height) {
            this.repaint();
        }
    }

    public void itemsInvalidated(DTreeItem dTreeItem, int n, int n2) {
        if (!this.isValid()) {
            this.repaint();
            return;
        }
        DTreeItem dTreeItem2 = dTreeItem.getItem(n);
        DTreeItem dTreeItem3 = dTreeItem.getItem(n + n2 - 1);
        Dimension dimension = this.getInnerSize();
        Point point = this._convertCanvasToInner(0, dTreeItem2.getY());
        Point point2 = this._convertCanvasToInner(0, dTreeItem3.getY());
        point2.y += dTreeItem3.getHeight();
        if (point.y < dimension.height && point2.y > 0) {
            this.repaint();
        }
    }

    public void itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
        if (DTree.isItemVisible(dTreeItem) && dTreeItem.isExpanded()) {
            this.invalidateCanvas();
        }
        DTreeSelection dTreeSelection = this.getSelection();
        dTreeSelection.itemsRemoved(dTreeItem, n, n2);
    }

    public void makeVisible(DTreeItem dTreeItem) {
        Object object;
        if (!DTree.isItemVisible(dTreeItem)) {
            object = dTreeItem.getParent();
            while (object != null) {
                if (!object.isExpanded()) {
                    object.setExpanded(true);
                }
                object = object.getParent();
            }
        }
        this.validate();
        object = this.getCanvasOrigin();
        Rectangle rectangle = this.getInnerBounds();
        int n = dTreeItem.getY();
        Point point = this._convertCanvasToInner(0, n);
        int n2 = dTreeItem.getHeight();
        int n3 = ((Point)object).y;
        if (point.y < 0) {
            n3 = -n;
        } else if (point.y + n2 > rectangle.height) {
            n3 = rectangle.height - (n + n2);
        }
        if (((Point)object).y != n3) {
            this.setCanvasOrigin(((Point)object).x, n3);
        }
    }

    public void removeActivateListener(DTreeActivateListener dTreeActivateListener) {
        if (this._activatelm != null) {
            this._activatelm.removeListener(dTreeActivateListener);
        }
    }

    public void removeExpansionListener(DTreeExpansionListener dTreeExpansionListener) {
        if (this._expandlm != null) {
            this._expandlm.removeListener(dTreeExpansionListener);
        }
    }

    public void removeSelectionListener(DTreeSelectionListener dTreeSelectionListener) {
        if (this._selectlm != null) {
            this._selectlm.removeListener(dTreeSelectionListener);
        }
    }

    public void selectionChanged(DTreeRangeSet dTreeRangeSet, DTreeRangeSet dTreeRangeSet2) {
        this.processEvent(new DTreeSelectionEvent(this, 2006, dTreeRangeSet, dTreeRangeSet2));
    }

    public boolean selectionChanging(DTreeRangeSet dTreeRangeSet, DTreeRangeSet dTreeRangeSet2) {
        DTreeSelValidateEvent dTreeSelValidateEvent = new DTreeSelValidateEvent(this, 2005, dTreeRangeSet, dTreeRangeSet2);
        this.processEvent(dTreeSelValidateEvent);
        return dTreeSelValidateEvent.isCancelled();
    }

    public void setDecoration(DTreeDecoration dTreeDecoration) {
        DTreeDecoration dTreeDecoration2 = this.getDecoration();
        if (dTreeDecoration2 != dTreeDecoration) {
            if (dTreeDecoration == null) {
                dTreeDecoration = DTreeEmptyDecoration.getInstance();
            }
            this._decoration = dTreeDecoration;
            this.invalidateCanvas();
        }
    }

    public void setFocusedItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this.getFocusedItem();
        if (dTreeItem2 != dTreeItem) {
            this._focused = dTreeItem;
            this._paintItemImmediate(dTreeItem2);
            this._paintItemImmediate(this._focused);
            if (this._focused != null) {
                this.makeVisible(this._focused);
            }
        }
    }

    public void setIndentWidth(int n) {
        if (n != this._indentwd) {
            this._indentwd = n;
            this.invalidateCanvas();
        }
    }

    public void setPreferredItemsOnScreen(int n) {
        if (n != this._nositems) {
            this._nositems = n;
            this.invalidate();
        }
    }

    public void setPreferredLevelsOnScreen(int n) {
        if (n != this._noslevels) {
            this._noslevels = n;
            this.invalidate();
        }
    }

    public void setSelection(DTreeSelection dTreeSelection) {
        if (this._selection != dTreeSelection) {
            this._selection.setTree(null);
            this._selection = dTreeSelection == null ? new DTreeSingleSelection() : dTreeSelection;
            this._selection.setTree(this);
        }
    }

    public void setRoot(DTreeRootItem dTreeRootItem) {
        this._setRoot(dTreeRootItem);
    }

    public void unfreezeLayouts() {
        --this._layoutFrozenLevel;
        if (this._layoutFrozenLevel == 0) {
            this.invalidateCanvas();
        }
    }

    public void attachHAdjustable(Adjustable adjustable) {
        this._hAdjustable = adjustable;
    }

    public void attachVAdjustable(Adjustable adjustable) {
        this._vAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
            return;
        }
        if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
            return;
        }
        super.detachAdjustable(adjustable);
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public Dimension getMinimumSize() {
        return this.convertInnerToOuterSize(this.getIndentWidth(), this._rowheight);
    }

    public Dimension getPreferredSize() {
        this.validate();
        int n = this.getIndentWidth() * this.getPreferredLevelsOnScreen();
        int n2 = this._rowheight * this.getPreferredItemsOnScreen();
        return this.convertInnerToOuterSize(n += 100, n2);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    protected int getRowCount() {
        return this._getVisibleItemCount();
    }

    protected int getVMaximum() {
        int n;
        Dimension dimension = this.getCanvasSize();
        if (this._rowheight == 0) {
            n = 0;
        } else {
            n = dimension.height / this._rowheight;
            if (dimension.height % this._rowheight != 0) {
                ++n;
            }
        }
        return n;
    }

    protected int getVOffsetOfValue(int n) {
        return -n * this._rowheight;
    }

    protected int getVValueOfOffset(int n) {
        int n2 = 0;
        if (this._rowheight != 0) {
            n2 = -n / this._rowheight;
            if (-n % this._rowheight != 0) {
                ++n2;
            }
        }
        return n2;
    }

    protected Dimension layoutCanvas() {
        if (this._root == null) {
            return new Dimension(0, 0);
        }
        DTreeDecoration dTreeDecoration = this.getDecoration();
        Insets insets = dTreeDecoration.getDecorationInsets(this);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this._root.layout(insets.left, insets.top);
        int n = this._root.getSubTreeHeight() + insets.top + insets.bottom;
        int n2 = this.getRowCount();
        this._rowheight = n2 == 0 ? 0 : n / n2;
        return new Dimension(this.getCanvasSize().width, n);
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        DTreeItem dTreeItem = this.getItemAt(0, rectangle.y);
        if (dTreeItem == null) {
            return;
        }
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeItem dTreeItem2 = this.getFocusedItem();
        DTreeDecoration dTreeDecoration = this.getDecoration();
        Dimension dimension = this.getCanvasSize();
        int n = dimension.width;
        Insets insets = dTreeDecoration.getDecorationInsets(this);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this._repairDecoration(graphics, dTreeItem.getParent(), dTreeDecoration);
        int n2 = dTreeItem.getY();
        graphics.translate(0, n2);
        while (dTreeItem != null) {
            int n3 = dTreeItem.getX();
            int n4 = dTreeItem.getHeight();
            int n5 = dTreeItem.getWidth();
            if (n2 > rectangle.y + rectangle.height) break;
            if (n2 + n4 > rectangle.y) {
                dTreeDecoration.paintDecoration(graphics, dTreeItem, n3, n4);
                graphics.translate(n3, 0);
                this.paintItem(graphics, dTreeItem, dTreeSelection.isSelected(dTreeItem), dTreeItem == dTreeItem2);
            }
            if (n3 + n5 + insets.right > n) {
                n = n3 + n5 + insets.right;
            }
            if ((dTreeItem = this.getNextVisibleItem(dTreeItem)) == null) continue;
            int n6 = dTreeItem.getY();
            graphics.translate(-n3, n6 - n2);
            n2 = n6;
        }
        if (n > dimension.width) {
            this.setCanvasSize(n, dimension.height);
        }
    }

    protected void paintItem(Graphics graphics, DTreeItem dTreeItem, boolean bl, boolean bl2) {
        dTreeItem.paint(graphics, bl, this.hasFocus() && bl2);
    }

    protected void processActivateEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        if (this._activatelm == null || (enumeration = this._activatelm.getListeners()) == null) {
            return;
        }
        if (dTreeItemEvent.getID() == 2004) {
            while (enumeration.hasMoreElements()) {
                DTreeActivateListener dTreeActivateListener = (DTreeActivateListener)enumeration.nextElement();
                dTreeActivateListener.dTreeItemActivate(dTreeItemEvent);
            }
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof DTreeEvent) {
            switch (aWTEvent.getID()) {
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: {
                    this.processExpansionEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
                case 2004: {
                    this.processActivateEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
                case 2005: 
                case 2006: {
                    this.processSelectionEvent((DTreeSelectionEvent)aWTEvent);
                    break;
                }
            }
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processExpansionEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        if (this._expandlm == null || (enumeration = this._expandlm.getListeners()) == null) {
            return;
        }
        int n = dTreeItemEvent.getID();
        while (enumeration.hasMoreElements()) {
            DTreeExpansionListener dTreeExpansionListener = (DTreeExpansionListener)enumeration.nextElement();
            switch (n) {
                case 2000: {
                    dTreeExpansionListener.dTreeItemExpanding(dTreeItemEvent);
                    break;
                }
                case 2001: {
                    dTreeExpansionListener.dTreeItemExpanded(dTreeItemEvent);
                    break;
                }
                case 2002: {
                    dTreeExpansionListener.dTreeItemCollapsing(dTreeItemEvent);
                    break;
                }
                case 2003: {
                    dTreeExpansionListener.dTreeItemCollapsed(dTreeItemEvent);
                    break;
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        if (n == 1004 || n == 1005) {
            this.repaint();
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        DTreeItem dTreeItem = this.getFocusedItem();
        boolean bl = false;
        if (dTreeItem != null) {
            bl = dTreeItem.isExpanded();
            dTreeItem.processKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        if (keyEvent.getID() == 401) {
            this._handleKeyboardAction(keyEvent, dTreeItem, bl);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.getID() == 501) {
            this.requestFocus();
            Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            DTreeItem dTreeItem = this.getItemAt(point.x, point.y);
            if (dTreeItem != null) {
                Insets insets = this.getInsets();
                Point point2 = this.getCanvasOrigin();
                int n = dTreeItem.getX();
                int n2 = dTreeItem.getY();
                mouseEvent.translatePoint(-point2.x - insets.left, -point2.y - insets.top - n2);
                DTreeDecoration dTreeDecoration = this.getDecoration();
                dTreeDecoration.processMouseEvent(mouseEvent, dTreeItem);
                if (mouseEvent.isConsumed()) {
                    return;
                }
                mouseEvent.translatePoint(-n, 0);
                dTreeItem.processMouseEvent(mouseEvent);
                if (mouseEvent.isConsumed()) {
                    return;
                }
            }
            this._handleMouseSelection(mouseEvent, dTreeItem, point);
        }
    }

    protected void processSelectionEvent(DTreeSelectionEvent dTreeSelectionEvent) {
        Enumeration enumeration;
        int n = dTreeSelectionEvent.getID();
        if (n == 2006) {
            this._paintSelectionChanges(dTreeSelectionEvent);
        }
        if (this._selectlm != null && (enumeration = this._selectlm.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                DTreeSelectionListener dTreeSelectionListener = (DTreeSelectionListener)enumeration.nextElement();
                switch (n) {
                    case 2005: {
                        dTreeSelectionListener.dTreeSelectionChanging(dTreeSelectionEvent);
                        break;
                    }
                    case 2006: {
                        dTreeSelectionListener.dTreeSelectionChanged(dTreeSelectionEvent);
                        break;
                    }
                }
            }
        }
    }

    private Point _convertCanvasToInner(int n, int n2) {
        Point point = this.getCanvasOrigin();
        point.x += n;
        point.y += n2;
        return point;
    }

    private DTreeItem _getFirstVisibleItem() {
        int n;
        DTreeRootItem dTreeRootItem = this.getRoot();
        if (dTreeRootItem != null && (n = dTreeRootItem.getItemCount()) > 0) {
            return dTreeRootItem.getItem(0);
        }
        return null;
    }

    private DTreeItem _getLastVisibleItem() {
        return this._getLastVisibleItem(null);
    }

    private DTreeItem _getLastVisibleItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        if (dTreeItem2 == null) {
            dTreeItem2 = this.getRoot();
        }
        while (dTreeItem2 != null && dTreeItem2.isExpanded()) {
            int n = dTreeItem2.getItemCount();
            DTreeItem dTreeItem3 = null;
            if (n <= 0 || (dTreeItem3 = dTreeItem2.getItem(n - 1)) == null) break;
            dTreeItem2 = dTreeItem3;
        }
        if (dTreeItem2 == this.getRoot()) {
            return null;
        }
        return dTreeItem2;
    }

    private int _getRowsPerPage() {
        if (this._rowheight == 0) {
            return 0;
        }
        return this.getInnerSize().height / this._rowheight;
    }

    private DTreeItem _getSingleSelectedItem(DTreeRangeSet dTreeRangeSet) {
        if (dTreeRangeSet.getCount() != 1) {
            return null;
        }
        DTreeRange dTreeRange = dTreeRangeSet.getRange(0);
        if (dTreeRange.getCount() != 1) {
            return null;
        }
        DTreeItem dTreeItem = dTreeRange.getParent();
        return dTreeItem.getItem(dTreeRange.getStartIndex());
    }

    private int _getVisibleItemCount() {
        int n = 0;
        Enumeration enumeration = this.getExpandedEnumeration();
        while (enumeration.hasMoreElements()) {
            DTreeItem dTreeItem = (DTreeItem)enumeration.nextElement();
            n += dTreeItem.getItemCount();
        }
        return n;
    }

    private void _handleKeyboardAction(KeyEvent keyEvent, DTreeItem dTreeItem, boolean bl) {
        if (dTreeItem == null) {
            if (this.getRoot() == null) {
                return;
            }
            dTreeItem = this.getRoot();
        }
        int n = keyEvent.getKeyCode();
        DTreeItem dTreeItem2 = null;
        switch (n) {
            case 32: {
                dTreeItem2 = this._handleSpace(keyEvent, dTreeItem);
                break;
            }
            case 38: {
                dTreeItem2 = this.getPreviousVisibleItem(dTreeItem);
                break;
            }
            case 40: {
                dTreeItem2 = this.getNextVisibleItem(dTreeItem);
                break;
            }
            case 36: {
                dTreeItem2 = this._getFirstVisibleItem();
                break;
            }
            case 35: {
                dTreeItem2 = this._getLastVisibleItem();
                break;
            }
            case 33: {
                dTreeItem2 = this._handlePageUp(dTreeItem);
                break;
            }
            case 34: {
                dTreeItem2 = this._handlePageDown(dTreeItem);
                break;
            }
            case 37: {
                dTreeItem2 = this._handleLeft(dTreeItem);
                break;
            }
            case 39: {
                dTreeItem2 = this._handleRight(dTreeItem);
                break;
            }
        }
        if (dTreeItem2 != null) {
            if (!keyEvent.isControlDown() || keyEvent.isShiftDown() || n == 32) {
                this._updateSelection(keyEvent, dTreeItem2);
                return;
            }
            this.setFocusedItem(dTreeItem2);
        }
    }

    private DTreeItem _handleLeft(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        if (!(dTreeItem == null || dTreeItem.isExpandable() && dTreeItem.isExpanded() || (dTreeItem2 = dTreeItem.getParent()) != this.getRoot())) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    private void _handleMouseSelection(MouseEvent mouseEvent, DTreeItem dTreeItem, Point point) {
        if (dTreeItem != null) {
            int n = dTreeItem.getX();
            int n2 = dTreeItem.getWidth();
            if (point.x < n || point.x >= n + n2) {
                dTreeItem = null;
            }
        }
        this._updateSelection(mouseEvent, dTreeItem);
    }

    private DTreeItem _handlePageDown(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        int n = this._getRowsPerPage() - 1;
        while (n > 0 && dTreeItem2 != null) {
            dTreeItem2 = this.getNextVisibleItem(dTreeItem2);
            --n;
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = this._getLastVisibleItem();
        }
        return dTreeItem2;
    }

    private DTreeItem _handlePageUp(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        int n = this._getRowsPerPage() - 1;
        while (n > 0 && dTreeItem2 != null) {
            dTreeItem2 = this.getPreviousVisibleItem(dTreeItem2);
            --n;
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = this._getFirstVisibleItem();
        }
        return dTreeItem2;
    }

    private DTreeItem _handleRight(DTreeItem dTreeItem) {
        int n;
        if (dTreeItem != null && dTreeItem.isExpandable() && dTreeItem.isExpanded() && (n = dTreeItem.getItemCount()) > 0) {
            return dTreeItem.getItem(0);
        }
        return null;
    }

    private DTreeItem _handleSpace(KeyEvent keyEvent, DTreeItem dTreeItem) {
        if (keyEvent.isShiftDown() || keyEvent.isControlDown()) {
            return dTreeItem;
        }
        DTreeSelection dTreeSelection = this.getSelection();
        if (!dTreeSelection.isSelected(dTreeItem)) {
            DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
            dTreeRangeSet.addRange(new DTreeRange(dTreeItem.getParent(), dTreeItem.getIndex(), 1));
            dTreeSelection.setSelectionRanges(dTreeRangeSet);
        }
        return null;
    }

    private void _makeChildrenVisible(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this._getLastVisibleItem(dTreeItem);
        if (dTreeItem2 == null) {
            this.makeVisible(dTreeItem);
            return;
        }
        this.validate();
        Point point = this.getCanvasOrigin();
        int n = point.y;
        Rectangle rectangle = this.getInnerBounds();
        int n2 = dTreeItem.getY();
        int n3 = dTreeItem2.getY();
        int n4 = dTreeItem2.getHeight();
        Point point2 = this._convertCanvasToInner(0, n3);
        if (point2.y < 0) {
            n = -n3;
        } else if (point2.y + n4 > rectangle.height) {
            n = rectangle.height - (n3 + n4);
        }
        if (n2 < -n) {
            n = -n2;
        }
        if (n != point.y) {
            this.setCanvasOrigin(point.x, n);
        }
    }

    private void _paintItemImmediate(DTreeItem dTreeItem) {
        if (dTreeItem.getTree() != this) {
            return;
        }
        this.validate();
        int n = dTreeItem.getX();
        int n2 = dTreeItem.getY();
        Point point = this.convertCanvasToOuter(n, n2);
        this.paintImmediate(point.x, point.y, dTreeItem.getWidth(), dTreeItem.getHeight());
    }

    private void _paintSelectionChanges(DTreeSelectionEvent dTreeSelectionEvent) {
        DTreeItem dTreeItem = this._getSingleSelectedItem(dTreeSelectionEvent.getOldSelectionRanges());
        DTreeItem dTreeItem2 = this._getSingleSelectedItem(dTreeSelectionEvent.getNewSelectionRanges());
        if (dTreeItem != null && dTreeItem2 != null) {
            this._paintItemImmediate(dTreeItem);
            this._paintItemImmediate(dTreeItem2);
            return;
        }
        this.repaint();
    }

    private void _repairDecoration(Graphics graphics, DTreeItem dTreeItem, DTreeDecoration dTreeDecoration) {
        DTreeRootItem dTreeRootItem = this.getRoot();
        while (dTreeItem != dTreeRootItem) {
            int n = dTreeItem.getY();
            graphics.translate(0, n);
            dTreeDecoration.paintDecoration(graphics, dTreeItem, dTreeItem.getX(), dTreeItem.getHeight());
            graphics.translate(0, -n);
            dTreeItem = dTreeItem.getParent();
        }
    }

    private void _setRoot(DTreeRootItem dTreeRootItem) {
        if (this._root != dTreeRootItem) {
            if (this._root != null) {
                this._root.setTree(null);
                this._root = null;
            }
            if (dTreeRootItem != null) {
                this._root = dTreeRootItem;
                this._root.setTree(this);
                this._root.setExpanded(true);
            }
            this.invalidateCanvas();
        }
    }

    private void _updateSelection(InputEvent inputEvent, DTreeItem dTreeItem) {
        DTreeSelection dTreeSelection = this.getSelection();
        if (inputEvent.isShiftDown()) {
            dTreeSelection.extendSelection(dTreeItem);
            return;
        }
        if (inputEvent.isControlDown()) {
            dTreeSelection.toggleItem(dTreeItem);
            return;
        }
        dTreeSelection.selectItem(dTreeItem);
    }
}

