/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Font;
import java.awt.FontMetrics;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeChildManager;
import oracle.ewt.dTree.DTreeDeferredChild;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.DTreeSparseChildManager;
import oracle.ewt.dataSource.OneDDataSource;

public abstract class DTreeDeferredParent
extends DTreeDeferredChild
implements DTreeDeferringParent {
    private OneDDataSource _datasrc;
    private DTreeChildManager _childmgr;
    private boolean _expanded;

    protected DTreeDeferredParent(OneDDataSource oneDDataSource) {
        this._datasrc = oneDDataSource;
        this._childmgr = null;
    }

    public void childExpansionChanged(DTreeItem dTreeItem) {
        this._childmgr.childExpansionChanged(dTreeItem);
    }

    public Object getChildData(int n) {
        return this._datasrc.getData(n);
    }

    public int getChildHeight() {
        DTree dTree = this.getTree();
        Font font = dTree.getFont();
        FontMetrics fontMetrics = null;
        if (font == null || (fontMetrics = dTree.getFontMetrics(font)) == null) {
            return 0;
        }
        int n = fontMetrics.getHeight() + 2 * this.getLabelMarginThickness();
        int n2 = this.getChildIconHeight();
        return Math.max(n2, n);
    }

    public int getChildX(int n) {
        return this._childmgr.getChildX(n);
    }

    public int getChildY(int n) {
        return this._childmgr.getChildY(n);
    }

    public OneDDataSource getDataSource() {
        return this._datasrc;
    }

    public DTreeItem getItem(int n) {
        if (this._childmgr == null) {
            this._childmgr = this.createChildManager();
        }
        return this._childmgr.getItem(n);
    }

    public DTreeItem getItemAt(int n, int n2) {
        return this._childmgr.getItemAt(n, n2);
    }

    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    public abstract DTreeItemFactory getItemFactory();

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextExpandedChild(dTreeItem);
    }

    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight();
        }
        return this.getHeight();
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void layout(int n, int n2) {
        this._childmgr.layout(n, n2);
    }

    public void setExpanded(boolean bl) {
        if (bl == this.isExpanded()) {
            return;
        }
        DTree dTree = this.getTree();
        if (dTree == null) {
            this._expanded = bl;
            return;
        }
        if (!dTree.itemExpansionChanging(this, bl)) {
            DTreeDeferringParent dTreeDeferringParent;
            this._expanded = bl;
            if (bl && this._childmgr == null) {
                this._childmgr = this.createChildManager();
            }
            if ((dTreeDeferringParent = this.getDeferringParent()) != null) {
                dTreeDeferringParent.childExpansionChanged(this);
            }
            dTree.itemExpansionChanged(this, bl);
        }
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager(this);
    }

    protected int getChildIconHeight() {
        return 18;
    }
}

