/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeBaseItem;
import oracle.ewt.dTree.DTreeChildManager;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSparseChildManager;
import oracle.ewt.dataSource.OneDDataSource;

public class DTreeDeferringRoot
extends DTreeBaseItem
implements DTreeDeferringParent,
DTreeRootItem {
    private OneDDataSource _datasrc;
    private DTreeItemFactory _factory;
    private DTree _tree;
    private DTreeChildManager _childmgr;
    private String _label;
    private Image _icon;
    private int _y;
    private boolean _expanded;

    public DTreeDeferringRoot(String string, Image image, OneDDataSource oneDDataSource, DTreeItemFactory dTreeItemFactory) {
        this._label = string;
        this._icon = image;
        this._datasrc = oneDDataSource;
        this._factory = dTreeItemFactory;
        this._childmgr = this.createChildManager();
    }

    public void childExpansionChanged(DTreeItem dTreeItem) {
        this._childmgr.childExpansionChanged(dTreeItem);
    }

    public Object getChildData(int n) {
        return this._datasrc.getData(n);
    }

    public int getChildHeight() {
        DTree dTree = this.getTree();
        Font font = dTree.getFont();
        FontMetrics fontMetrics = null;
        if (font == null || (fontMetrics = dTree.getFontMetrics(font)) == null) {
            return 0;
        }
        int n = fontMetrics.getHeight() + 2 * this.getLabelMarginThickness();
        int n2 = this.getChildIconHeight();
        return Math.max(n2, n);
    }

    public int getChildX(int n) {
        return this._childmgr.getChildX(n);
    }

    public int getChildY(int n) {
        return this._childmgr.getChildY(n);
    }

    public OneDDataSource getDataSource() {
        return this._datasrc;
    }

    public Image getIcon() {
        return this._icon;
    }

    public DTreeItem getItem(int n) {
        return this._childmgr.getItem(n);
    }

    public DTreeItem getItemAt(int n, int n2) {
        return this._childmgr.getItemAt(n, n2);
    }

    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    public DTreeItemFactory getItemFactory() {
        return this._factory;
    }

    public String getLabel() {
        return this._label;
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return this._childmgr.getNextExpandedChild(dTreeItem);
    }

    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight();
        }
        return this.getHeight();
    }

    public DTree getTree() {
        DTreeItem dTreeItem = this.getParent();
        if (dTreeItem != null) {
            return dTreeItem.getTree();
        }
        return this._tree;
    }

    public int getY() {
        return this._y;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void layout(int n, int n2) {
        this._y = n2;
        this._childmgr.layout(n, n2);
    }

    public void setExpanded(boolean bl) {
        DTree dTree = this.getTree();
        if (bl == this.isExpanded()) {
            return;
        }
        if (dTree == null) {
            this._expanded = bl;
            return;
        }
        if (!dTree.itemExpansionChanging(this, bl)) {
            this._expanded = bl;
            dTree.itemExpansionChanged(this, bl);
        }
    }

    public void setTree(DTree dTree) {
        this._tree = dTree;
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager(this);
    }

    protected int getChildIconHeight() {
        return 18;
    }
}

