/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import oracle.ewt.graphics.GrayFilter;

public class ImageUtils {
    public static final String CHECK_IMAGE = "check";
    public static final String EXPAND_IMAGE = "expand";
    public static final String COLLAPSE_IMAGE = "collapse";
    private static final String _NOLOAD_DATA = "GIF89a\u000e\u0000\u0010\u0000\u00b3\u0000\u0000\u0000\u0000\u0000\u0080\u0000\u0000\u0000\u0080\u0000\u0080\u0080\u0000\u0000\u0000\u0080\u0080\u0000\u0080\u0000\u0080\u0080\u00c0\u00c0\u00c0\u0080\u0080\u0080\u00ff\u0000\u0000\u0000\u00ff\u0000\u00ff\u00ff\u0000\u0000\u0000\u00ff\u00ff\u0000\u00ff\u0000\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u000f\u0000,\u0000\u0000\u0000\u0000\u000e\u0000\u0010\u0000\u0000\u0004I\u0010\u00c8I\u00d1\u00bb\u00e0\u00ea\u008d\u00ec\u00cbG(\u0086\u0096\u0005\u0086\u0082 z\u00c8)(\u0002\u0010Rn*\u008b\u00dfyH\u00e3\u0091?\u00bd\u0003c\u0098\u0091\u0000\u0013#\u0086\u0083Q\u00045\u0090\u00a1!\u00a1\tl<g\u0093\u00df\u00c1z\u001dii^c0\u009c\u00d9\u00981\u00b4\u00f4$\u0002\u0000;";
    private static Hashtable _imageCache;
    private static Image _sNotLoadedImage;
    static /* synthetic */ Class class$oracle$ewt$graphics$ImageUtils;

    public static Image createDisabledImage(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), GrayFilter.getFilter());
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static Image getCommonImage(String string) {
        Hashtable<String, Image> hashtable = _imageCache;
        if (hashtable == null) {
            hashtable = _imageCache = new Hashtable<String, Image>(3);
        }
        if (hashtable.containsKey(string)) {
            return (Image)hashtable.get(string);
        }
        Image image = ImageUtils.getImageResource(class$oracle$ewt$graphics$ImageUtils != null ? class$oracle$ewt$graphics$ImageUtils : (class$oracle$ewt$graphics$ImageUtils = ImageUtils.class$("oracle.ewt.graphics.ImageUtils")), "images/" + string + ".gif");
        hashtable.put(string, image);
        return image;
    }

    public static Image getImageResource(Class clazz, String string) {
        Image image = ImageUtils._getImageResource(clazz, string);
        if (image == null) {
            image = ImageUtils.getNotLoadedImage();
        }
        return image;
    }

    public static Image getNotLoadedImage() {
        if (_sNotLoadedImage == null) {
            _sNotLoadedImage = ImageUtils._createImage(_NOLOAD_DATA);
        }
        return _sNotLoadedImage;
    }

    public static boolean loadImage(Image image) {
        Loader loader = new Loader();
        loader.start(image);
        return loader.waitFor(image);
    }

    public static boolean loadImages(Image[] imageArray) {
        boolean bl = true;
        Loader loader = new Loader();
        int n = 0;
        while (n < imageArray.length) {
            loader.start(imageArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < imageArray.length) {
            bl = bl && loader.waitFor(imageArray[n2]);
            ++n2;
        }
        return bl;
    }

    private static Image _getImageResource(Class clazz, String string) {
        block18: {
            Object object;
            Image image = null;
            byte[] byArray = null;
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream != null) {
                try {
                    try {
                        int n;
                        int n2 = inputStream.available();
                        byArray = new byte[n2];
                        int n3 = 0;
                        do {
                            if ((n = inputStream.read(byArray, n3, n2 - n3)) <= 0) continue;
                            n3 += n;
                        } while (n3 < n2 && n > 0);
                    }
                    catch (IOException iOException) {
                    }
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byArray != null && !ImageUtils.loadImage(image = Toolkit.getDefaultToolkit().createImage(byArray))) {
                image = null;
            }
            if (image != null) {
                return image;
            }
            URL uRL = clazz.getResource(string);
            if (uRL == null) break block18;
            try {
                object = uRL.getContent();
                image = null;
                if (object instanceof ImageProducer) {
                    ImageProducer imageProducer = (ImageProducer)object;
                    image = Toolkit.getDefaultToolkit().createImage(imageProducer);
                } else if (object instanceof Image) {
                    image = (Image)object;
                }
                if (image != null) {
                    if (ImageUtils.loadImage(image)) {
                        return image;
                    }
                    return null;
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private ImageUtils() {
    }

    private static Image _createImage(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Loader
    implements ImageObserver {
        public synchronized void start(Image image) {
            Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this);
        }

        public synchronized boolean waitFor(Image image) {
            int n;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            while (((n = toolkit.checkImage(image, -1, -1, this)) & 0xF0) == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return (n & 0x30) != 0;
        }

        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0xF0) != 0) {
                this.notifyAll();
                return false;
            }
            return true;
        }

        Loader() {
        }
    }
}

