/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import oracle.ewt.lwAWT.DoubleBuffer;

public class BalkingDoubleBuffer
implements DoubleBuffer {
    private Image _offscreenBuffer;
    private boolean _bufferLocked;

    public synchronized Image getOffscreenBuffer(Component component) {
        if (this._bufferLocked) {
            return null;
        }
        Dimension dimension = component.getSize();
        Image image = this._offscreenBuffer;
        if (image == null || image.getWidth(component) < dimension.width || image.getHeight(component) < dimension.height) {
            if (image != null) {
                image.flush();
                image = null;
            }
            try {
                image = component.createImage(dimension.width, dimension.height);
            }
            catch (Exception exception) {
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        this._offscreenBuffer = image;
        if (image != null) {
            this._bufferLocked = true;
        }
        return image;
    }

    public synchronized void releaseOffscreenBuffer(Image image) {
        if (image == this._offscreenBuffer) {
            this._bufferLocked = false;
            return;
        }
        image.flush();
    }

    public synchronized void flush() {
        if (this._bufferLocked) {
            this._bufferLocked = false;
        } else if (this._offscreenBuffer != null) {
            this._offscreenBuffer.flush();
        }
        this._offscreenBuffer = null;
    }
}

