/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.frame.ArmedButtonFramePainter;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWComponent;

public class LWCheckbox
extends LWComponent
implements ItemSelectable {
    private String _label;
    private boolean _state;
    private LWCheckboxGroup _group;
    private boolean _armed;
    private boolean _mouseDown;
    private boolean _keyDown;
    private ListenerManager _listeners;
    private static int _TEXT_MARGIN = 2;
    private static int _CHECK_SIZE = 13;
    private static int _RADIO_SIZE = 12;
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private static final int _SIMULATE_PUSH_PAUSE = 100;
    private static Image _check;
    private static Image _disabledCheck;
    private static boolean _loaded;

    public LWCheckbox() {
        this("", false, null);
    }

    public LWCheckbox(String string) {
        this(string, false, null);
    }

    public LWCheckbox(String string, boolean bl) {
        this(string, bl, null);
    }

    public LWCheckbox(String string, boolean bl, LWCheckboxGroup lWCheckboxGroup) {
        this.enableEvents(60L);
        this.enableEvents(512L);
        this._label = string;
        this._state = bl;
        this._group = lWCheckboxGroup;
        if (bl && lWCheckboxGroup != null) {
            lWCheckboxGroup.setSelectedCheckbox(this);
        }
        this._getImages();
    }

    public LWCheckbox(String string, LWCheckboxGroup lWCheckboxGroup, boolean bl) {
        this(string, bl, lWCheckboxGroup);
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String string) {
        this._label = string;
        this.invalidate();
        this.repaint();
    }

    public boolean getState() {
        return this._state;
    }

    public void setState(boolean bl) {
        LWCheckboxGroup lWCheckboxGroup = this._group;
        if (lWCheckboxGroup != null && bl) {
            lWCheckboxGroup.setSelectedCheckbox(this);
        }
        this.setStateInternal(bl, false);
    }

    public Object[] getSelectedObjects() {
        if (this.getState()) {
            Object[] objectArray = new Object[]{this.getLabel()};
            return objectArray;
        }
        return null;
    }

    public LWCheckboxGroup getCheckboxGroup() {
        return this._group;
    }

    public void setCheckboxGroup(LWCheckboxGroup lWCheckboxGroup) {
        LWCheckboxGroup lWCheckboxGroup2 = this._group;
        boolean bl = this.getState();
        if (lWCheckboxGroup2 != null && bl) {
            lWCheckboxGroup2.setSelectedCheckbox(null);
        }
        this._group = lWCheckboxGroup;
        if (lWCheckboxGroup != null && bl) {
            lWCheckboxGroup2.setSelectedCheckbox(this);
        }
        if (lWCheckboxGroup2 == null != (lWCheckboxGroup == null)) {
            this.invalidate();
            this.repaint();
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this._listeners.removeListener(itemListener);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.isArmed()) {
                this.setArmed(false);
            }
            this.repaint();
        }
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaint();
        }
    }

    public void paintInterior(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.getBoxSize();
        if (this._group != null) {
            this.paintRadio(graphics, 0, (dimension.height - n) / 2, n, n);
        } else {
            this.paintCheckbox(graphics, 0, (dimension.height - n) / 2, n, n);
        }
        String string = this._label;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getHeight();
        int n4 = n + _TEXT_MARGIN;
        int n5 = (dimension.height - 2 * _TEXT_MARGIN - n3) / 2;
        if (this.hasFocus()) {
            GraphicUtils.drawFocusRect(graphics, n4 + 1, n5 + 1, n2 + 1, n3);
        }
        n4 += _TEXT_MARGIN;
        n5 += _TEXT_MARGIN + fontMetrics.getAscent();
        if (this.isEnabled()) {
            graphics.drawString(string, n4, n5);
            return;
        }
        GraphicUtils.drawDisabledString(graphics, string, n4, n5);
    }

    public Dimension getPreferredSize() {
        int n = this.getBoxSize();
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            String string = this._label;
            boolean bl = fontMetrics != null && string != null;
            int n2 = fontMetrics.stringWidth(string) + 2 * _TEXT_MARGIN + n + 1;
            int n3 = fontMetrics.getHeight() + 2 * _TEXT_MARGIN;
            if (n3 < n) {
                n3 = n;
            }
            return new Dimension(n2, n3);
        }
        return new Dimension(n, n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font2 != this.getFont()) {
            this.invalidate();
            this.repaint();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ItemListener itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (this._keyDown) {
            this.setArmed(false);
            this._keyDown = false;
            this.repaint();
            return;
        }
        this._repaintNotBox();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && this.isEnabled()) {
            int n = keyEvent.getID();
            if (n == 401 && !this.isArmed()) {
                int n2 = keyEvent.getKeyCode();
                if (n2 == 10 || n2 == 32) {
                    keyEvent.consume();
                    this.setArmed(true);
                    this._keyDown = true;
                    this._paintBoxImmediate();
                }
                return;
            }
            if (n == 402 && this._keyDown) {
                keyEvent.consume();
                this.setArmed(false);
                this._keyDown = false;
                this._paintBoxImmediate();
                this.activate();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && !this._keyDown) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 505: {
                    bl = this.processMouseExited(mouseEvent, n, n2);
                    break;
                }
                case 501: {
                    if (!this.contains(n, n2)) break;
                    bl = this.processMousePressed(mouseEvent, n, n2);
                    break;
                }
                case 502: {
                    bl = this.processMouseReleased(mouseEvent, n, n2);
                    break;
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && !this._keyDown) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 506: {
                    bl = this.processMouseDragged(mouseEvent, n, n2);
                    break;
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected boolean processMousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && (mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.isFocusTraversable()) {
                this.requestFocus();
            }
            this.setArmed(true);
            this._paintBoxImmediate();
            this._mouseDown = true;
        }
        return false;
    }

    protected boolean processMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        this._mouseDown = false;
        if (this.isArmed()) {
            this.setArmed(false);
            if (this.contains(n, n2)) {
                this.activate();
            }
            return true;
        }
        return false;
    }

    protected boolean processMouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this._mouseDown) {
            boolean bl = this.contains(n, n2);
            if (this.isArmed() != bl) {
                this.setArmed(bl);
                this._paintBoxImmediate();
            }
            return true;
        }
        return false;
    }

    protected boolean processMouseExited(MouseEvent mouseEvent, int n, int n2) {
        if (this.isArmed()) {
            this.setArmed(false);
            this._paintBoxImmediate();
        }
        return false;
    }

    protected void activate() {
        if (this._group != null) {
            if (this.getState()) {
                this._repaintBox();
                return;
            }
            this._group.setSelectedCheckboxInternal(this, true);
            this.setStateInternal(true, true);
            return;
        }
        this.setStateInternal(!this.getState(), true);
    }

    protected String paramString() {
        String string = super.paramString();
        String string2 = this._label;
        if (string2 != null) {
            string = String.valueOf(string) + ",label=" + string2;
        }
        return String.valueOf(string) + ",state=" + this._state;
    }

    protected boolean isArmed() {
        return this._armed;
    }

    protected void setArmed(boolean bl) {
        this._armed = bl;
    }

    protected int getBoxSize() {
        if (this._group == null) {
            return _CHECK_SIZE;
        }
        return _RADIO_SIZE;
    }

    protected void simulatePush() {
        this.setArmed(true);
        this._paintBoxImmediate();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.setArmed(false);
        this.activate();
    }

    protected void paintCheckbox(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        ArmedButtonFramePainter.getFramePainter().paint(graphics, n, n2, n3, n4, 2);
        graphics.setColor(this.isArmed() ? Color.lightGray : Color.white);
        graphics.fillRect(n += 2, n2 += 2, n3 -= 4, n4 -= 4);
        graphics.setColor(color);
        if (this.getState()) {
            LWCheckbox._loadImages();
            graphics.drawImage(this.isEnabled() ? _check : _disabledCheck, n, n2, n3, n4, this);
        }
    }

    protected void paintRadio(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Color color2 = this.getBackground();
        graphics.setColor(ColorUtils.shadeColor(color2, -102));
        graphics.fillArc(n, n2, n3, n4, 45, 180);
        graphics.setColor(color2);
        graphics.fillArc(n, n2, n3, n4, 45, -180);
        graphics.setColor(ColorUtils.lighterShadeColor(color2));
        graphics.drawArc(n, n2, n3, n4, 45, -180);
        graphics.setColor(this.isArmed() ? color2 : Color.white);
        graphics.fillOval(n += 2, n2 += 2, n3 -= 4, n4 -= 4);
        if (this.getState()) {
            if (!this.isEnabled()) {
                graphics.setColor(ColorUtils.lighterShadeColor(Color.black));
            } else {
                graphics.setColor(Color.black);
            }
            graphics.fillOval(n + 2, n2 + 2, n3 - 4, n4 - 4);
        }
        graphics.setColor(color);
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    synchronized void setStateInternal(boolean bl, boolean bl2) {
        if (bl != this._state) {
            this._state = bl;
            if (bl2) {
                this.processEvent(new ItemEvent(this, 701, this._label, bl ? 1 : 2));
            }
            this._repaintBox();
        }
    }

    private void _paintBoxImmediate() {
        Dimension dimension = this.getSize();
        int n = this.getBoxSize();
        this.paintImmediate(0, (dimension.height - n) / 2, n, n);
    }

    private void _repaintBox() {
        Dimension dimension = this.getSize();
        int n = this.getBoxSize();
        this.repaint(0, (dimension.height - n) / 2, n, n);
    }

    private void _repaintNotBox() {
        Dimension dimension = this.getSize();
        int n = this.getBoxSize();
        this.repaint(n, 0, dimension.width - n, dimension.height);
    }

    private static void _loadImages() {
        if (!_loaded) {
            _loaded = true;
            Image[] imageArray = new Image[]{_check, _disabledCheck};
            ImageUtils.loadImages(imageArray);
        }
    }

    private void _getImages() {
        if (_check == null) {
            _check = ImageUtils.getCommonImage("check");
            _disabledCheck = ImageUtils.createDisabledImage(_check);
            this.prepareImage(_disabledCheck, this);
        }
    }
}

