/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import oracle.ewt.button.ImageContent;
import oracle.ewt.button.PulsingButton;
import oracle.ewt.button.PulsingButtonEvent;
import oracle.ewt.button.PulsingButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ArrowUtils;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.graphics.frame.ButtonFramePainter;
import oracle.ewt.graphics.frame.FramePainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

public class LWScrollbar
extends LWComponent
implements Adjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int _value;
    private int _maximum;
    private int _minimum;
    private int _orientation;
    private int _unitIncrement = 1;
    private int _blockIncrement = 10;
    private int _visible;
    private ListenerManager _listeners;
    private PulsingButton _upArrow;
    private PulsingButton _downArrow;
    private Pulser _pulser;
    private int _barX;
    private int _barY;
    private int _barWidth;
    private int _barHeight;
    PulsingButton _currentButton;
    int _pulseCount;
    private int _dragPos;
    private boolean _draggingThumb;
    private int _dragDelta;
    private int _dragStartPos;
    private int _dragStartValue;
    boolean _blockTracking;
    private boolean _blockGoingDown;
    TaskScheduler _scheduler = TaskScheduler.getDefaultTaskScheduler();
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private static final int _MINIMUM_THUMB_SIZE = 8;
    static final int _FIRST_PULSE_DELAY = 200;
    static final int _PULSE_DELAY = 15;

    public LWScrollbar() {
        this(1, 0, 10, 0, 100);
    }

    public LWScrollbar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public LWScrollbar(int n, int n2, int n3, int n4, int n5) {
        this.setLayout(null);
        this.enableEvents(48L);
        this._orientation = 2;
        this.setOrientation(n);
        this.setValues(n2, n3, n4, n5);
        this.setBackground(SystemColor.control);
    }

    public int getOrientation() {
        return this._orientation;
    }

    public synchronized void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal scrollbar orientation");
        }
        if (n != this._orientation) {
            this._orientation = n;
            if (this._upArrow != null) {
                Image image;
                Image image2;
                if (n == 0) {
                    image2 = ArrowUtils.getLeftArrow();
                    image = ArrowUtils.getRightArrow();
                } else {
                    image2 = ArrowUtils.getUpArrow();
                    image = ArrowUtils.getDownArrow();
                }
                this._upArrow.setContent(new ImageContent(image2));
                this._downArrow.setContent(new ImageContent(image));
            }
            this.invalidate();
        }
    }

    public int getValue() {
        return this._value;
    }

    public final void setValue(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = n;
            n4 = this._visible;
            n3 = this._minimum;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public int getMinimum() {
        return this._minimum;
    }

    public final void setMinimum(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = this._value;
            n4 = this._visible;
            n3 = n;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public int getMaximum() {
        return this._maximum;
    }

    public final void setMaximum(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = this._value;
            n4 = this._visible;
            n3 = this._minimum;
            n2 = n;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public int getVisibleAmount() {
        return this._visible;
    }

    public void setVisibleAmount(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = this._value;
            n4 = n;
            n3 = this._minimum;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    public synchronized void setUnitIncrement(int n) {
        this._unitIncrement = n;
    }

    public int getUnitIncrement() {
        return this._unitIncrement;
    }

    public synchronized void setBlockIncrement(int n) {
        this._blockIncrement = n;
    }

    public int getBlockIncrement() {
        return this._blockIncrement;
    }

    public void setValues(int n, int n2, int n3, int n4) {
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            if (n == this._value && n2 == this._visible && n3 == this._minimum && n4 == this._maximum) {
                Object var6_6 = null;
                return;
            }
            this.setValuesInternal(n, n2, n3, n4);
        }
        this.repaintChangedThumb();
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(adjustmentListener);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._listeners.removeListener(adjustmentListener);
    }

    public Dimension getPreferredSize() {
        this._createArrows();
        Dimension dimension = this._upArrow.getPreferredSize();
        if (this._orientation == 0) {
            return new Dimension(dimension.width * 2 + 50, dimension.height);
        }
        return new Dimension(dimension.width, dimension.height * 2 + 50);
    }

    public Dimension getMinimumSize() {
        this._createArrows();
        Dimension dimension = this._upArrow.getPreferredSize();
        if (this._orientation == 0) {
            return new Dimension(dimension.width * 2 + 8, dimension.height);
        }
        return new Dimension(dimension.width, dimension.height * 2 + 8);
    }

    public void enable() {
        if (this._upArrow != null) {
            this._upArrow.setEnabled(true);
            this._downArrow.setEnabled(true);
        }
        super.enable();
    }

    public void disable() {
        if (this._upArrow != null) {
            this._upArrow.setEnabled(false);
            this._downArrow.setEnabled(false);
        }
        super.disable();
    }

    public void doLayout() {
        this._createArrows();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this._upArrow.getPreferredSize();
        if (this._orientation == 0) {
            this._upArrow.setBounds(0, 0, dimension2.width, dimension.height);
            this._downArrow.setBounds(dimension.width - dimension2.width, 0, dimension2.width, dimension.height);
            this._barX = dimension2.width;
            this._barY = 0;
            this._barWidth = dimension.width - 2 * dimension2.width;
            this._barHeight = dimension.height;
            return;
        }
        this._upArrow.setBounds(0, 0, dimension.width, dimension2.height);
        this._downArrow.setBounds(0, dimension.height - dimension2.height, dimension.width, dimension2.height);
        this._barX = 0;
        this._barY = dimension2.height;
        this._barWidth = dimension.width;
        this._barHeight = dimension.height - 2 * dimension2.height;
    }

    public void setBackground(Color color) {
        if (this._upArrow != null) {
            this._upArrow.setBackground(color);
            this._downArrow.setBackground(color);
        }
        super.setBackground(color);
    }

    public boolean isChildClipped(Component component) {
        return this.isClippedBySibling();
    }

    public boolean isTransparent() {
        return false;
    }

    public void paintInterior(Graphics graphics) {
        this.getSize();
        Color color = this.getBackground();
        graphics.setColor(ColorUtils.shadeColor(color, 25));
        graphics.fillRect(this._barX, this._barY, this._barWidth, this._barHeight);
        Rectangle rectangle = this.getThumbBounds();
        if (rectangle == null) {
            return;
        }
        if (this._blockTracking) {
            graphics.setColor(this.getForeground());
            if (this._blockGoingDown) {
                if (this._orientation == 0) {
                    graphics.fillRect(this._barX, this._barY, rectangle.x - this._barX, this._barHeight);
                } else {
                    graphics.fillRect(this._barX, this._barY, this._barWidth, rectangle.y - this._barY);
                }
            } else if (this._orientation == 0) {
                graphics.fillRect(rectangle.x + rectangle.width, this._barY, this._barWidth - (rectangle.x - this._barX) - rectangle.width, this._barHeight);
            } else {
                graphics.fillRect(this._barX, rectangle.y + rectangle.height, this._barWidth, this._barHeight - (rectangle.y - this._barY) - rectangle.height);
            }
        }
        graphics.setColor(color);
        this.paintThumb(graphics, rectangle);
        graphics.setColor(this.getForeground());
    }

    protected void paintThumb(Graphics graphics, Rectangle rectangle) {
        graphics.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        FramePainter framePainter = ButtonFramePainter.getFramePainter();
        framePainter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 2);
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                AdjustmentListener adjustmentListener = (AdjustmentListener)enumeration.nextElement();
                adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!this.contains(n, n2)) break;
                    bl = this.processMousePressed(mouseEvent, n, n2);
                    break;
                }
                case 502: {
                    bl = this.processMouseReleased(mouseEvent, n, n2);
                    break;
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 506: {
                    bl = this.processMouseDragged(mouseEvent, n, n2);
                    break;
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected boolean processMousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this._draggingThumb || this._blockTracking) {
            return false;
        }
        if (this.isEnabled() && (mouseEvent.getModifiers() & 0x10) != 0) {
            Rectangle rectangle = this.getThumbBounds();
            if (rectangle == null) {
                return false;
            }
            int n3 = this._orientation;
            if (rectangle.contains(n, n2)) {
                this._draggingThumb = true;
                if (n3 == 0) {
                    this._dragDelta = rectangle.x - n;
                    this._dragPos = n - this._barX;
                } else {
                    this._dragDelta = rectangle.y - n2;
                    this._dragPos = n2 - this._barY;
                }
                this._dragPos += this._dragDelta;
                this._dragStartPos = this._dragPos;
                this._dragStartValue = this._value;
            } else {
                this._blockTracking = true;
                this._dragPos = n3 == 0 ? n : n2;
                this._blockGoingDown = this._belowThumb(this._dragPos, rectangle);
                this._doPulse();
                Pulser pulser = this._pulser;
                if (pulser != null) {
                    this._scheduler.schedule(pulser, 200);
                }
            }
        }
        return false;
    }

    protected boolean processMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        if (this._draggingThumb) {
            this.processMouseDragged(mouseEvent, n, n2);
        } else if (this._blockTracking) {
            this._blockTracking = false;
            this.repaintChangedThumb();
        }
        return false;
    }

    protected boolean processMouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this._draggingThumb) {
            int n3;
            int n4 = mouseEvent.getID();
            if (this._orientation == 0) {
                n3 = n - this._barX + this._dragDelta;
                if (n3 > this._barWidth) {
                    n3 = this._barWidth;
                }
            } else {
                n3 = n2 - this._barY + this._dragDelta;
                if (n3 > this._barHeight) {
                    n3 = this._barHeight;
                }
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 != this._dragPos || n4 == 502) {
                int n5;
                int n6;
                if (n3 == this._dragStartPos) {
                    n6 = this._dragStartValue;
                } else {
                    n5 = this._orientation == 0 ? this._barWidth : this._barHeight;
                    long l = this._maximum - this._minimum;
                    n6 = (int)(((long)n3 * l + (long)(n5 / 2)) / (long)n5);
                }
                n5 = this._value;
                if (n6 != n5) {
                    this.setValuesInternal(n6, this._visible, this._minimum, this._maximum);
                    if (n5 != this._value) {
                        this.postAdjustmentEvent(5);
                    }
                }
                this._dragPos = n3;
                if (n4 == 502) {
                    this._draggingThumb = false;
                }
                this.repaintChangedThumb();
            }
        } else if (this._blockTracking) {
            this._dragPos = this._orientation == 0 ? n : n2;
        }
        return false;
    }

    protected Rectangle getThumbBounds() {
        int n;
        long l = this._orientation == 0 ? this._barWidth : this._barHeight;
        if (l < 8L) {
            return null;
        }
        int n2 = this._maximum - this._minimum;
        if (this._draggingThumb) {
            n = this._dragPos;
        } else {
            n = this._value - this._minimum;
            n = (int)((l * (long)n + (long)(n2 - 1)) / (long)n2);
        }
        int n3 = (int)((l * (long)this._visible + (long)(n2 - 1)) / (long)n2);
        if (n3 < 8) {
            n3 = 8;
        }
        if (n < 0) {
            n = 0;
        }
        if ((long)(n + n3) > l) {
            n = (int)(l - (long)n3);
        }
        if (this._orientation == 0) {
            return new Rectangle(this._barX + n, 0, n3, this._barHeight);
        }
        return new Rectangle(0, this._barY + n, this._barWidth, n3);
    }

    protected void repaintChangedThumb() {
        if (this._blockTracking || this._draggingThumb || this._currentButton != null) {
            this.paintImmediate(this._barX, this._barY, this._barWidth, this._barHeight);
            return;
        }
        this.repaint(this._barX, this._barY, this._barWidth, this._barHeight);
    }

    protected synchronized void setValuesInternal(int n, int n2, int n3, int n4) {
        if (n4 <= n3) {
            n4 = n3 + 1;
        }
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4 - n2) {
            n = n4 - n2;
        }
        this._value = n;
        this._visible = n2;
        this._minimum = n3;
        this._maximum = n4;
    }

    protected void postAdjustmentEvent(int n) {
        this.processEvent(new AdjustmentEvent(this, 601, n, this._value));
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",val=" + this._value + ",vis=" + this._visible + ",min=" + this._minimum + ",max=" + this._maximum + (this._orientation == 1 ? ",vert" : ",horz");
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    void _doPulse() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this._blockTracking) {
            Rectangle rectangle = this.getThumbBounds();
            n2 = this._blockGoingDown;
            if (n2 != 0 && this._belowThumb(this._dragPos, rectangle) || n2 == 0 && this._aboveThumb(this._dragPos, rectangle)) {
                n3 = this._blockIncrement;
                if (n2 != 0) {
                    n4 = 3;
                    n3 = -n3;
                } else {
                    n4 = 4;
                }
            }
        } else {
            if (this._currentButton == null) {
                return;
            }
            n3 = this.getUnitIncrement();
            if (this._currentButton == this._upArrow) {
                n3 = -n3;
                n4 = 2;
            } else {
                n4 = 1;
            }
            this._currentButton.setDelay(this._pulseCount++ > 0 ? 15 : 200);
        }
        if ((n2 = (n = this.getValue()) + n3) < this._minimum) {
            n2 = this._minimum;
        } else if (n2 > this._maximum - this._visible) {
            n2 = this._maximum - this._visible;
        }
        if (n2 != n) {
            this.setValue(n2);
            this.postAdjustmentEvent(n4);
        }
    }

    private boolean _belowThumb(int n, Rectangle rectangle) {
        if (this._orientation == 0) {
            return n < rectangle.x;
        }
        return n < rectangle.y;
    }

    private boolean _aboveThumb(int n, Rectangle rectangle) {
        if (this._orientation == 0) {
            return n > rectangle.x + rectangle.width;
        }
        return n > rectangle.y + rectangle.height;
    }

    private void _createArrows() {
        if (this._upArrow != null) {
            return;
        }
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            if (this._upArrow != null) {
                Object var2_2 = null;
                return;
            }
            this._pulser = new Pulser();
            PulsingButton pulsingButton = new PulsingButton(new ImageContent(null), this._pulser);
            pulsingButton.addPulsingButtonListener(this._pulser);
            pulsingButton.setFocusable(false);
            pulsingButton.setEnabled(this.isEnabled());
            pulsingButton.setBackground(this.getBackground());
            this._downArrow = pulsingButton;
            PulsingButton pulsingButton2 = new PulsingButton(new ImageContent(null), this._pulser);
            pulsingButton2.addPulsingButtonListener(this._pulser);
            pulsingButton2.setFocusable(false);
            pulsingButton2.setEnabled(this.isEnabled());
            pulsingButton2.setBackground(this.getBackground());
            this._upArrow = pulsingButton2;
            int n = this._orientation;
            this._orientation = 2;
            this.setOrientation(n);
        }
        this.add(this._upArrow);
        this.add(this._downArrow);
    }

    class Pulser
    implements PulsingButtonListener,
    Task,
    Runnable {
        public void run() {
            LWScrollbar.this._doPulse();
        }

        public void runTask(TaskEvent taskEvent) {
            LWScrollbar.this._doPulse();
            if (LWScrollbar.this._blockTracking) {
                LWScrollbar.this._scheduler.schedule(this, 15);
            }
        }

        public void pulseStartPulsing(PulsingButtonEvent pulsingButtonEvent) {
            LWScrollbar.this._currentButton = (PulsingButton)pulsingButtonEvent.getSource();
            LWScrollbar.this._pulseCount = 0;
            LWScrollbar.this._currentButton.setDelay(200);
        }

        public synchronized void pulseEndPulsing(PulsingButtonEvent pulsingButtonEvent) {
            LWScrollbar.this._currentButton = null;
        }

        Pulser() {
            LWScrollbar.this = LWScrollbar.this;
        }
    }
}

