/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.scrolling.arrowBox;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Enumeration;
import oracle.ewt.EwtComponent;
import oracle.ewt.button.ImageContent;
import oracle.ewt.button.PulsingButton;
import oracle.ewt.button.PulsingButtonEvent;
import oracle.ewt.button.PulsingButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ArrowUtils;
import oracle.ewt.scrolling.Scrollable;
import oracle.ewt.util.Assert;

public class ArrowBox
extends EwtComponent
implements Adjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    private Component _content;
    private Scrollable _scrollable;
    private int _orientation;
    private int _displayPolicy;
    private boolean _together;
    private Insets _buttonInsets;
    PulsingButton _upButton;
    PulsingButton _downButton;
    private int _value;
    private int _min;
    private int _max;
    private int _unit;
    private int _block;
    private int _visible;
    private ListenerManager _listeners;

    public ArrowBox() {
        this(null, 0, 0);
    }

    public ArrowBox(Component component, int n, int n2) {
        this.setLayout(null);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this._orientation = n;
        this._buttonInsets = new Insets(0, 0, 0, 0);
        Pulser pulser = new Pulser();
        this._value = 0;
        this._min = 0;
        this._max = 100;
        this._unit = 1;
        this._block = 10;
        this._visible = 10;
        this._upButton = new PulsingButton(new ImageContent(null), pulser);
        this._downButton = new PulsingButton(new ImageContent(null), pulser);
        this._upButton.setFocusable(false);
        this._downButton.setFocusable(false);
        this._upButton.addPulsingButtonListener(pulser);
        this._downButton.addPulsingButtonListener(pulser);
        this._setButtonContents();
        this.setContent(component);
        this.setDisplayPolicy(n2);
        this.add(this._upButton);
        this.add(this._downButton);
    }

    public int getDisplayPolicy() {
        return this._displayPolicy;
    }

    public void setDisplayPolicy(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this._displayPolicy = n;
        this._setButtonsVisible();
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        if (this._orientation != n) {
            this._detachAdjustable();
            this._orientation = n;
            this._attachAdjustable();
            this.invalidateCanvas();
        }
    }

    public Component getContent() {
        return this._content;
    }

    public void setContent(Component component) {
        if (component == this._content) {
            return;
        }
        if (this._content != null) {
            this._detachAdjustable();
            this.remove(this._content);
        }
        if (component != null) {
            this.add(component);
        }
        this._content = component;
        this._scrollable = (Scrollable)((Object)component);
        this._attachAdjustable();
        this.invalidateCanvas();
    }

    public Insets getButtonInsets() {
        return (Insets)this._buttonInsets.clone();
    }

    public void setButtonInsets(Insets insets) {
        if (!this._buttonInsets.equals(insets)) {
            this._buttonInsets = insets;
            this.invalidateCanvas();
        }
    }

    public boolean getArrowsTogether() {
        return this._together;
    }

    public void setArrowsTogether(boolean bl) {
        if (this._together != bl) {
            this._together = bl;
            this.invalidateCanvas();
        }
    }

    public void setMinimum(int n) {
        if (this._min != n) {
            this._min = n;
            this._configureButtons();
            this._setButtonsVisible();
        }
    }

    public int getMinimum() {
        return this._min;
    }

    public void setMaximum(int n) {
        if (this._max != n) {
            this._max = n;
            this._configureButtons();
            this._setButtonsVisible();
        }
    }

    public int getMaximum() {
        return this._max;
    }

    public void setUnitIncrement(int n) {
        this._unit = n;
    }

    public int getUnitIncrement() {
        return this._unit;
    }

    public void setBlockIncrement(int n) {
        this._block = n;
    }

    public int getBlockIncrement() {
        return this._block;
    }

    public void setVisibleAmount(int n) {
        if (this._visible != n) {
            this._visible = n;
            this._configureButtons();
            this._setButtonsVisible();
        }
    }

    public int getVisibleAmount() {
        return this._visible;
    }

    public void setValue(int n) {
        this.setValue(n, 4);
    }

    public int getValue() {
        return this._value;
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._listeners.removeListener(adjustmentListener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._content == null ? new Dimension() : this._content.getPreferredSize();
        return this._preferredSize(dimension);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this._content == null ? new Dimension() : this._content.getMinimumSize();
        return this._preferredSize(dimension);
    }

    public void doLayout() {
        if (this._content == null) {
            return;
        }
        Dimension dimension = this.getSize();
        boolean bl = this._upButton.isVisible();
        if (!bl) {
            this._content.setBounds(0, 0, dimension.width, dimension.height);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            Insets insets = this._buttonInsets;
            Dimension dimension2 = this._upButton.getPreferredSize();
            if (this.getOrientation() == 0) {
                n10 = dimension2.width;
                n9 = dimension.height - insets.top - insets.bottom;
                n8 = dimension.width - 2 * (n10 + insets.left + insets.right);
                n7 = dimension.height;
                n5 = n6 = insets.top;
                n4 = 0;
                if (this._together) {
                    n3 = 0;
                    n2 = n8 + insets.left;
                    n = n2 + n10 + 2 * insets.right;
                } else {
                    n2 = insets.left;
                    n3 = n2 + n10 + insets.right;
                    n = dimension.width - insets.left - n10;
                }
            } else {
                n10 = dimension.width - insets.left - insets.right;
                n9 = dimension2.height;
                n8 = dimension.width;
                n7 = dimension.height - 2 * (n9 + insets.top + insets.bottom);
                n2 = n = insets.left;
                n3 = 0;
                if (this._together) {
                    n4 = 0;
                    n5 = n7 + insets.top;
                    n6 = n5 + n9 + 2 * insets.bottom;
                } else {
                    n5 = insets.top;
                    n4 = n5 + n9 + insets.bottom;
                    n6 = dimension.height - insets.top - n9;
                }
            }
            this._upButton.setBounds(n2, n5, n10, n9);
            this._downButton.setBounds(n, n6, n10, n9);
            this._content.setBounds(n3, n4, n8, n7);
        }
        if (!this._content.isValid()) {
            this._content.doLayout();
        }
        if (bl != this._upButton.isVisible()) {
            this.doLayout();
        }
    }

    public boolean isChildClipped(Component component) {
        return this.isClippedBySibling();
    }

    private void _configureButtons() {
        int n = this.getValue();
        this._upButton.setEnabled(n > this.getMinimum());
        this._downButton.setEnabled(n < this.getMaximum() - this.getVisibleAmount());
    }

    private void _setButtonsVisible() {
        boolean bl;
        if (this._displayPolicy == 1) {
            bl = true;
        } else {
            boolean bl2 = bl = this.getMinimum() + this.getVisibleAmount() < this.getMaximum();
        }
        if (bl != this._upButton.isVisible()) {
            this._upButton.setVisible(bl);
            this._downButton.setVisible(bl);
            this.invalidateCanvas();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                AdjustmentListener adjustmentListener = (AdjustmentListener)enumeration.nextElement();
                adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    private void _sendAdjustmentEvent(int n, int n2) {
        switch (n2) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 5;
                break;
            }
            default: {
                Assert.assert(false);
            }
        }
        this.processEvent(new AdjustmentEvent(this, 601, n2, n));
    }

    void setValue(int n, int n2) {
        if (n < this._min) {
            n = this._min;
        }
        if (n > this._max - this._visible) {
            n = this._max - this._visible;
        }
        if (this._value != n) {
            this._value = n;
            if (n2 != 4) {
                if (this.getOrientation() == 0) {
                    this._scrollable.handleHScroll(n, n2);
                } else {
                    this._scrollable.handleVScroll(n, n2);
                }
            }
            this._configureButtons();
            this._sendAdjustmentEvent(n, n2);
        }
    }

    private Dimension _preferredSize(Dimension dimension) {
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = this._upButton.getPreferredSize();
        Insets insets = this._buttonInsets;
        if (insets != null) {
            dimension3.width += insets.left + insets.right;
            dimension3.height += insets.top + insets.bottom;
        }
        if (this.getOrientation() == 0) {
            dimension2.width = 2 * dimension3.width + dimension.width;
            dimension2.height = Math.max(dimension3.height, dimension.height);
        } else {
            dimension2.width = Math.max(dimension3.width, dimension.width);
            dimension2.height = 2 * dimension3.height + dimension.height;
        }
        return dimension2;
    }

    private void _attachAdjustable() {
        if (this._scrollable != null) {
            if (this.getOrientation() == 0) {
                this._scrollable.attachHAdjustable(this);
                return;
            }
            this._scrollable.attachVAdjustable(this);
        }
    }

    private void _detachAdjustable() {
        if (this._scrollable != null) {
            this._scrollable.detachAdjustable(this);
        }
    }

    private void _setButtonContents() {
        boolean bl = this.getOrientation() == 1;
        this._upButton.setContent(new ImageContent(bl ? ArrowUtils.getUpArrow() : ArrowUtils.getLeftArrow()));
        this._downButton.setContent(new ImageContent(bl ? ArrowUtils.getDownArrow() : ArrowUtils.getRightArrow()));
    }

    private class Pulser
    implements Runnable,
    PulsingButtonListener {
        private PulsingButton _currentButton;

        public void run() {
            if (this._currentButton != null) {
                int n;
                int n2 = ArrowBox.this.getValue();
                int n3 = ArrowBox.this.getUnitIncrement();
                if (this._currentButton == ArrowBox.this._upButton) {
                    n2 -= n3;
                    n = 0;
                } else {
                    n2 += n3;
                    n = 1;
                }
                ArrowBox.this.setValue(n2, n);
            }
        }

        public void pulseStartPulsing(PulsingButtonEvent pulsingButtonEvent) {
            this._currentButton = (PulsingButton)pulsingButtonEvent.getSource();
        }

        public void pulseEndPulsing(PulsingButtonEvent pulsingButtonEvent) {
            this._currentButton = null;
        }

        Pulser() {
            ArrowBox.this = ArrowBox.this;
        }
    }
}

