/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.scrolling.scrollBox;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.BorderManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.scrolling.Scrollable;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.scrolling.scrollBox.EwtLWScrollbar;
import oracle.ewt.scrolling.scrollBox.ScrollBoxClipLayout;
import oracle.ewt.scrolling.scrollBox.ScrollBoxEventAdapter;
import oracle.ewt.scrolling.scrollBox.ScrollBoxLayout;

public class ScrollBox
extends LWComponent
implements AdjustmentListener,
BorderManager {
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    public static final int DISPLAY_NEVER = 2;
    private Component _content;
    private Scrollable _scrollable;
    private Container _clip;
    private EwtLWScrollbar _hscroll = new EwtLWScrollbar(0);
    private EwtLWScrollbar _vscroll = new EwtLWScrollbar(1);
    private int _hDisplayPolicy;
    private int _vDisplayPolicy;
    private Border _border;

    public ScrollBox() {
        this(null);
    }

    public ScrollBox(Component component) {
        this(component, 1, 1);
    }

    public ScrollBox(Component component, int n, int n2) {
        ScrollBoxEventAdapter scrollBoxEventAdapter = new ScrollBoxEventAdapter(this);
        this._hscroll.addComponentListener(scrollBoxEventAdapter);
        this._vscroll.addComponentListener(scrollBoxEventAdapter);
        this._hscroll.addAdjustmentListener(this);
        this._vscroll.addAdjustmentListener(this);
        this.setLayout(new ScrollBoxLayout());
        this.setContent(component);
        this._updateDisplayPolicy(n, this._hscroll);
        this._updateDisplayPolicy(n2, this._vscroll);
    }

    public void addHAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._hscroll.addAdjustmentListener(adjustmentListener);
    }

    public void addVAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._vscroll.addAdjustmentListener(adjustmentListener);
    }

    public final Border getBorder() {
        return this._border;
    }

    public Component getContent() {
        return this._content;
    }

    public int getHLineIncrement() {
        return this._hscroll.getUnitIncrement();
    }

    public int getHPageIncrement() {
        return this._hscroll.getBlockIncrement();
    }

    public int getHDisplayPolicy() {
        return this._hDisplayPolicy;
    }

    public int getVDisplayPolicy() {
        return this._vDisplayPolicy;
    }

    public Point getScrollPosition() {
        Point point = null;
        point = this._scrollable != null ? this._scrollable.getCanvasOrigin() : this._content.getLocation();
        point.x = -point.x;
        point.y = -point.y;
        return point;
    }

    public Dimension getContentSize() {
        Dimension dimension = null;
        dimension = this._scrollable != null ? this._scrollable.getCanvasSize() : this._content.getSize();
        return dimension;
    }

    public int getVLineIncrement() {
        return this._vscroll.getUnitIncrement();
    }

    public int getVPageIncrement() {
        return this._vscroll.getBlockIncrement();
    }

    public Dimension getViewPortSize() {
        if (this._clip != null) {
            return this._clip.getSize();
        }
        return this._content.getSize();
    }

    public void removeHAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._hscroll.removeAdjustmentListener(adjustmentListener);
    }

    public void removeVAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._vscroll.removeAdjustmentListener(adjustmentListener);
    }

    public void setBorder(Border border) {
        if (this._border != null) {
            this._border.unmanageNotify();
            this._border = null;
        }
        if (border != null) {
            this._border = border;
            border.manageNotify(this);
        }
        this.invalidate();
        this.repaint();
    }

    public void setContent(Component component) {
        if (component == this._content) {
            return;
        }
        if (this._content != null) {
            Container container = this;
            if (this._clip != null) {
                container = this._clip;
                this.remove(this._clip);
                this._clip = null;
            }
            container.remove(this._content);
            this._content = null;
            if (this._scrollable != null) {
                this._hscroll.setScrollee(null);
                this._vscroll.setScrollee(null);
                this._scrollable = null;
            }
        }
        if (component == null) {
            return;
        }
        this._content = component;
        if (component instanceof Scrollable) {
            this.add("Center", component);
            this._scrollable = (Scrollable)((Object)component);
            if (this._scrollable.isHScrollable()) {
                this._hscroll.setScrollee(this._scrollable);
            }
            if (this._scrollable.isVScrollable()) {
                this._vscroll.setScrollee(this._scrollable);
                return;
            }
        } else {
            this._clip = new LWComponent();
            this.add("Center", this._clip);
            this._clip.setLayout(new ScrollBoxClipLayout());
            this._clip.add("Content", component);
        }
    }

    public void setHLineIncrement(int n) {
        this._hscroll.setUnitIncrement(n);
    }

    public void setHDisplayPolicy(int n) {
        if (this._hDisplayPolicy != n) {
            this._updateDisplayPolicy(n, this._hscroll);
        }
    }

    public void setHPageIncrement(int n) {
        this._hscroll.setBlockIncrement(n);
    }

    public final void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setScrollPosition(int n, int n2) throws ScrollableException {
        if (this._scrollable != null) {
            this._scrollable.setCanvasOrigin(-n, -n2);
            return;
        }
        this._content.setLocation(-n, -n2);
        this._hscroll.setValue(n);
        this._vscroll.setValue(n2);
    }

    public void setVDisplayPolicy(int n) {
        if (this._vDisplayPolicy != n) {
            this._updateDisplayPolicy(n, this._vscroll);
        }
    }

    public void setVLineIncrement(int n) {
        this._vscroll.setUnitIncrement(n);
    }

    public void setVPageIncrement(int n) {
        this._vscroll.setBlockIncrement(n);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this._scrollable != null || this._content == null) {
            return;
        }
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n = adjustmentEvent.getValue();
        Point point = this._content.getLocation();
        if (adjustable == this._hscroll) {
            point.x = -n;
        } else if (adjustable == this._vscroll) {
            point.y = -n;
        } else {
            return;
        }
        this._content.setLocation(point.x, point.y);
    }

    public Color getBorderBackground() {
        return this.getBackground();
    }

    public Color getBorderForeground() {
        return this.getForeground();
    }

    public void borderRepaintNotify() {
        this.repaint();
    }

    public void borderResizeNotify() {
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._border != null) {
            Dimension dimension = this.getSize();
            this._border.paint(graphics, 0, 0, dimension.width, dimension.height, this);
        }
    }

    public void doLayout() {
        super.doLayout();
        if (this._clip != null) {
            if (!this._clip.isValid()) {
                this._clip.doLayout();
            }
            this._configureScrollbars();
        }
    }

    public final Insets insets() {
        if (this._border != null) {
            return this._border.getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    public boolean isChildClipped(Component component) {
        return this.isClippedBySibling();
    }

    private void _configureScrollbars() {
        if (this._scrollable != null || this._content == null) {
            return;
        }
        Dimension dimension = this._content.getSize();
        Dimension dimension2 = this._clip.getSize();
        int n = this._hscroll.getValue();
        int n2 = this._vscroll.getValue();
        int n3 = dimension.width - dimension2.width;
        int n4 = dimension.height - dimension2.height;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n > n3 || n2 > n4) {
            if (n > n3) {
                n = n3;
            } else {
                n2 = n4;
            }
            this._content.setLocation(-n, -n2);
        }
        this._hscroll.setValues(n, dimension2.width, 0, dimension.width);
        this._vscroll.setValues(n2, dimension2.height, 0, dimension.height);
    }

    private void _updateDisplayPolicy(int n, EwtLWScrollbar ewtLWScrollbar) {
        int n2 = ewtLWScrollbar.getOrientation();
        if (n == 2) {
            ewtLWScrollbar.setVisible(false);
            if (ewtLWScrollbar.getParent() != null) {
                this.remove(ewtLWScrollbar);
            }
        } else {
            if (ewtLWScrollbar.getParent() == null) {
                this.add((Component)ewtLWScrollbar, n2 == 0 ? "Hscroll" : "Vscroll");
            }
            if (n == 1) {
                ewtLWScrollbar.setVisible(true);
            }
        }
        boolean bl = n != 0;
        ewtLWScrollbar.setDisplayedAlways(bl);
        if (n2 == 0) {
            this._hDisplayPolicy = n;
            return;
        }
        this._vDisplayPolicy = n;
    }
}

