/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Enumeration;
import oracle.ewt.layout.EqualRowLayout;

class WizardRowLayout
extends EqualRowLayout {
    public static final String CANCEL_CONSTRAINT = "Cancel";
    public static final String HELP_CONSTRAINT = "Help";
    public static final String BACK_CONSTRAINT = "Back";
    public static final String NEXT_CONSTRAINT = "Next";
    public static final String APPLY_CONSTRAINT = "Apply";
    public static final String FINISH_CONSTRAINT = "Finish";
    private Component _cancel;
    private Component _help;
    private Component _back;
    private Component _next;
    private Component _apply;
    private Component _finish;
    private int _reserved;

    public WizardRowLayout(int n) {
        super(n);
    }

    public void setReservedButtonSpaces(int n) {
        this._reserved = n;
    }

    public int getReservedButtonSpaces() {
        return this._reserved;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = this.getCellSize(container);
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = n + this.getInteriorGap();
        int n4 = container.getSize().width - insets.right;
        int n5 = insets.top;
        this._finish.setBounds(n4 - n, n5, n, n2);
        n4 -= n3;
        if (this._apply.isVisible()) {
            this._apply.setBounds(n4 - n, n5, n, n2);
            n4 -= n3;
        }
        this._next.setBounds(n4 - n, n5, n, n2);
        this._back.setBounds((n4 -= n) - n, n5, n, n2);
        n4 -= n3;
        int n6 = insets.left;
        Enumeration enumeration = this.getComponentEnumeration(container);
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.isVisible()) continue;
            if (component == this._back) break;
            if (n6 + n > n4) {
                n = n4 - n6 - this.getInteriorGap();
            }
            if (n < 0) {
                n = 0;
            }
            component.setBounds(n6, n5, n, n2);
            n6 += n3;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        if (CANCEL_CONSTRAINT.equals(string)) {
            this._cancel = component;
            return;
        }
        if (HELP_CONSTRAINT.equals(string)) {
            this._help = component;
            return;
        }
        if (APPLY_CONSTRAINT.equals(string)) {
            this._apply = component;
            return;
        }
        if (FINISH_CONSTRAINT.equals(string)) {
            this._finish = component;
            return;
        }
        if (NEXT_CONSTRAINT.equals(string)) {
            this._next = component;
            return;
        }
        if (BACK_CONSTRAINT.equals(string)) {
            this._back = component;
        }
    }

    protected Dimension getInsetLayoutSize(Container container, boolean bl) {
        if (this._reserved == 0) {
            return super.getInsetLayoutSize(container, bl);
        }
        int n = this._reserved;
        n += 4;
        if (this._help.isVisible()) {
            ++n;
        }
        if (this._apply.isVisible()) {
            ++n;
        }
        Dimension dimension = this.getCellSize(container);
        int n2 = dimension.width * n;
        if (n > 1) {
            n2 += this.getInteriorGap() * (n - 1);
        }
        return new Dimension(n2, dimension.height);
    }

    protected Dimension getCellSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getPreferredSize();
            if (n2 < dimension.height) {
                n2 = dimension.height;
            }
            if (n < dimension.width) {
                n = dimension.width;
            }
            ++n4;
        }
        return new Dimension(n * 7 / 5, n2);
    }
}

