/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.help.HelpBook;
import oracle.help.util.Library;
import oracle.help.util.LibraryEvent;
import oracle.help.util.LibraryListener;

public class LibraryDataSource
implements OneDDataSource,
LibraryListener {
    protected Library _library;
    protected ListenerManager _manager;
    protected Vector _books;

    public LibraryDataSource(Library library) {
        this._library = library;
        library.addLibraryListener(this);
        this._books = new Vector(5, 3);
        Library library2 = this._library;
        synchronized (library2) {
            HelpBook[] helpBookArray = this._library.getVisibleBooks();
            if (helpBookArray == null) {
                Object var3_4 = null;
                return;
            }
            int n = 0;
            while (n < helpBookArray.length) {
                if (helpBookArray[n].containsToc()) {
                    this._books.addElement(helpBookArray[n]);
                }
                ++n;
            }
            return;
        }
    }

    public int getItemCount() {
        return this._books.size();
    }

    public Object getData(int n) {
        if (n < this._books.size()) {
            return ((HelpBook)this._books.elementAt(n)).getHhcTree();
        }
        return null;
    }

    public void setData(int n, Object object) {
    }

    public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener(oneDDataSourceListener);
    }

    public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._manager != null) {
            this._manager.removeListener(oneDDataSourceListener);
        }
    }

    public void libraryChanged(LibraryEvent libraryEvent) {
        OneDDataSourceEvent oneDDataSourceEvent;
        if (!libraryEvent.getBook().containsToc()) {
            return;
        }
        if (libraryEvent.getID() == 2001) {
            if (libraryEvent.getIndex() >= this._books.size()) {
                this._books.addElement(libraryEvent.getBook());
                oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, this._books.size() - 1, 1);
            } else {
                this._books.insertElementAt(libraryEvent.getBook(), libraryEvent.getIndex());
                oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, libraryEvent.getIndex(), 1);
            }
        } else {
            int n = 0;
            while (n < this._books.size()) {
                if (this._books.elementAt(n) == libraryEvent.getBook()) break;
                ++n;
            }
            if (n == this._books.size()) {
                System.out.println("An Error occured in Help system");
                System.out.println("Please report this to Help group");
                Thread.dumpStack();
            }
            this._books.removeElementAt(n);
            oneDDataSourceEvent = new OneDDataSourceEvent(this, 2002, n, 1);
        }
        Enumeration enumeration = this._manager.getListeners();
        while (enumeration.hasMoreElements()) {
            OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
            if (libraryEvent.getID() == 2001) {
                oneDDataSourceListener.itemsAdded(oneDDataSourceEvent);
                continue;
            }
            oneDDataSourceListener.itemsRemoved(oneDDataSourceEvent);
        }
    }
}

