/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import java.util.Enumeration;
import java.util.Vector;
import oracle.help.util.TreeRoot;

public class TreeNode {
    private TreeRoot _root;
    private TreeNode _next;
    private TreeNode _parent;
    private String _label;
    private String _urlName;
    private Vector _children;
    private Object _clientData;

    public TreeNode() {
    }

    public TreeNode(String string) {
        this._label = new String(string);
    }

    public TreeNode(String string, String string2) {
        this._label = new String(string);
        this._urlName = new String(string2);
    }

    public void setLabel(String string) {
        this._label = new String(string);
    }

    public void setUrl(String string) {
        this._urlName = new String(string);
    }

    public boolean isBranch() {
        return this._children != null;
    }

    public void addChild(TreeNode treeNode) {
        if (this._children == null) {
            this._children = new Vector(10, 10);
        }
        this._children.addElement(treeNode);
        treeNode._parent = this;
        treeNode.setRoot(this._root);
        if (this._root != null) {
            this._root.hash(treeNode);
        }
    }

    public String getLabel() {
        return this._label;
    }

    public String getUrl() {
        return this._urlName;
    }

    public int numChildren() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public int getChildrenCount() {
        return this.numChildren();
    }

    public Enumeration children() {
        if (this._children == null) {
            return null;
        }
        return this._children.elements();
    }

    public TreeNode getChild(int n) {
        if (this._children == null) {
            return null;
        }
        return (TreeNode)this._children.elementAt(n);
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public TreeRoot getRoot() {
        return this._root;
    }

    public int hashCode() {
        if (this._urlName != null) {
            return this._urlName.hashCode();
        }
        return 0;
    }

    public void setClientData(Object object) {
        this._clientData = object;
    }

    public Object getClientData() {
        return this._clientData;
    }

    public void printTree() {
        System.out.println("Label = " + this._label + " Value = " + this._urlName);
        if (this._children != null) {
            System.out.println("{");
            int n = 0;
            while (n < this._children.size()) {
                ((TreeNode)this._children.elementAt(n)).printTree();
                ++n;
            }
            System.out.println("}");
        }
    }

    protected void setRoot(TreeRoot treeRoot) {
        this._root = treeRoot;
    }

    protected void setNext(TreeNode treeNode) {
        this._next = treeNode;
    }

    protected TreeNode getNext() {
        return this._next;
    }

    private void _setParent(TreeNode treeNode) {
        this._parent = treeNode;
    }
}

