/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEAttributes;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEEthernets;
import COM.livingston.model.LELines;
import COM.livingston.model.LEModems;
import COM.livingston.model.LEPorts;
import COM.livingston.util.LEVector;

public class LEBoard
extends LEConfig {
    public static final String ASSIGNED_ADDR = Integer.toString(164);
    public static final String ASSIGNED_POOL = Integer.toString(165);
    public static final String BACKPLANE_CLOCK = "473";
    public static final String BOARD_TYPE = Integer.toString(272);
    public static final String ETHERNETS = Integer.toString(720896);
    public static final String PRI_SWITCH = Integer.toString(172);
    public static final String LINE_CLOCK = "472";
    public static final String LINES = Integer.toString(131072);
    public static final String MODEMS = Integer.toString(196608);
    public static final String OS_VERSION = Integer.toString(276);
    public static final String PORTS = Integer.toString(262144);
    public static final String POWER = Integer.toString(279);
    public static final String SERIAL_NUMBER = Integer.toString(273);
    public static final String SLOT = Integer.toString(274);
    public static final String STATUS = "17";
    public static final int KEY_COUNT = 14;
    public static final String ETHERNET = "Ethernet";
    public static final String DUAL_ETHER = "Dual Ethernet";
    public static final String PRESENT = "Present";
    public static final String QUAD_T1 = "Quad T1";
    public static final String TRI_E1 = "Tri E1";
    public static final String SYSTEM_MANAGER = "System Manager";
    public static final String T3_MUX = "T3 Mux";
    public static final String E3_MUX = "E3 Mux";
    public static final String UNKNOWN = "Unknown";
    public static final String BOOTING = "booting";
    public static final String SYSTEM_MANAGER_ID = "4";
    public static final String ETHERNET_DAUGHTER_ID = "10";
    public static final String SET_MGR_VIEW = "set view 4";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;
    LEDataSpec m_powerSpec;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[14];
            int n = 0;
            LEBoard.s_keys[n++] = ASSIGNED_ADDR;
            LEBoard.s_keys[n++] = ASSIGNED_POOL;
            LEBoard.s_keys[n++] = BACKPLANE_CLOCK;
            LEBoard.s_keys[n++] = BOARD_TYPE;
            LEBoard.s_keys[n++] = ETHERNETS;
            LEBoard.s_keys[n++] = PRI_SWITCH;
            LEBoard.s_keys[n++] = LINE_CLOCK;
            LEBoard.s_keys[n++] = LINES;
            LEBoard.s_keys[n++] = MODEMS;
            LEBoard.s_keys[n++] = OS_VERSION;
            LEBoard.s_keys[n++] = PORTS;
            LEBoard.s_keys[n++] = POWER;
            LEBoard.s_keys[n++] = SERIAL_NUMBER;
            LEBoard.s_keys[n++] = SLOT;
        }
        return s_keys;
    }

    public LEBoard(LEConfigFacility lEConfigFacility, String string) {
        super(lEConfigFacility);
        this.m_name = string;
        this.m_board = string;
    }

    public Object clone() {
        LEBoard lEBoard = new LEBoard(this.m_facility, this.m_name);
        lEBoard.copy(this);
        return lEBoard;
    }

    public LEDataSpec getSpecFor(String string) {
        LEDataSpec lEDataSpec = super.getSpecFor(string);
        if (lEDataSpec != null && string.equals(POWER) && (this.m_board.equals(SYSTEM_MANAGER_ID) || this.m_board.equals(ETHERNET_DAUGHTER_ID))) {
            if (this.m_powerSpec == null) {
                this.m_powerSpec = (LEDataSpec)lEDataSpec.clone();
                this.m_powerSpec.addAttribute(LEAttributes.READONLY, "");
            }
            lEDataSpec = this.m_powerSpec;
        }
        return lEDataSpec;
    }

    public String getType() {
        String string = (String)this.get(BOARD_TYPE);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getStatus() {
        String string = this.getType();
        String string2 = (String)this.get(POWER);
        if (string2 == null) {
            return "";
        }
        if (string.equals(PRESENT) && string2.equals("on")) {
            return BOOTING;
        }
        return string2;
    }

    public boolean isPoweredUp() {
        String string = (String)this.get(BOARD_TYPE);
        String string2 = (String)this.get(POWER);
        return string != null && !string.equals(PRESENT) && string2 != null && string2.equals("on");
    }

    public boolean isPoweringUp() {
        String string = (String)this.get(BOARD_TYPE);
        String string2 = (String)this.get(POWER);
        return string != null && string.equals(PRESENT) && string2 != null && string2.equals("on");
    }

    boolean makeViewCommand(LEVector lEVector) {
        String string = this.getViewCommand();
        String string2 = (String)this.get(POWER);
        if (string != null && string2.equals("on")) {
            lEVector.addElement(string);
            return true;
        }
        return false;
    }

    LEConfig createConfig(String string) {
        if (string.equals(PORTS)) {
            return new LEPorts(this.m_facility, this.m_name, PORTS);
        }
        if (string.equals(LINES)) {
            return new LELines(this.m_facility, this.m_name, LINES);
        }
        if (string.equals(ETHERNETS)) {
            return new LEEthernets(this.m_facility, this.m_name, ETHERNETS);
        }
        if (string.equals(MODEMS)) {
            return new LEModems(this.m_facility, this.m_name, MODEMS);
        }
        return new LEConfig(this.m_facility);
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        CharSequence charSequence;
        String string;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if ((bl || lEVector.contains(POWER)) && this.makePowerCommand(lEVector2, string = (String)this.get(SLOT), (String)(charSequence = (String)this.get(POWER)))) {
            this.makeViewCommand(lEVector2);
        }
        if (bl || lEVector.contains(ASSIGNED_ADDR)) {
            this.makeSetCommand(lEVector2, null, ASSIGNED_ADDR, "assigned_address");
        }
        if (bl || lEVector.contains(ASSIGNED_POOL)) {
            this.makeSetCommand(lEVector2, null, ASSIGNED_POOL, "pool");
        }
        if (bl || lEVector.contains(PRI_SWITCH)) {
            this.makeSetCommand(lEVector2, null, PRI_SWITCH, "isdn-switch");
        }
        if ((bl || lEVector.contains(BACKPLANE_CLOCK)) && (string = (String)this.get(BACKPLANE_CLOCK)) != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("set ");
            ((StringBuffer)charSequence).append("mux0 ");
            ((StringBuffer)charSequence).append("backplane-clock ");
            ((StringBuffer)charSequence).append(string);
            lEVector2.addElement(((StringBuffer)charSequence).toString());
        }
        if ((bl || lEVector.contains(LINE_CLOCK)) && (string = (String)this.get(LINE_CLOCK)) != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("set ");
            ((StringBuffer)charSequence).append("mux0 ");
            ((StringBuffer)charSequence).append("line-clock ");
            ((StringBuffer)charSequence).append(string);
            lEVector2.addElement(((StringBuffer)charSequence).toString());
        }
        return lEVector2.size() > n;
    }

    boolean makePowerCommand(LEVector lEVector, String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            if (n < 10 && n != 4) {
                lEVector.addElement(SET_MGR_VIEW);
                StringBuffer stringBuffer = new StringBuffer(14);
                stringBuffer.append("set ");
                stringBuffer.append("slot");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                lEVector.addElement(stringBuffer.toString());
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }
}

