/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LEEthernet
extends LEConfig {
    public static final String ADDRESS = "9";
    public static final String BROADCAST = "186";
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String HELLOINTERVAL = "243";
    public static final String INPUT_FILTER = "193";
    public static final String IP_STATUS = "191";
    public static final String IPX_FRAME = "190";
    public static final String IPX_NETWORK = "189";
    public static final String IPX_STATUS = "192";
    public static final String MAC_ADDRESS = "195";
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = "15";
    public static final String OSPF_STATUS = "246";
    public static final String OUTPUT_FILTER = "194";
    public static final String RIP_BROAD = "187";
    public static final String RIP_LISTEN = "188";
    public static final int KEY_COUNT = 27;
    public static final String HIGH = "high";
    public static final String LOW = "low";
    public static final String ETHERNET_802_2 = "ethernet_802.2";
    public static final String ETHERNET_802_2_II = "ethernet_802.2_ii";
    public static final String ETHERNET_802_3 = "ethernet_802.3";
    public static final String ETHERNET_II = "ethernet_ii";
    static String[] s_keys = null;
    String m_name;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[27];
            int n = 0;
            LEEthernet.s_keys[n++] = ADDRESS;
            LEEthernet.s_keys[n++] = BROADCAST;
            LEEthernet.s_keys[n++] = COST;
            LEEthernet.s_keys[n++] = DEADTIME;
            LEEthernet.s_keys[n++] = HELLOINTERVAL;
            LEEthernet.s_keys[n++] = INPUT_FILTER;
            LEEthernet.s_keys[n++] = IP_STATUS;
            LEEthernet.s_keys[n++] = IPX_FRAME;
            LEEthernet.s_keys[n++] = IPX_NETWORK;
            LEEthernet.s_keys[n++] = IPX_STATUS;
            LEEthernet.s_keys[n++] = MAC_ADDRESS;
            LEEthernet.s_keys[n++] = NAT_TCP_TIMEOUT;
            LEEthernet.s_keys[n++] = NAT_OTHER_TIMEOUT;
            LEEthernet.s_keys[n++] = NAT_FAIL_ACTION;
            LEEthernet.s_keys[n++] = NAT_IN_MAP;
            LEEthernet.s_keys[n++] = NAT_PROXY_IN_MAP;
            LEEthernet.s_keys[n++] = NAT_OUT_MAP;
            LEEthernet.s_keys[n++] = NAT_PROXY_OUT_MAP;
            LEEthernet.s_keys[n++] = NAT_LOG_FAILURE;
            LEEthernet.s_keys[n++] = NAT_LOG_SUCCESS;
            LEEthernet.s_keys[n++] = NAT_LOG_SYSLOG;
            LEEthernet.s_keys[n++] = NAT_LOG_CONSOLE;
            LEEthernet.s_keys[n++] = NETMASK;
            LEEthernet.s_keys[n++] = OSPF_STATUS;
            LEEthernet.s_keys[n++] = OUTPUT_FILTER;
            LEEthernet.s_keys[n++] = RIP_BROAD;
            LEEthernet.s_keys[n++] = RIP_LISTEN;
        }
        return s_keys;
    }

    public LEEthernet(LEConfigFacility lEConfigFacility, String string, String string2) {
        super(lEConfigFacility, string);
        this.m_name = string2;
    }

    public LEEthernet(LEConfigFacility lEConfigFacility, String string) {
        super(lEConfigFacility);
        this.m_name = string;
    }

    public Object clone() {
        LEEthernet lEEthernet = new LEEthernet(this.m_facility, this.m_board, this.m_name);
        lEEthernet.copy(this);
        return lEEthernet;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if (bl || lEVector.contains(ADDRESS)) {
            this.makeSetCommand(lEVector2, this.m_name, ADDRESS, "address");
        }
        if (bl || lEVector.contains(BROADCAST)) {
            this.makeSetCommand(lEVector2, this.m_name, BROADCAST, "broadcast");
        }
        if (bl || lEVector.contains(INPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, INPUT_FILTER, "ifilter");
        }
        if (bl || lEVector.contains(IP_STATUS)) {
            this.makeSetCommand(lEVector2, this.m_name, IP_STATUS, "ip");
        }
        if (bl || lEVector.contains(IPX_FRAME)) {
            this.makeSetCommand(lEVector2, this.m_name, IPX_FRAME, "ipxframe");
        }
        if (bl || lEVector.contains(IPX_NETWORK)) {
            this.makeSetCommand(lEVector2, this.m_name, IPX_NETWORK, "ipxnet");
        }
        if (bl || lEVector.contains(IPX_STATUS)) {
            this.makeSetCommand(lEVector2, this.m_name, IPX_STATUS, "ipx");
        }
        if (bl || lEVector.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(lEVector2, this.m_name, NAT_FAIL_ACTION);
        }
        if (bl || lEVector.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_IN_MAP, true, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_IN_MAP, true, true);
        }
        if (bl || lEVector.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_OUT_MAP, false, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_OUT_MAP, false, true);
        }
        if (bl || lEVector.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (bl || lEVector.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (bl || lEVector.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (bl || lEVector.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (bl || lEVector.contains(NETMASK)) {
            this.makeSetCommand(lEVector2, this.m_name, NETMASK, "netmask");
        }
        if (bl || lEVector.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, OUTPUT_FILTER, "ofilter");
        }
        if (bl || lEVector.contains(RIP_BROAD) || lEVector.contains(RIP_LISTEN)) {
            this.makeRIPCommand(lEVector2, this.m_name, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        if ((bl || lEVector.contains(OSPF_STATUS)) && this.get(OSPF_STATUS) != null) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("set ");
            stringBuffer.append(" ");
            stringBuffer.append(this.m_name);
            stringBuffer.append(" ospf ");
            String string = (String)this.get(OSPF_STATUS);
            stringBuffer.append(string);
            if (string.equals("on")) {
                String string2;
                String string3;
                String string4 = (String)this.get(COST);
                if (string4 != null && string4.length() > 0) {
                    stringBuffer.append(" cost ");
                    stringBuffer.append(string4);
                }
                if ((string3 = (String)this.get(HELLOINTERVAL)) != null && string3.length() > 0) {
                    stringBuffer.append(" hello-interval ");
                    stringBuffer.append(string3);
                }
                if ((string2 = (String)this.get(DEADTIME)) != null && string2.length() > 0) {
                    stringBuffer.append(" dead-time ");
                    stringBuffer.append(string2);
                }
            }
            stringBuffer.append(" ");
            lEVector2.add(new String(stringBuffer));
        }
        return lEVector2.size() > n;
    }
}

