/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEFilterFileParser;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LELocationFileParser;
import COM.livingston.model.LELocations;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.io.IOException;

public class LEFileConfigFacility
implements LEConfigFacility {
    String m_path;
    LEConfig m_config;
    LEDSSFlatFile m_dssfile;
    int m_mode;

    public LEFileConfigFacility(LEConfig lEConfig, String string, String string2) {
        this.m_path = LEAppInfo.createFullPath(string, string2);
        this.m_config = lEConfig;
        this.m_dssfile = null;
        this.m_mode = -1;
    }

    public boolean getConfig(String string) {
        try {
            this.openFile(0);
            LEVector lEVector = this.m_dssfile.getCommands();
            if (string.equals("filter")) {
                LEFilterFileParser lEFilterFileParser = new LEFilterFileParser();
                lEFilterFileParser.readFilters(lEVector);
                LEFilters lEFilters = lEFilterFileParser.getFilters();
                this.m_config.set(string, lEFilters);
            } else if (string.equals("1703936")) {
                LELocationFileParser lELocationFileParser = new LELocationFileParser();
                lELocationFileParser.createPatterns();
                lELocationFileParser.readLocations(lEVector);
                LELocations lELocations = lELocationFileParser.getLocations();
                this.m_config.set(string, lELocations);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return true;
    }

    public boolean getConfig(String string, String string2) {
        return this.getConfig(string);
    }

    public String getDescription() {
        return this.m_path;
    }

    public LEPMCommand execute(String string) {
        LEVector lEVector = new LEVector(1);
        lEVector.add(string);
        LEPMCommand lEPMCommand = new LEPMCommand(string);
        try {
            this.openFile(1);
            this.m_dssfile.writeConfig(lEVector);
            lEPMCommand.setStatus(true);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            lEPMCommand.setResult("No connection");
            lEPMCommand.setStatus(false);
        }
        lEVector = null;
        return lEPMCommand;
    }

    public void close() throws IOException {
        if (this.m_dssfile != null) {
            this.m_dssfile.disconnect();
        }
        this.m_dssfile = null;
    }

    protected void openFile(int n) throws IOException {
        if (this.m_dssfile != null) {
            if (this.m_mode == n) {
                return;
            }
            this.m_dssfile.disconnect();
            this.m_dssfile = null;
        }
        this.m_mode = n;
        this.m_dssfile = new LEDSSFlatFile(this.m_path, this.m_mode);
        this.m_dssfile.connect();
    }
}

