/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEOSPFArea;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEOSPFAreas
extends LETable {
    public LEOSPFAreas(LEConfigFacility lEConfigFacility) {
        super(lEConfigFacility);
    }

    public Object clone() {
        LEOSPFAreas lEOSPFAreas = new LEOSPFAreas(this.m_facility);
        lEOSPFAreas.copy(this);
        return lEOSPFAreas;
    }

    public LEVector add(String string) {
        LEVector lEVector = null;
        String string2 = this.makeAddCommand("ospf area", string);
        LEPMCommand lEPMCommand = this.m_facility.execute(string2);
        if (lEPMCommand.getStatus()) {
            lEPMCommand = this.m_facility.execute("save all");
            this.refresh();
        }
        if (!lEPMCommand.getStatus()) {
            lEVector = new LEVector();
            lEVector.addElement(lEPMCommand);
        }
        return lEVector;
    }

    public LEVector delete(String string) {
        LEVector lEVector = null;
        String string2 = this.makeDeleteCommand("ospf area", string);
        LEPMCommand lEPMCommand = this.m_facility.execute(string2);
        if (lEPMCommand.getStatus()) {
            this.remove(string);
            lEPMCommand = this.m_facility.execute("save all");
            if (!lEPMCommand.getStatus()) {
                this.refresh();
            }
        }
        if (!lEPMCommand.getStatus()) {
            lEVector = new LEVector();
            lEVector.addElement(lEPMCommand);
        }
        return lEVector;
    }

    LEConfig createConfig(String string) {
        return new LEOSPFArea(this.m_facility, string);
    }

    boolean generateAddCommand(String string, LEVector lEVector) {
        lEVector.addElement(this.makeAddCommand("ospf area", string));
        return true;
    }

    boolean generateDeleteCommand(String string, LEVector lEVector) {
        lEVector.addElement(this.makeDeleteCommand("ospf area", string));
        return true;
    }

    boolean getChangedCommands(LEVector lEVector) {
        int n = lEVector.size();
        boolean bl = super.getChangedCommands(lEVector);
        if (bl) {
            this.checkCommands(lEVector, n);
        }
        return bl;
    }

    boolean getAllCommands(LEVector lEVector) {
        int n = lEVector.size();
        boolean bl = super.getAllCommands(lEVector);
        if (bl) {
            this.checkCommands(lEVector, n);
        }
        return bl;
    }

    void checkCommands(LEVector lEVector, int n) {
        int n2 = lEVector.size();
        int n3 = -1;
        int n4 = -1;
        int n5 = n;
        while (n5 < n2) {
            String string = (String)lEVector.elementAt(n5);
            if (string.equals("reset ospf")) {
                if (n3 > 0) {
                    lEVector.removeElementAt(n3);
                    --n2;
                    --n4;
                }
                n3 = --n5;
            } else if (string.equals("save all")) {
                n4 = n5;
            }
            ++n5;
        }
    }
}

