/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LESNMPHosts;
import COM.livingston.util.LEVector;

public class LESNMP
extends LEConfig {
    public static final String READ_COMMUNITY = "read";
    public static final String READ_HOSTS = "readhost";
    public static final String READ_TYPE = "readtype";
    public static final String SYSNAME = "sysname";
    public static final String WRITE_COMMUNITY = "write";
    public static final String WRITE_HOSTS = "writehost";
    public static final String WRITE_TYPE = "writetype";
    public static final int KEY_COUNT = 7;
    public static final String READER_TAG = "reader";
    public static final String SNMP_TAG = "snmp";
    public static final String SNMPHOST_TAG = "snmphost";
    public static final String WRITER_TAG = "writer";
    public static final String ANY = "any";
    public static final String NONE = "none";
    public static final String SPECIFIED = "specified";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[7];
            int n = 0;
            LESNMP.s_keys[n++] = READ_COMMUNITY;
            LESNMP.s_keys[n++] = READ_HOSTS;
            LESNMP.s_keys[n++] = READ_TYPE;
            LESNMP.s_keys[n++] = SYSNAME;
            LESNMP.s_keys[n++] = WRITE_COMMUNITY;
            LESNMP.s_keys[n++] = WRITE_HOSTS;
            LESNMP.s_keys[n++] = WRITE_TYPE;
        }
        return s_keys;
    }

    public LESNMP(LEConfigFacility lEConfigFacility) {
        super(lEConfigFacility);
    }

    public Object clone() {
        LESNMP lESNMP = new LESNMP(this.m_facility);
        lESNMP.copy(this);
        return lESNMP;
    }

    LEConfig createConfig(String string) {
        if (string.equals(READ_HOSTS)) {
            return new LESNMPHosts(this.m_facility, READER_TAG);
        }
        if (string.equals(WRITE_HOSTS)) {
            return new LESNMPHosts(this.m_facility, WRITER_TAG);
        }
        return new LEConfig(this.m_facility);
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if (bl || lEVector.contains(SYSNAME)) {
            this.makeSetCommand(lEVector2, null, SYSNAME, SYSNAME);
        }
        if (bl || lEVector.contains(READ_COMMUNITY)) {
            this.makeSetCommand(lEVector2, SNMP_TAG, READ_COMMUNITY, "readcommunity");
        }
        if (bl || lEVector.contains(WRITE_COMMUNITY)) {
            this.makeSetCommand(lEVector2, SNMP_TAG, WRITE_COMMUNITY, "writecommunity");
        }
        if (bl || lEVector.contains(READ_TYPE)) {
            this.setSNMPHostType(READ_HOSTS, READ_TYPE);
        }
        if (bl || lEVector.contains(WRITE_TYPE)) {
            this.setSNMPHostType(WRITE_HOSTS, WRITE_TYPE);
        }
        return lEVector2.size() > n;
    }

    void setSNMPHostType(String string, String string2) {
        Object object = this.get(string);
        if (object instanceof LESNMPHosts) {
            LESNMPHosts lESNMPHosts = (LESNMPHosts)object;
            String string3 = (String)this.get(string2);
            if (string3 != null) {
                if (string3.equals(ANY)) {
                    lESNMPHosts.setType(0);
                    return;
                }
                if (string3.equals(NONE)) {
                    lESNMPHosts.setType(1);
                    return;
                }
                lESNMPHosts.setType(2);
            }
        }
    }
}

