/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ppp;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDebugFactory;
import COM.livingston.backend.LEDebugMessage;
import COM.livingston.model.LEDebugFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ppp.LEPPPBACP;
import COM.livingston.ppp.LEPPPBAP;
import COM.livingston.ppp.LEPPPCCP;
import COM.livingston.ppp.LEPPPCHAP;
import COM.livingston.ppp.LEPPPDebugMessage;
import COM.livingston.ppp.LEPPPIPCP;
import COM.livingston.ppp.LEPPPIPXCP;
import COM.livingston.ppp.LEPPPLCP;
import COM.livingston.ppp.LEPPPPAP;
import COM.livingston.ppp.LESmartDebugFactory;
import COM.livingston.util.LEObserver;
import java.util.Hashtable;
import java.util.Vector;

public class LEPPPDebugFactory
extends LESmartDebugFactory {
    protected static Hashtable s_managers = new Hashtable();

    public LEPPPDebugFactory(String string) {
        LEDebugFactory.GetFactory().addObserver(string, this);
    }

    public static LEPPPDebugFactory addObserver(LEPortMaster lEPortMaster, LEObserver lEObserver) {
        String string = lEPortMaster.getHostname();
        LEPPPDebugFactory lEPPPDebugFactory = (LEPPPDebugFactory)s_managers.get(string);
        LESmartDebugFactory.s_pms.put(string, lEPortMaster);
        if (lEPPPDebugFactory == null) {
            lEPPPDebugFactory = new LEPPPDebugFactory(string);
            s_managers.put(string, lEPPPDebugFactory);
            lEPPPDebugFactory.addObserver(lEObserver);
            LEDebugFacility lEDebugFacility = lEPortMaster.getDebugFacility();
            if (lEDebugFacility != null) {
                LEPPPDebugFactory.setDebugFlags(lEDebugFacility);
            }
        } else {
            lEPPPDebugFactory.addObserver(lEObserver);
            LEDebugFacility lEDebugFacility = lEPortMaster.getDebugFacility();
            if (lEDebugFacility != null) {
                LEPPPDebugFactory.setDebugFlags(lEDebugFacility);
            }
        }
        return lEPPPDebugFactory;
    }

    public static String addObserver(String string, String string2, String string3, LEObserver lEObserver) {
        LEPPPDebugFactory lEPPPDebugFactory;
        boolean bl = false;
        if (string2 == null) {
            bl = true;
        }
        if ((lEPPPDebugFactory = (LEPPPDebugFactory)s_managers.get(string)) == null) {
            lEPPPDebugFactory = new LEPPPDebugFactory(string);
            s_managers.put(string, lEPPPDebugFactory);
            lEPPPDebugFactory.addObserver(lEObserver);
            if (!bl) {
                return lEPPPDebugFactory.startDebugging(string, string2, string3);
            }
            return "Reading " + string + "\n";
        }
        lEPPPDebugFactory.addObserver(lEObserver);
        if (!bl) {
            return lEPPPDebugFactory.startDebugging(string, string2, string3);
        }
        return "Reading " + string + "\n";
    }

    protected boolean setDebugFlagsForFactories(LEDebugFacility lEDebugFacility) {
        return LEPPPDebugFactory.setDebugFlags(lEDebugFacility);
    }

    public static boolean setDebugFlags(LEDebugFacility lEDebugFacility) {
        return lEDebugFacility.startDebug(393216, 81, -1);
    }

    public static void deleteObserver(String string, LEObserver lEObserver) {
        if (lEObserver == null || string == null) {
            return;
        }
        LEPPPDebugFactory lEPPPDebugFactory = (LEPPPDebugFactory)s_managers.get(string);
        if (lEPPPDebugFactory != null) {
            lEPPPDebugFactory.deleteObserver(lEObserver);
            if (lEPPPDebugFactory.countObservers() == 0) {
                lEPPPDebugFactory.stopDebugging(string);
            }
        }
    }

    private void stopDebugging(String string) {
        LEDebugFacility lEDebugFacility;
        LEPortMaster lEPortMaster = (LEPortMaster)LESmartDebugFactory.s_pms.get(string);
        if (lEPortMaster != null && (lEDebugFacility = lEPortMaster.getDebugFacility()) != null) {
            lEDebugFacility.stopDebug(393216, 81, -1);
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        String string2;
        if (object instanceof LEDebugMessage && (string2 = this.determineType(((LEDebugMessage)object).getData())).equals("PPP")) {
            Vector vector = this.processLEDebugMessage((LEDebugMessage)object);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                LEPPPDebugMessage lEPPPDebugMessage = new LEPPPDebugMessage((LEDebugMessage)vector.elementAt(n2));
                if (!lEPPPDebugMessage.getType().equals("MISC")) {
                    LEPPPDebugMessage lEPPPDebugMessage2 = this.processPPPDebugMessage(lEPPPDebugMessage);
                    this.notifyObservers(lEPPPDebugMessage2);
                } else {
                    this.notifyObservers(lEPPPDebugMessage);
                }
                ++n2;
            }
        }
    }

    public LEPPPDebugMessage processPPPDebugMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getType();
        if (string.equals("Connection Succeeded") || string.equals("Connection Failed")) {
            return lEPPPDebugMessage;
        }
        if (string.equals("LCP")) {
            return LEPPPLCP.TranslateMessage(lEPPPDebugMessage);
        }
        if (string.equals("PAP")) {
            return LEPPPPAP.TranslateMessage(lEPPPDebugMessage);
        }
        if (string.equals("CHAP")) {
            return LEPPPCHAP.TranslateMessage(lEPPPDebugMessage);
        }
        if (string.equals("IPCP")) {
            return LEPPPIPCP.TranslateMessage(lEPPPDebugMessage);
        }
        if (string.equals("CCP")) {
            return LEPPPCCP.TranslateMessage(lEPPPDebugMessage);
        }
        if (string.equals("IPXCP")) {
            return LEPPPIPXCP.TranslateMessage(lEPPPDebugMessage);
        }
        if (string.equals("BACP")) {
            return LEPPPBACP.TranslateMessage(lEPPPDebugMessage);
        }
        if (string.equals("BAP")) {
            return LEPPPBAP.TranslateMessage(lEPPPDebugMessage);
        }
        return lEPPPDebugMessage;
    }

    public String determineType(String string) {
        if (string.indexOf("LCP") != -1) {
            return "PPP";
        }
        if (string.indexOf("CHAP") != -1) {
            return "PPP";
        }
        if (string.indexOf("IPCP") != -1) {
            return "PPP";
        }
        if (string.indexOf("IPXCP") != -1) {
            return "PPP";
        }
        if (string.indexOf("CCP") != -1) {
            return "PPP";
        }
        if (string.indexOf("BAP") != -1) {
            return "PPP";
        }
        if (string.indexOf("BACP") != -1) {
            return "PPP";
        }
        if (string.indexOf("Connection") != -1) {
            return "PPP";
        }
        if (string.indexOf("PAP") != -1 && string.indexOf("Termination") == -1) {
            return "PPP";
        }
        return "MISC";
    }
}

