/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ppp;

import COM.livingston.backend.LEDebugMessage;
import COM.livingston.util.LEDebug;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;

public class LEPPPDebugMessage
extends LEDebugMessage {
    private String m_type;
    private String m_value;
    private String m_hexdata;
    private String m_portNumber;
    private String m_slotNumber;
    public static final String CONTAINING_STR = "containing";
    private static String s_prevPortNumber;
    private String m_direction;
    public static final String SLOT = "slot";
    public static final String START_PAP = "START_PAP";
    public static final String START_CHAP = "START_CHAP";
    public static final String START_LCP = "START_LCP";
    public static final String START_IPCP = "START_IPCP";
    public static final String START_IPXCP = "START_IPXCP";
    public static final String START_CCP = "START_CCP";
    public static final String MISC = "MISC";
    public static final String TYPE_LCP = "LCP";
    public static final String TYPE_PAP = "PAP";
    public static final String TYPE_CHAP = "CHAP";
    public static final String TYPE_IPCP = "IPCP";
    public static final String TYPE_IPXCP = "IPXCP";
    public static final String TYPE_CCP = "CCP";
    public static final String TYPE_BACP = "BACP";
    public static final String TYPE_BAP = "BAP";
    public static final String TYPE_MISC = "MISC";
    public static final String BLANK = "";
    public static final int MAX_PROTOCOL = 208;
    public static final String CONNECTION_FAILED = "Connection Failed";
    public static final String CONNECTION_SUCCEEDED = "Connection Succeeded";
    public static final String DIR_RECV = "Received";
    public static final String DIR_SEND = "Sending";
    public static final String DIR_UNKNOWN = "";
    public static final String[] PROTOCOL_LIST;

    public LEPPPDebugMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
        this.determineAndSetType(string);
        this.setPortNum(this.m_value);
        this.setDirection(this.m_value);
        this.setSlot(string);
    }

    public LEPPPDebugMessage(LEDebugMessage lEDebugMessage) {
        super(lEDebugMessage.getRequestID(), lEDebugMessage.getTimestamp(), lEDebugMessage.getData(), lEDebugMessage.getHost());
        String string = lEDebugMessage.getData();
        this.determineAndSetType(string);
        this.setPortNum(this.m_value);
        this.setDirection(this.m_value);
        this.setSlot(string);
    }

    void setDirection(String string) {
        if (string.indexOf(DIR_RECV) != -1) {
            this.m_direction = DIR_RECV;
            return;
        }
        if (string.indexOf(DIR_SEND) != -1) {
            this.m_direction = DIR_SEND;
            return;
        }
        this.m_direction = "";
    }

    public String getDirection() {
        return this.m_direction;
    }

    void setType(String string) {
        this.m_type = string;
    }

    public String getType() {
        return this.m_type;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getPortNum() {
        return this.m_portNumber;
    }

    public String getSlotNum() {
        return this.m_slotNumber;
    }

    void setValue(String string) {
        this.m_value = string;
    }

    public boolean setHexData(String string) {
        if (this.m_type != null) {
            this.m_hexdata = string;
            return true;
        }
        return false;
    }

    public String getHexData() {
        return this.m_hexdata;
    }

    public String getTranslatedString() {
        return this.toString();
    }

    public String toString() {
        return this.getData();
    }

    void setPortNum(String string) {
        this.m_portNumber = s_prevPortNumber;
        int n = string.indexOf("port");
        try {
            if (n == -1) {
                if (string.charAt(0) == 'S' || string.charAt(0) == 'W' || string.charAt(0) == 'C') {
                    this.m_portNumber = string.charAt(2) == ':' ? string.substring(0, 2) : (string.charAt(3) == ':' ? string.substring(0, 3) : s_prevPortNumber);
                }
            } else {
                String string2 = string.substring(n + 5);
                this.m_portNumber = string2.charAt(2) == ' ' ? string2.substring(0, 2) : string2.substring(0, 3);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, string);
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_portNumber = new String("-1");
            LEDebug.getLog().logln(20, numberFormatException);
        }
        s_prevPortNumber = this.m_portNumber;
    }

    void determineAndSetType(String string) {
        CharSequence charSequence;
        Object object;
        Object object2;
        block25: {
            int n;
            int n2 = string.indexOf(":");
            if (n2 == -1 && string.indexOf(CONTAINING_STR) != -1) {
                n2 = string.indexOf(CONTAINING_STR) + CONTAINING_STR.length() - 1;
            }
            if ((n = string.indexOf(SLOT)) != -1) {
                string = string.substring(n2 + 2);
                n2 = string.indexOf(":");
            }
            if (n2 != -1) {
                object2 = new StreamTokenizer(new StringReader(string.substring(n2 + 1)));
                try {
                    if (((StreamTokenizer)object2).nextToken() == -2) {
                        this.m_value = string.substring(0, n2);
                        this.m_hexdata = string.substring(n2 + 2);
                        break block25;
                    }
                    int n3 = string.indexOf("wire bytes");
                    if (n3 == -1) {
                        n3 = string.indexOf("wire  bytes");
                    }
                    if (n3 != -1) {
                        this.m_value = string.substring(0, n3 + 11);
                        object = new StringTokenizer(string.substring(n3 + 11));
                        ((StringTokenizer)object).nextToken();
                        charSequence = new StringBuffer(20);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            ((StringBuffer)charSequence).append(((StringTokenizer)object).nextToken());
                            ((StringBuffer)charSequence).append(" ");
                        }
                        this.m_hexdata = ((StringBuffer)charSequence).toString();
                        this.m_hexdata.trim();
                        break block25;
                    }
                    this.m_value = string;
                    this.m_hexdata = null;
                }
                catch (IOException iOException) {
                    LEDebug.getLog().logln(20, iOException);
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                }
            } else {
                this.m_value = string;
            }
        }
        object2 = new StringTokenizer(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        object = null;
        if (string.indexOf("Open") != -1 && string.indexOf(CONNECTION_SUCCEEDED) == -1 && string.indexOf(CONNECTION_FAILED) == -1) {
            while (((StringTokenizer)object2).hasMoreTokens()) {
                charSequence = ((StringTokenizer)object2).nextToken();
                if (((String)charSequence).equals("Open")) break;
                object = stringTokenizer.nextToken();
            }
        }
        if (object != null) {
            string = object;
        }
        if (string.indexOf(CONNECTION_SUCCEEDED) != -1) {
            this.m_type = CONNECTION_SUCCEEDED;
            return;
        }
        if (string.indexOf(CONNECTION_FAILED) != -1) {
            this.m_type = CONNECTION_FAILED;
            return;
        }
        if (string.indexOf(TYPE_LCP) != -1) {
            this.m_type = TYPE_LCP;
            return;
        }
        if (string.indexOf(TYPE_PAP) != -1) {
            this.m_type = TYPE_PAP;
            return;
        }
        if (string.indexOf(TYPE_CHAP) != -1) {
            this.m_type = TYPE_CHAP;
            return;
        }
        if (string.indexOf(TYPE_IPCP) != -1) {
            this.m_type = TYPE_IPCP;
            return;
        }
        if (string.indexOf(TYPE_IPXCP) != -1) {
            this.m_type = TYPE_IPXCP;
            return;
        }
        if (string.indexOf(TYPE_CCP) != -1) {
            this.m_type = TYPE_CCP;
            return;
        }
        if (string.indexOf(TYPE_PAP) != -1) {
            this.m_type = TYPE_PAP;
            return;
        }
        if (string.indexOf(TYPE_BACP) != -1) {
            this.m_type = TYPE_BACP;
            return;
        }
        if (string.indexOf(TYPE_BAP) != -1) {
            this.m_type = TYPE_BAP;
            return;
        }
        this.m_type = "MISC";
    }

    void setSlot(String string) {
        int n = string.indexOf(SLOT);
        if (n != -1) {
            int n2 = string.indexOf(":");
            this.m_slotNumber = string.substring(n, n2);
            return;
        }
        this.m_slotNumber = null;
    }

    static {
        PROTOCOL_LIST = new String[]{"0001", "Padding Protocol", "0021", "Internet Protocol version 4", "0023", "OSI Network Layer", "0025", "Xerox NS IDP", "0027", "DECnet Phase IV", "0029", "Appletalk", "002B", "Novell IPX", "002D", "Van Jacobson Compressed TCP/IP", "002F", "Van Jacobson Uncompressed TCP/IP", "0031", "Bridging PDU", "0033", "Stream Protocol (ST-II)", "0035", "Banyan Vines", "0037", "reserved (until 1993)", "0039", "AppleTalk EDDP", "003B", "AppleTalk SmartBuffered", "003D", "Multi-Link", "003F", "NETBIOS Framing", "0041", "Cisco Systems", "0043", "Ascom Timeplex", "0045", "Fujitsu Link Backup and Load Balancing (LBLB)", "0047", "DCA Remote Lan", "0049", "Serial Data Transport Protocol (PPP-SDTP)", "004B", "SNA over 802.2", "004D", "SNA", "004F", "IP6 Header Compression", "0051", "KNX Bridging Data", "0053", "Encryption", "0055", "Individual Link Encryption", "0057", "Internet Protocol version 6", "006F", "Stampede Bridging", "0071", "BAP Bandwidth Allocation Protocol", "0073", "MP+ Protocol", "007D", "reserved (Control Escape)", "007F", "reserved (compression inefficient)", "00C1", "NTCITS IPI", "00CF", "reserved (PPP NLPID)", "00FB", "single link compression in multilink", "00FD", "compressed datagram", "00FF", "reserved (compression inefficient)", "0201", "802.1d Hello Packets", "0203", "IBM Source Routing BPDU", "0205", "DEC LANBridge100 Spanning Tree", "0207", "Cisco Discovery Protocol", "0209", "Netcs Twin Routing", "0231", "Luxcom", "0233", "Sigma Network Systems", "0235", "Apple Client Server Protocol", "4001", "Cray Communications Control Protocol", "4003", "CDPD Mobile Network Registration Protocol", "4021", "Stacker LZS", "8021", "Internet Protocol Control Protocol", "8023", "OSI Network Layer Control Protocol", "8025", "Xerox NS IDP Control Protocol", "8027", "DECnet Phase IV Control Protocol", "8029", "Appletalk Control Protocol", "802B", "Novell IPX Control Protocol", "802D", "reserved", "802F", "reserved", "8031", "Bridging NCP", "8033", "Stream Protocol Control Protocol", "8035", "Banyan Vines Control Protocol", "8037", "reserved till 1993", "8039", "reserved", "803B", "reserved", "803D", "Multi-Link Control Protocol", "803F", "NETBIOS Framing Control Protocol", "8041", "Cisco Systems Control Protocol", "8043", "Ascom Timeplex", "8045", "Fujitsu LBLB Control Protocol", "8047", "DCA Remote Lan Network Control Protocol (RLNCP)", "8049", "Serial Data Control Protocol (PPP-SDCP)", "804B", "SNA over 802.2 Control Protocol", "804D", "SNA Control Protocol", "804F", "IP6 Header Compression Control Protocol", "8051", "KNX Bridging Control Protocol", "8053", "Encryption Control Protocol", "8055", "Individual Link Encryption Control Protocol", "8057", "IPv6 Control Protocol", "806F", "Stampede Bridging Control Protocol", "8073", "MP+ Control Protocol", "8071", "BACP Bandwidth Allocation Control Protocol", "807d", "Not Used - reserved", "80C1", "NTCITS IPI Control Protocol", "80CF", "Not Used - reserved", "80FB", "single link compression in multilink control", "80FD", "Compression Control Protocol", "80FF", "NotUsed - reserved", "8207", "Cisco Discovery Protocol Control", "8209", "Netcs Twin Routing", "8235", "Apple Client Server Protocol Control", "C021", "Link Control Protocol", "C023", "Password Authentication Protocol", "C025", "Link Quality Report", "C027", "Shiva Password Authentication Protocol", "C029", "CallBack Control Protocol (CBCP)", "C081", "Container Control Protocol", "C223", "Challenge Handshake Authentication Protocol", "C225", "RSA Authentication Protocol", "C227", "Extensible Authentication Protocol", "C229", "Mitsubishi Security Info Exch Ptcl (SIEP)", "C26F", "Stampede Bridging Authorization Protocol", "C281", "Proprietary Authentication Protocol", "C283", "Proprietary Authentication Protocol", "C481", "Proprietary Node ID Authentication Protocol"};
    }
}

