/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ppp;

import COM.livingston.ppp.LEPPPDebugMessage;
import COM.livingston.ppp.LEPPPOptionList;
import COM.livingston.ppp.LEPPPUtil;

public class LEPPPIPXCPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private LEPPPOptionList m_ol;
    public static final String[] IPXCP_OPTIONS = new String[]{"01", "IPX-Network-Number", "02", "IPX-Node-Number", "03", "IPX-Compression-Protocol", "04", "IPX-Routing-Protocol", "05", "IPX-Router-Name", "06", "IPX-configuration-Complete"};

    public LEPPPIPXCPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPIPXCPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
    }

    public LEPPPIPXCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public LEPPPIPXCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, LEPPPOptionList lEPPPOptionList) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_ol = lEPPPOptionList;
    }

    void setOptionList(LEPPPOptionList lEPPPOptionList) {
        this.m_ol = lEPPPOptionList;
    }

    public String getTranslatedString() {
        if (this.m_code == null) {
            return new String(this.getValue());
        }
        StringBuffer stringBuffer = new StringBuffer("\t[IPXCP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        if (this.m_ol != null) {
            this.m_ol.resetCurrent();
            while (this.m_ol.m_olCurrent != null) {
                int n = 0;
                while (n < IPXCP_OPTIONS.length) {
                    if (IPXCP_OPTIONS[n].equals(this.m_ol.getCurrentOption())) break;
                    n += 2;
                }
                if (n + 1 < IPXCP_OPTIONS.length) {
                    stringBuffer.append("\n\t ");
                    stringBuffer.append(IPXCP_OPTIONS[n + 1]);
                    stringBuffer.append("[0x");
                    stringBuffer.append(this.m_ol.getCurrentOption());
                    stringBuffer.append("], length: (");
                    stringBuffer.append(String.valueOf(this.m_ol.m_olCurrent.m_ilength));
                    stringBuffer.append(" bytes)");
                }
                if (!this.m_ol.m_olCurrent.m_data.equals("")) {
                    String string = new String(String.valueOf(this.m_ol.m_olCurrent.m_data.substring(0, 2)) + this.m_ol.m_olCurrent.m_data.substring(3, 5)).toUpperCase();
                    n = 0;
                    while (n < LEPPPDebugMessage.PROTOCOL_LIST.length) {
                        if (LEPPPDebugMessage.PROTOCOL_LIST[n].equals(string)) break;
                        n += 2;
                    }
                    if (n + 1 < LEPPPDebugMessage.PROTOCOL_LIST.length) {
                        stringBuffer.append(LEPPPDebugMessage.PROTOCOL_LIST[n + 1]);
                        stringBuffer.append("[0x");
                        stringBuffer.append(LEPPPUtil.outhex(this.m_ol.getCurrentData()));
                        stringBuffer.append("]");
                    }
                }
                stringBuffer.append("\n");
                this.m_ol.nextCurrentOption();
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

