/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ppp;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDebugMessage;
import COM.livingston.model.LEDebugFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class LESmartDebugFactory
extends LEObservable
implements LEAMObserver {
    public static final String TYPE_MISC = "MISC";
    public static final String TYPE_PPP = "PPP";
    public static final String TYPE_ISDN_D = new String("TYPE_ISDN_D");
    public static final String TYPE_MDP = new String("TYPE_MDP");
    public static final String SLOT_STRING = "slot";
    public static final String SPACE = " ";
    public static final String RECV_STRING = "Received";
    public static final String SEND_STRING = "Sending";
    protected static Hashtable s_pms = new Hashtable();

    protected Vector processLEDebugMessage(LEDebugMessage lEDebugMessage) {
        Vector<LEDebugMessage> vector = new Vector<LEDebugMessage>();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = lEDebugMessage.getData();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", false);
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(string2.length() - 1) == ' ') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuffer.append(string2);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals(SPACE)) {
                    if (!stringTokenizer.hasMoreTokens()) break;
                    string2 = stringTokenizer.nextToken();
                }
                if (string2.charAt(string2.length() - 1) == ' ') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                bl = false;
                if (string2.indexOf(SLOT_STRING) != -1) {
                    bl = true;
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                String string3 = null;
                if (stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                }
                if (bl && stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                }
                try {
                    Integer.parseInt(string3, 16);
                    stringBuffer.append(SPACE);
                    stringBuffer.append(string3);
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string4 = stringTokenizer2.nextToken();
                        Integer.parseInt(string4, 16);
                        stringBuffer.append(SPACE);
                        string4.trim();
                        stringBuffer.append(string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    vector.addElement(new LEDebugMessage(lEDebugMessage.getRequestID(), lEDebugMessage.getTimestamp(), stringBuffer.toString(), lEDebugMessage.getHost()));
                    string2.trim();
                    stringBuffer = new StringBuffer(string2);
                }
            }
            vector.addElement(new LEDebugMessage(lEDebugMessage.getRequestID(), lEDebugMessage.getTimestamp(), stringBuffer.toString(), lEDebugMessage.getHost()));
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return vector;
    }

    protected String startDebugging(String string, String string2, String string3) {
        try {
            LEPortMaster lEPortMaster = (LEPortMaster)s_pms.get(string);
            if (lEPortMaster == null) {
                lEPortMaster = new LEPortMaster(string, string2, string3);
            }
            if (!lEPortMaster.getDSS().supportsEntities()) {
                return new String("PPP Decoder needs COMOS 3.8 or greater\n");
            }
            s_pms.put(string, lEPortMaster);
            LEDebugFacility lEDebugFacility = lEPortMaster.getDebugFacility();
            if (lEDebugFacility != null) {
                this.setDebugFlagsForFactories(lEDebugFacility);
            }
            if (lEPortMaster.isConnected()) {
                return new String("Connected to " + string + " successfully\n");
            }
            return new String("Failed to connect to" + string + "\n");
        }
        catch (LEDSSException lEDSSException) {
            LEDebug.getLog().logln(20, lEDSSException);
            return new String("Failed to connect to" + string + "\n");
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
            return new String("Failed to connect to" + string + "\n");
        }
    }

    public void startDebugging(LEPortMaster lEPortMaster) {
        try {
            if (lEPortMaster != null) {
                String string = lEPortMaster.getHostname();
                if (lEPortMaster.getDSS().supportsEntities()) {
                    s_pms.put(string, lEPortMaster);
                    LEDebugFacility lEDebugFacility = lEPortMaster.getDebugFacility();
                    if (lEDebugFacility != null) {
                        this.setDebugFlagsForFactories(lEDebugFacility);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public static Hashtable getHashTableOfHostnameToLEPortMasters() {
        return s_pms;
    }

    protected abstract boolean setDebugFlagsForFactories(LEDebugFacility var1);

    public abstract void update(LEAMFactory var1, String var2, Object var3);

    protected abstract String determineType(String var1);
}

