/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.smartagent;

import COM.livingston.ppp.LEPPPDebugMessage;
import COM.livingston.ppp.LEPPPIPCPMessage;
import COM.livingston.ppp.LEPPPLCPMessage;
import COM.livingston.smartagent.LEAgentMessage;
import COM.livingston.smartagent.LEPPPState;
import COM.livingston.smartagent.LEPPPStateCHAPStart;
import COM.livingston.smartagent.LEPPPStateCHAPUserFailedToLogIn;
import COM.livingston.smartagent.LEPPPStateIPCPOpened;
import COM.livingston.smartagent.LEPPPStateIPCPStart;
import COM.livingston.smartagent.LEPPPStateLCPStarting;
import COM.livingston.smartagent.LEPPPStateMessageLevel;
import COM.livingston.smartagent.LEPPPStatePAPStart;
import COM.livingston.smartagent.LEPPPStatePAPUserFailedToLogIn;
import java.util.Vector;

public class LEPPPStateIPCPDestSetWrong
extends LEPPPState {
    public static final String MESSAGE = "Netuser Destination Set Incorrectly";
    public static final String DETAIL_MESSAGE = "If the netuser's destination is set to assigned, IPCP would complete properly";

    LEPPPStateIPCPDestSetWrong(Vector vector, Vector vector2, LEPPPState lEPPPState) {
        super(vector, vector2, lEPPPState);
        int n = LEPPPStateMessageLevel.IPCP_DEST_NEG;
        StringBuffer stringBuffer = new StringBuffer("Netuser:");
        String string = LEPPPStateIPCPStart.getUserName(vector);
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("??");
        }
        stringBuffer.append(" Destination Set Incorrectly");
        this.m_sam = new LEAgentMessage(n, stringBuffer.toString(), DETAIL_MESSAGE, vector, true);
    }

    String getRequestIP(Vector vector) {
        String string = null;
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            LEPPPIPCPMessage lEPPPIPCPMessage;
            Object e = vector.elementAt(n2);
            if (e instanceof LEPPPIPCPMessage && (lEPPPIPCPMessage = (LEPPPIPCPMessage)e).getDirection().equals("Sending")) {
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_REQUEST)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_NAK)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
            }
            --n2;
        }
        return string;
    }

    String getReceivedNakIP(Vector vector) {
        String string = null;
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            LEPPPIPCPMessage lEPPPIPCPMessage;
            Object e = vector.elementAt(n2);
            if (e instanceof LEPPPIPCPMessage && (lEPPPIPCPMessage = (LEPPPIPCPMessage)e).getDirection().equals("Received")) {
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_NAK)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_REQUEST)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
            }
            --n2;
        }
        return string;
    }

    LEPPPState processMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        if (!this.m_messages.contains(lEPPPDebugMessage) && !(lEPPPDebugMessage instanceof LEPPPIPCPMessage)) {
            this.m_messages.addElement(lEPPPDebugMessage);
        }
        LEPPPStateIPCPDestSetWrong lEPPPStateIPCPDestSetWrong = this;
        if (lEPPPDebugMessage instanceof LEPPPIPCPMessage) {
            LEPPPIPCPMessage lEPPPIPCPMessage = (LEPPPIPCPMessage)lEPPPDebugMessage;
            if (lEPPPIPCPMessage.getDirection().equals("Sending") && lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_ACK)) {
                return new LEPPPStateIPCPOpened(this.m_messages, this.m_prevstates, this);
            }
        } else if (lEPPPDebugMessage instanceof LEPPPLCPMessage) {
            LEPPPLCPMessage lEPPPLCPMessage = (LEPPPLCPMessage)lEPPPDebugMessage;
            if (lEPPPLCPMessage.getCode().equals(LEPPPLCPMessage.LCP_TERMINATE_ACK) || lEPPPLCPMessage.getCode().equals(LEPPPLCPMessage.LCP_TERMINATE_REQUEST)) {
                int n = this.m_prevstates.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    LEPPPState lEPPPState = (LEPPPState)this.m_prevstates.elementAt(n2);
                    if (lEPPPState instanceof LEPPPStateCHAPStart) {
                        return new LEPPPStateCHAPUserFailedToLogIn(this.m_messages, this.m_prevstates, this);
                    }
                    if (lEPPPState instanceof LEPPPStatePAPStart) {
                        return new LEPPPStatePAPUserFailedToLogIn(this.m_messages, this.m_prevstates, this);
                    }
                    --n2;
                }
            } else {
                return new LEPPPStateLCPStarting(this.m_messages, this.m_prevstates, this);
            }
        }
        return lEPPPStateIPCPDestSetWrong;
    }
}

