/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.smartagent;

import COM.livingston.ppp.LEPPPDebugMessage;
import COM.livingston.ppp.LEPPPIPCPMessage;
import COM.livingston.ppp.LEPPPLCPMessage;
import COM.livingston.smartagent.LEAgentMessage;
import COM.livingston.smartagent.LEPPPState;
import COM.livingston.smartagent.LEPPPStateCHAPStart;
import COM.livingston.smartagent.LEPPPStateCHAPUserFailedToLogIn;
import COM.livingston.smartagent.LEPPPStateIPCPOpened;
import COM.livingston.smartagent.LEPPPStateLCPStarting;
import COM.livingston.smartagent.LEPPPStateMessageLevel;
import COM.livingston.smartagent.LEPPPStatePAPStart;
import COM.livingston.smartagent.LEPPPStatePAPUserFailedToLogIn;
import java.util.Vector;

public class LEPPPStateIPCPLooping
extends LEPPPState {
    public static final String MESSAGE = "IPCP Looping";
    public static final String DETAIL_MESSAGE = "Both are peers are set to assign an IP address and can't negotiate an IP address.\nCheck the IP Address of both peers.";

    LEPPPStateIPCPLooping(Vector vector, Vector vector2, LEPPPState lEPPPState) {
        super(vector, vector2, lEPPPState);
        int n = LEPPPStateMessageLevel.IPCP_LOOPS;
        String string = this.getRequestIP(vector);
        String string2 = this.getReceivedNakIP(vector);
        StringBuffer stringBuffer = new StringBuffer(DETAIL_MESSAGE);
        stringBuffer.append("\nSent IP:" + string);
        stringBuffer.append(" Received IP from peer:" + string2);
        this.m_sam = new LEAgentMessage(n, MESSAGE, stringBuffer.toString(), vector, true);
    }

    String getRequestIP(Vector vector) {
        String string = null;
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            LEPPPIPCPMessage lEPPPIPCPMessage;
            Object e = vector.elementAt(n2);
            if (e instanceof LEPPPIPCPMessage && (lEPPPIPCPMessage = (LEPPPIPCPMessage)e).getDirection().equals("Sending")) {
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_REQUEST)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_NAK)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
            }
            --n2;
        }
        return string;
    }

    String getReceivedNakIP(Vector vector) {
        String string = null;
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            LEPPPIPCPMessage lEPPPIPCPMessage;
            Object e = vector.elementAt(n2);
            if (e instanceof LEPPPIPCPMessage && (lEPPPIPCPMessage = (LEPPPIPCPMessage)e).getDirection().equals("Received")) {
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_NAK)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
                if (lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_REQUEST)) {
                    string = lEPPPIPCPMessage.getIPAddress();
                    break;
                }
            }
            --n2;
        }
        return string;
    }

    LEPPPState processMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        if (!this.m_messages.contains(lEPPPDebugMessage) && !(lEPPPDebugMessage instanceof LEPPPIPCPMessage)) {
            this.m_messages.addElement(lEPPPDebugMessage);
        }
        LEPPPStateIPCPLooping lEPPPStateIPCPLooping = this;
        if (lEPPPDebugMessage instanceof LEPPPIPCPMessage) {
            LEPPPIPCPMessage lEPPPIPCPMessage = (LEPPPIPCPMessage)lEPPPDebugMessage;
            if (lEPPPIPCPMessage.getDirection().equals("Sending") && lEPPPIPCPMessage.getCode().equals(LEPPPIPCPMessage.CONF_ACK)) {
                return new LEPPPStateIPCPOpened(this.m_messages, this.m_prevstates, this);
            }
        } else if (lEPPPDebugMessage instanceof LEPPPLCPMessage) {
            LEPPPLCPMessage lEPPPLCPMessage = (LEPPPLCPMessage)lEPPPDebugMessage;
            if (lEPPPLCPMessage.getCode().equals(LEPPPLCPMessage.LCP_TERMINATE_ACK) || lEPPPLCPMessage.getCode().equals(LEPPPLCPMessage.LCP_TERMINATE_REQUEST)) {
                int n = this.m_prevstates.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    LEPPPState lEPPPState = (LEPPPState)this.m_prevstates.elementAt(n2);
                    if (lEPPPState instanceof LEPPPStateCHAPStart) {
                        return new LEPPPStateCHAPUserFailedToLogIn(this.m_messages, this.m_prevstates, this);
                    }
                    if (lEPPPState instanceof LEPPPStatePAPStart) {
                        return new LEPPPStatePAPUserFailedToLogIn(this.m_messages, this.m_prevstates, this);
                    }
                    --n2;
                }
            } else {
                return new LEPPPStateLCPStarting(this.m_messages, this.m_prevstates, this);
            }
        }
        return lEPPPStateIPCPLooping;
    }
}

