/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEPortMaster;
import COM.livingston.ppp.LEPPPDebugMessage;
import COM.livingston.smartagent.LEAgentMessage;
import COM.livingston.smartagent.LESourceInfo;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMLListener;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LESplitterPanel;
import COM.livingston.ui.LETitleBar;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEProperties;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LEMessageViewerPanel
extends Panel
implements ActionListener,
LEMLListener,
LEConfirmClient,
ItemListener {
    LEAgentMessageLevelSetDialog m_level_dialog;
    static LEBorderPanel s_pmlistpanel;
    LESAPMGrid m_pmml;
    static int m_pmListHeight;
    static int m_messageListHeight;
    static final String PROP_MESSAGE_LIST_HEIGHT = "message_list_height";
    Label m_fromlabeltext;
    Label m_receivedtext;
    TextArea m_msg;
    TextArea m_sugmsg;
    LESmartAgentMessagePPPDetailFrame m_pppdetailframe;
    File m_logfile;
    PrintWriter m_logprw;
    Checkbox m_logCheckbox;
    TextField m_fileNameTextField;
    Button m_browseButton;
    static LEBorderPanel m_msglistpanel;
    LEMultiList m_lst;
    public static final int MESSAGE_COLUMN_LOCATION = 4;
    public static final int DATE_RECV_COLUMN = 2;
    public static final int MAX_NUM_ROWS_DISPLAYED = 250;
    public static final String[] TITLE;
    static final String BLANK;
    Hashtable m_ht_hostnametovector;
    public static final int NUM_OF_MSGS_IN_VECTOR = 250;
    public static final int RECEIVED_ROW = 4;
    public static final String BROWSE = "browse";
    public static final String PPP_DETAIL = "pppdetail";
    public static final String DELETE_MESSAGE = "delete_message";
    public static final String DELETE_ALL_MESSAGES = "delete_all_messages";
    static final String PROP_PM_LIST_HEIGHT = "pm_list_height";
    public static final String MODEL_PM4 = "PM-4";
    public static final Font PANEL_DEF_FONT;
    public static final Font PANEL_DEF_BOLD_FONT;

    public LEMessageViewerPanel(Vector vector) {
        LEMessageViewerPanel.LoadProperties();
        this.m_ht_hostnametovector = new Hashtable();
        this.setLayout(new BorderLayout(0, 0));
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        Panel panel = this.layoutPortMasterConnectionPanel();
        lESplitterPanel.addComponent((Component)panel, m_pmListHeight);
        Panel panel2 = this.layoutListMessagePanel();
        lESplitterPanel.addComponent((Component)panel2, m_messageListHeight);
        Panel panel3 = this.layoutMessageDetailPanel();
        lESplitterPanel.addComponent((Component)panel3, 0);
        this.add((Component)this.layoutLoggingPanel(), "North");
        this.add((Component)lESplitterPanel, "Center");
        this.m_pmml.addListener(this);
        DetailMLListener detailMLListener = new DetailMLListener();
        this.m_lst.addListener(detailMLListener);
    }

    Panel layoutPortMasterConnectionPanel() {
        s_pmlistpanel = new LEBorderPanel();
        s_pmlistpanel.setLayout(new BorderLayout());
        s_pmlistpanel.setBorderType(3);
        this.m_pmml = new LESAPMGrid();
        this.m_pmml.setMinDisplayRows(2);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_pmml);
        s_pmlistpanel.add((Component)lEScrollPanel, "Center");
        return s_pmlistpanel;
    }

    Panel layoutListMessagePanel() {
        m_msglistpanel = new LEBorderPanel();
        m_msglistpanel.setLayout(new BorderLayout());
        m_msglistpanel.setBorderType(3);
        this.m_lst = new LEMultiList(1, 0, 4);
        this.m_lst.setMultipleSelect(false);
        this.m_lst.setTitles(0, TITLE);
        this.m_lst.setColumnWidth(0, 20);
        this.m_lst.setSortable(0, true);
        this.m_lst.setSortable(1, true);
        this.m_lst.setSortable(2, true);
        this.m_lst.setSortable(3, true);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_lst);
        m_msglistpanel.add("Center", lEScrollPanel);
        new LETitleBar();
        return m_msglistpanel;
    }

    Panel layoutMessageDetailPanel() {
        LEBorderPanel lEBorderPanel = new LEBorderPanel();
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.setBorderType(3);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Label label = new Label("FROM:");
        label.setFont(PANEL_DEF_BOLD_FONT);
        panel.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        this.m_fromlabeltext = new Label("");
        panel.add((Component)this.m_fromlabeltext, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        Label label2 = new Label("Received:");
        label2.setFont(PANEL_DEF_BOLD_FONT);
        panel.add((Component)label2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 2.0;
        this.m_receivedtext = new Label("");
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)this.m_receivedtext, gridBagConstraints);
        Label label3 = new Label("Message:");
        label3.setFont(PANEL_DEF_BOLD_FONT);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)label3, gridBagConstraints);
        this.m_msg = new TextArea("", 2, 80, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        panel.add((Component)this.m_msg, gridBagConstraints);
        Label label4 = new Label("Detail:");
        label4.setFont(PANEL_DEF_BOLD_FONT);
        gridBagConstraints.gridwidth = 0;
        panel.add((Component)label4, gridBagConstraints);
        lEBorderPanel.add((Component)panel, "North");
        Panel panel2 = new Panel(new BorderLayout());
        this.m_sugmsg = new TextArea("", 4, 80, 1);
        panel2.add((Component)this.m_sugmsg, "Center");
        lEBorderPanel.add((Component)panel2, "Center");
        return lEBorderPanel;
    }

    Panel layoutLoggingPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel(gridBagLayout);
        Insets insets = panel.getInsets();
        insets.left = 25;
        insets.right = 25;
        Panel panel2 = new Panel(new BorderLayout(5, 0));
        this.m_logCheckbox = new Checkbox(" Log File:");
        this.m_logCheckbox.addItemListener(this);
        panel2.add((Component)this.m_logCheckbox, "West");
        this.m_fileNameTextField = new TextField("");
        panel2.add((Component)this.m_fileNameTextField, "Center");
        this.m_browseButton = new Button("Browse");
        this.m_browseButton.setActionCommand(BROWSE);
        this.m_browseButton.addActionListener(this);
        panel2.add((Component)this.m_browseButton, "East");
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)panel2, gridBagConstraints);
        return panel;
    }

    LEMultiList getMessageList() {
        return this.m_lst;
    }

    public void addSmartAgentMessage(LEAgentMessage lEAgentMessage) {
        this.addSmartAgentMessageToMem(lEAgentMessage);
        String[] stringArray = this.m_pmml.getSelectedHostnames();
        Object object = lEAgentMessage.getContext();
        if (object instanceof LESourceInfo) {
            String string = ((LESourceInfo)object).getHostname();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].equals(string)) {
                    this.addSmartAgentMessageToMultiList(lEAgentMessage);
                }
                ++n2;
            }
        }
    }

    void addSmartAgentMessageToMultiList(LEAgentMessage lEAgentMessage) {
        try {
            int n = lEAgentMessage.getLevel();
            if (n <= 2) {
                String string = ((LESourceInfo)lEAgentMessage.getContext()).getHostPort();
                String string2 = lEAgentMessage.getMessage();
                String string3 = string2;
                int n2 = string3.length();
                if (n2 >= 50) {
                    string2 = String.valueOf(string2.substring(0, 50)) + "...";
                }
                Date date = new Date(lEAgentMessage.getTimeStamp());
                String string4 = date.toString();
                String string5 = lEAgentMessage.getCriticalFlag() ? new String("*") : new String(" ");
                Object[] objectArray = new Object[]{string5, string, string2, string4, lEAgentMessage};
                int n3 = this.m_lst.getNumRows();
                if (n3 >= 250) {
                    this.m_lst.deleteRow(0);
                    this.m_lst.addRow(objectArray);
                    this.m_lst.layoutGrid();
                } else {
                    this.m_lst.addRow(objectArray);
                    this.m_lst.layoutGrid();
                }
                this.logMessage(lEAgentMessage);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    void addSmartAgentMessageToMem(LEAgentMessage lEAgentMessage) {
        Vector<LEAgentMessage> vector = null;
        Object object = lEAgentMessage.getContext();
        if (object instanceof LESourceInfo) {
            String string = ((LESourceInfo)object).getHostname();
            if (this.m_ht_hostnametovector.containsKey(string)) {
                vector = (Vector)this.m_ht_hostnametovector.get(string);
            }
            if (vector == null) {
                vector = new Vector<LEAgentMessage>();
            }
            if (vector.size() > 250) {
                vector.removeElementAt(0);
            }
            vector.addElement(lEAgentMessage);
            this.m_ht_hostnametovector.put(string, vector);
        }
    }

    void removeSmartAgentMessagesFromMem(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LESourceInfo lESourceInfo;
            String string;
            Vector vector2;
            LEAgentMessage lEAgentMessage = (LEAgentMessage)enumeration.nextElement();
            Object object = lEAgentMessage.getContext();
            if (!(object instanceof LESourceInfo) || (vector2 = (Vector)this.m_ht_hostnametovector.get(string = (lESourceInfo = (LESourceInfo)object).getHostname())) == null) continue;
            vector2.removeElement(lEAgentMessage);
            this.m_ht_hostnametovector.put(string, vector2);
        }
    }

    public String[] getSelectedHosts() {
        return this.m_pmml.getSelectedHostnames();
    }

    void removeSelectedHosts() {
        this.m_pmml.removeSelectedHosts();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE_MESSAGE)) {
            this.deleteCurrentSelected();
            return;
        }
        if (string.equals(BROWSE)) {
            this.browseFile();
            return;
        }
        if (string.equals(PPP_DETAIL)) {
            int[] nArray = this.m_lst.getSelectedRows();
            int n = nArray[nArray.length - 1];
            this.updateFullDetailMessage(n);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_logCheckbox && this.m_logCheckbox.getState()) {
            this.confirmEchoFile();
        }
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        int n = lEMLEvent.getType();
        if (n == 1) {
            this.updateMessageList();
            return;
        }
        if (n == 6) {
            this.m_pmml.getSelectedModel();
        }
    }

    void deleteCurrentSelected() {
        Vector vector = this.getCurrentSelected();
        this.removeSmartAgentMessagesFromMem(vector);
        this.deleteCurrentSelectedFromDetail();
    }

    void deleteAllMessages() {
        Vector vector = this.getAllVisibleMessages();
        this.removeSmartAgentMessagesFromMem(vector);
        this.deleteAllMessagesFromDetail();
    }

    void addHostname(String string, LEPortMaster lEPortMaster) {
        this.m_pmml.addPortMaster(string, lEPortMaster);
        this.m_pmml.getNumRows();
    }

    void updateMessageList() {
        String[] stringArray = this.m_pmml.getSelectedHostnames();
        int n = stringArray.length;
        Vector vector = new Vector(50);
        int n2 = 0;
        while (n2 < n) {
            if (this.m_ht_hostnametovector.containsKey(stringArray[n2])) {
                Vector vector2 = (Vector)this.m_ht_hostnametovector.get(stringArray[n2]);
                int n3 = vector2.size();
                int n4 = 0;
                while (n4 < n3) {
                    vector.addElement(vector2.elementAt(n4));
                    ++n4;
                }
            }
            ++n2;
        }
        this.refreshAndUpdateMultiList(vector);
    }

    public void refreshAndUpdateMultiList(Vector vector) {
        this.m_lst.deleteAllRows();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addSmartAgentMessageToMultiList((LEAgentMessage)enumeration.nextElement());
        }
        this.m_lst.redraw();
        this.m_lst.layoutGrid();
    }

    public static void LoadProperties() {
        String string = LEProperties.GetProperty(PROP_PM_LIST_HEIGHT);
        if (string != null) {
            m_pmListHeight = Integer.parseInt(string);
        }
        if ((string = LEProperties.GetProperty(PROP_MESSAGE_LIST_HEIGHT)) != null) {
            m_messageListHeight = Integer.parseInt(string);
        }
    }

    public static void SaveProperties() {
        try {
            m_pmListHeight = LEMessageViewerPanel.s_pmlistpanel.getSize().height;
            LEProperties.SetProperty(PROP_PM_LIST_HEIGHT, Integer.toString(m_pmListHeight));
            m_messageListHeight = LEMessageViewerPanel.m_msglistpanel.getSize().height;
            LEProperties.SetProperty(PROP_MESSAGE_LIST_HEIGHT, Integer.toString(m_messageListHeight));
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public Vector getCurrentSelected() {
        Vector<LEAgentMessage> vector = new Vector<LEAgentMessage>(20);
        int[] nArray = this.m_lst.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = this.m_lst.getCellItem(nArray[n2], 4);
            if (object instanceof LEAgentMessage) {
                vector.addElement((LEAgentMessage)object);
            }
            ++n2;
        }
        return vector;
    }

    void deleteCurrentSelectedFromDetail() {
        int[] nArray = this.m_lst.getSelectedRows();
        if (nArray.length > 0) {
            this.m_lst.deleteRows(nArray);
            this.m_fromlabeltext.setText(BLANK);
            this.m_receivedtext.setText(BLANK);
            this.m_msg.setText(BLANK);
            this.m_sugmsg.setText(BLANK);
            this.m_lst.layoutGrid();
        }
    }

    void deleteAllMessagesFromDetail() {
        this.m_lst.deleteAllRows();
        this.m_fromlabeltext.setText(BLANK);
        this.m_receivedtext.setText(BLANK);
        this.m_msg.setText(BLANK);
        this.m_sugmsg.setText(BLANK);
        this.m_lst.layoutGrid();
    }

    Vector getAllVisibleMessages() {
        int n = this.m_lst.getNumRows();
        Vector<LEAgentMessage> vector = new Vector<LEAgentMessage>(20);
        int n2 = 0;
        while (n2 < n) {
            Object object = this.m_lst.getCellItem(n2, 4);
            if (object instanceof LEAgentMessage) {
                vector.addElement((LEAgentMessage)object);
            }
            ++n2;
        }
        return vector;
    }

    void updateDetailMessage(int n) {
        LEAgentMessage lEAgentMessage = (LEAgentMessage)this.m_lst.getCellItem(n, 4);
        LESourceInfo lESourceInfo = (LESourceInfo)lEAgentMessage.getContext();
        String string = lESourceInfo.getHostPort();
        this.m_fromlabeltext.setText(string);
        Date date = new Date(lEAgentMessage.getTimeStamp());
        String string2 = date.toString();
        this.m_receivedtext.setText(string2);
        String string3 = lEAgentMessage.getMessage();
        this.m_msg.setText(string3);
        String string4 = lEAgentMessage.getSuggestion();
        if (string4 == null && lEAgentMessage.getSourceObject() instanceof LEPPPDebugMessage && (string4 = ((LEPPPDebugMessage)lEAgentMessage.getSourceObject()).getTranslatedString()) == null) {
            string4 = new String("");
        }
        this.m_sugmsg.setText(string4);
    }

    void updateFullDetailMessage(int n) {
        this.m_pppdetailframe = new LESmartAgentMessagePPPDetailFrame();
        ((Component)this.m_pppdetailframe).setVisible(true);
        LEAgentMessage lEAgentMessage = (LEAgentMessage)this.m_lst.getCellItem(n, 4);
        this.m_pppdetailframe.displayAgentMessageDetails(lEAgentMessage);
    }

    void browseFile() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.getFrame(this), "Command Echo File", 1);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        ((Component)fileDialog).setVisible(true);
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            ((TextComponent)this.m_fileNameTextField).setText(string3);
            LEAppInfo.setLastDirectory(string);
            this.confirmEchoFile();
        }
    }

    void confirmEchoFile() {
        String string = this.m_fileNameTextField.getText();
        if (string.length() == 0) {
            this.m_logfile = null;
            this.m_logprw = null;
            return;
        }
        File file = new File(string);
        if (this.m_logfile == null || !file.getAbsolutePath().equals(this.m_logfile.getAbsolutePath())) {
            if (file.exists()) {
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.getFrame(this), (LEConfirmClient)this, String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?", stringArray, (Object)file);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            this.setEchoFile(file);
        }
    }

    void setEchoFile(File file) {
        this.m_logfile = file;
        ((TextComponent)this.m_fileNameTextField).setText(this.m_logfile.getAbsolutePath());
        if (this.m_logprw != null) {
            this.m_logprw.close();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.m_logfile);
            this.m_logprw = new PrintWriter((Writer)fileWriter, true);
            return;
        }
        catch (IOException iOException) {
            this.m_logfile = null;
            this.m_logprw = null;
            ((TextComponent)this.m_fileNameTextField).setText(null);
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.getFrame(this), iOException.getMessage());
            return;
        }
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.setEchoFile((File)object);
            return;
        }
        this.cancelAction(object);
    }

    public void cancelAction(Object object) {
        this.m_logfile = null;
        this.m_logprw = null;
        ((TextComponent)this.m_fileNameTextField).setText(null);
    }

    void logMessage(LEAgentMessage lEAgentMessage) {
        if (this.m_logCheckbox.getState() && this.m_logfile != null) {
            StringBuffer stringBuffer = new StringBuffer(30);
            String string = "";
            this.m_logprw.println("--------------------------------------------------------------------------------");
            this.m_logprw.println("Agent Message Contains:");
            stringBuffer.append("\tMessage: ");
            String string2 = lEAgentMessage.getMessage();
            stringBuffer.append(string2);
            this.m_logprw.println(stringBuffer.toString());
            stringBuffer = new StringBuffer("\tFrom: ");
            String string3 = string;
            Object object = lEAgentMessage.getContext();
            if (object instanceof LESourceInfo) {
                string3 = ((LESourceInfo)object).getAllSourceInfo();
            }
            stringBuffer.append(string3);
            stringBuffer.append("\tReceived: ");
            Date date = new Date(lEAgentMessage.getTimeStamp());
            String string4 = date.toString();
            stringBuffer.append(string4);
            stringBuffer.append("\tLevel: ");
            String string5 = Integer.toString(lEAgentMessage.getLevel());
            stringBuffer.append(string5);
            this.m_logprw.println(stringBuffer.toString());
            stringBuffer = new StringBuffer("\tSuggestion:");
            stringBuffer.append("\t");
            String string6 = lEAgentMessage.getSuggestion();
            if (string6 != null) {
                stringBuffer.append(string6);
            }
            this.m_logprw.println(stringBuffer.toString());
        }
    }

    static {
        m_pmListHeight = 70;
        m_messageListHeight = 100;
        TITLE = new String[]{"C", "From", "Message", "Received"};
        BLANK = new String("");
        PANEL_DEF_FONT = LEFont.getFont();
        PANEL_DEF_BOLD_FONT = LEFont.getBoldFont();
    }

    class DetailMLListener
    implements LEMLListener {
        public void onLEMLEvent(LEMLEvent lEMLEvent) {
            int n = lEMLEvent.getType();
            if (n == 6) {
                int[] nArray = LEMessageViewerPanel.this.m_lst.getSelectedRows();
                int n2 = nArray[nArray.length - 1];
                LEMessageViewerPanel.this.updateFullDetailMessage(n2);
                return;
            }
            if (n == 1) {
                LEMessageViewerPanel.this.updateDetailMessage(lEMLEvent.getRow());
            }
        }

        DetailMLListener() {
            LEMessageViewerPanel.this = LEMessageViewerPanel.this;
        }
    }
}

