/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMultiList;
import COM.livingston.util.LEUpTimeCompare;
import java.util.Enumeration;
import java.util.Hashtable;

public class LESAPMGrid
extends LEMultiList
implements LEAMObserver,
Runnable {
    public static final String REBOOTING = "Rebooting...";
    public static final String NOT_CONNECTED = "Connection Lost";
    static final int COLUMNS = 5;
    static int UPDATE_SLEEP_TIME = 90000;
    Hashtable m_pms = new Hashtable();
    Hashtable m_htnametotime = new Hashtable();

    public LESAPMGrid() {
        super(1, 0, 5);
        Object[] objectArray = new String[]{new String("PortMaster"), new String("Model"), new String("ComOS"), new String("Up Time"), new String("Time Connected")};
        this.setTitles(0, objectArray);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortable(3, true);
        this.setSortable(4, true);
        this.setSortObject(3, LEUpTimeCompare.getCompareObject());
        LEStatusFactory.GetFactory().addObserver("", this);
        Thread thread = new Thread(this);
        thread.setName("LEPMMultiList Updater");
        thread.start();
    }

    public synchronized boolean connectedTo(String string) {
        return this.m_pms.containsKey(string);
    }

    public void addPortMaster(String string, LEPortMaster lEPortMaster) {
        Object[] objectArray;
        boolean bl = false;
        if (lEPortMaster == null) {
            if (!this.m_pms.containsKey(string)) {
                this.m_pms.put(string, "");
                objectArray = new String[]{string, "File", "File", "File", "File"};
                this.addRow(objectArray);
                bl = true;
            }
        } else if (!this.m_pms.containsKey(string)) {
            this.m_pms.put(string, lEPortMaster);
            objectArray = new String[5];
            objectArray[0] = string;
            objectArray[1] = lEPortMaster.getHardwareType();
            objectArray[2] = lEPortMaster.getSoftwareVersion();
            objectArray[3] = lEPortMaster.getUpTime();
            this.m_htnametotime.put(string, new String("0"));
            objectArray[4] = new String("0 minutes");
            this.addRow(objectArray);
            bl = true;
        }
        if (bl) {
            if (this.m_pms.size() == 1) {
                objectArray = new int[1];
                objectArray[0] = (String)false;
                this.selectRows((int[])objectArray);
            } else {
                int n = this.getSelectSize();
                int[] nArray = new int[n + 1];
                int[] nArray2 = this.getSelectedRows();
                int n2 = nArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    nArray[n3] = nArray2[n3];
                    ++n3;
                }
                nArray[nArray.length - 1] = this.getNumRows() - 1;
                this.selectRows(nArray);
            }
            this.repaint();
        }
    }

    public synchronized void deletePortMaster(LEPortMaster lEPortMaster) {
        if (lEPortMaster == null) {
            return;
        }
        lEPortMaster.disconnect();
    }

    public synchronized void removeSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            String string = lEPortMasterArray[n].getHostname();
            int n2 = this.getPortMasterRow(string);
            this.m_pms.remove(lEPortMasterArray[n].getHostname());
            this.deletePortMaster(lEPortMasterArray[n]);
            this.deleteRow(n2);
            ++n;
        }
        this.repaint();
        this.setEnabled(false);
        this.setEnabled(true);
    }

    public synchronized void removeSelectedHosts() {
        String[] stringArray = this.getSelectedHostnames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.getPortMasterRow(stringArray[n2]);
            Object v = this.m_pms.get(stringArray[n2]);
            if (v instanceof LEPortMaster) {
                this.deletePortMaster((LEPortMaster)v);
            }
            this.m_pms.remove(stringArray[n2]);
            this.deleteRow(n3);
            ++n2;
        }
        this.repaint();
        this.setEnabled(false);
        this.setEnabled(true);
    }

    public synchronized void deleteSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.deletePortMaster(lEPortMasterArray[n]);
            ++n;
        }
        this.repaint();
    }

    public synchronized void reconnectSelectedPMs() {
        LEPortMaster[] lEPortMasterArray = this.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            ++n;
        }
    }

    public synchronized LEPortMaster[] getSelectedPMs() {
        int[] nArray = this.getSelectedRows();
        LEPortMaster[] lEPortMasterArray = new LEPortMaster[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            String string = (String)this.getCellItem(nArray[n], 0);
            lEPortMasterArray[n] = (LEPortMaster)this.m_pms.get(string);
            ++n;
        }
        return lEPortMasterArray;
    }

    public synchronized String[] getSelectedHostnames() {
        int[] nArray = this.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)this.getCellItem(nArray[n], 0);
            ++n;
        }
        return stringArray;
    }

    public String getSelectedModel() {
        int[] nArray = this.getSelectedRows();
        int n = nArray[nArray.length - 1];
        String string = (String)this.getCellItem(n, 1);
        return string;
    }

    public void updateUpTimes() {
        int n = this.getNumRows();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster;
            String string = (String)this.getCellItem(n2, 0);
            if (string != null && this.m_pms.get(string) instanceof LEPortMaster && (lEPortMaster = (LEPortMaster)this.m_pms.get(string)) != null && lEPortMaster.isConnected() && lEPortMaster.ping()) {
                this.setCellItem(n2, 2, lEPortMaster.getSoftwareVersion());
                this.setCellItem(n2, 3, lEPortMaster.getUpTime());
                String string2 = (String)this.m_htnametotime.get(string);
                long l = Long.parseLong(string2);
                this.m_htnametotime.put(string, Long.toString(l += (long)(UPDATE_SLEEP_TIME / 1000)));
                String string3 = this.getConnectTime(l);
                this.setCellItem(n2, 4, string3);
            }
            ++n2;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_pms.get(string);
            if (lEPortMaster == null) {
                return;
            }
            String string2 = null;
            String string3 = null;
            switch (lEStatusMessage.getStatus()) {
                case 1: {
                    lEPortMaster.ping();
                    string2 = lEPortMaster.getUpTime();
                    string3 = lEPortMaster.getSoftwareVersion();
                    this.m_htnametotime.put(string, new String("0"));
                    break;
                }
                case 2: {
                    string2 = NOT_CONNECTED;
                    this.m_htnametotime.put(string, new String("0"));
                    break;
                }
                case 4: {
                    string2 = REBOOTING;
                    break;
                }
            }
            if (string2 != null || string3 != null) {
                int n = this.getPortMasterRow(string);
                if (n > -1) {
                    if (string3 != null) {
                        this.setCellItem(n, 2, string3);
                    }
                    if (string2 != null) {
                        this.setCellItem(n, 3, string2);
                    }
                }
                this.notifyListeners(new LEMLEvent(3));
            }
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.m_pms.elements();
        while (enumeration.hasMoreElements()) {
            LEPortMaster lEPortMaster = (LEPortMaster)enumeration.nextElement();
            lEPortMaster.disconnect();
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(UPDATE_SLEEP_TIME);
                    this.updateUpTimes();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    int getPortMasterRow(String string) {
        int n = -1;
        int n2 = this.getNumRows();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            if (string.equals((String)this.getCellItem(n3, 0))) {
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    String getConnectTime(long l) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n3 = (int)(l / 86400L);
        if (n3 != 0) {
            stringBuffer.append(String.valueOf(n3) + " days ");
        }
        if ((n2 = (int)((l - (long)(n3 * 24 * 60 * 60)) / 3600L)) != 0 || n3 != 0) {
            stringBuffer.append(String.valueOf(n2) + " hours ");
        }
        if ((n = (int)((l - (long)(n3 * 24 * 60 * 60) - (long)(n2 * 60 * 60)) / 60L)) != 0 || n3 != 0 || n2 != 0) {
            stringBuffer.append(String.valueOf(n) + " minutes ");
        }
        int n4 = (int)(l - (long)(n3 * 24 * 60 * 60) - (long)(n2 * 60 * 60) - (long)(60 * n));
        stringBuffer.append(String.valueOf(n4) + " sec");
        return stringBuffer.toString();
    }
}

