/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class LESmartAgentLoggingDialog
extends Dialog
implements ActionListener,
LEConfirmClient {
    boolean m_logging_enabled = false;
    File m_file;
    TextField m_fileNameTextField;
    Button m_browseButton;
    Button m_okButton;
    Button m_cancelButton;
    PrintWriter m_prw;
    static LESmartAgentLoggingDialog m_logDialog;
    static int s_height;
    static int s_width;
    public static final String OKAY = "okay";
    public static final String BROWSE = "browse";
    public static final String CANCEL = "cancel";

    private LESmartAgentLoggingDialog(Frame frame) {
        super(frame, "Logging", true);
        ((Component)this).setSize(s_height, s_width);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.layoutPanel(), "Center");
        WinAdapter winAdapter = new WinAdapter();
        this.addWindowListener(winAdapter);
    }

    static LESmartAgentLoggingDialog Show(Frame frame) {
        if (m_logDialog == null) {
            m_logDialog = new LESmartAgentLoggingDialog(frame);
        }
        Point point = frame.getLocation();
        ((Component)m_logDialog).setBounds(point.x + 50, point.y + 30, s_height, s_width);
        ((Component)m_logDialog).setVisible(true);
        return m_logDialog;
    }

    Panel layoutPanel() {
        Panel panel = new Panel(new BorderLayout());
        this.m_fileNameTextField = new TextField("");
        panel.add((Component)this.m_fileNameTextField, "Center");
        this.m_browseButton = new Button("Browse");
        this.m_browseButton.setActionCommand(BROWSE);
        this.m_browseButton.addActionListener(this);
        panel.add((Component)this.m_browseButton, "East");
        Panel panel2 = new Panel(new FlowLayout());
        this.m_okButton = new Button("     OK     ");
        this.m_okButton.setActionCommand(OKAY);
        this.m_okButton.addActionListener(this);
        panel2.add(this.m_okButton);
        this.m_cancelButton = new Button(" Cancel ");
        this.m_cancelButton.setActionCommand(CANCEL);
        this.m_cancelButton.addActionListener(this);
        panel2.add(this.m_cancelButton);
        panel.add((Component)panel2, "South");
        return panel;
    }

    public boolean loggingEnabled() {
        return this.m_logging_enabled;
    }

    public void stopLogging() {
        this.m_logging_enabled = false;
        this.m_prw.flush();
        this.m_prw.close();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OKAY)) {
            this.m_logging_enabled = true;
            this.confirmEchoFile();
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (string.equals(BROWSE)) {
            this.browseFile();
            return;
        }
        if (string.equals(CANCEL)) {
            this.m_logging_enabled = false;
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    void browseFile() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.getFrame(this), "Command Echo File", 1);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        ((Component)fileDialog).setVisible(true);
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            ((TextComponent)this.m_fileNameTextField).setText(string3);
            LEAppInfo.setLastDirectory(string);
            this.confirmEchoFile();
        }
    }

    void confirmEchoFile() {
        String string = this.m_fileNameTextField.getText();
        if (string.length() == 0) {
            this.m_file = null;
            this.m_prw = null;
            return;
        }
        File file = new File(string);
        if (this.m_file == null || !file.getAbsolutePath().equals(this.m_file.getAbsolutePath())) {
            if (file.exists()) {
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.getFrame(this), (LEConfirmClient)this, String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?", stringArray, (Object)file);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            this.setEchoFile(file);
        }
    }

    void setEchoFile(File file) {
        this.m_file = file;
        ((TextComponent)this.m_fileNameTextField).setText(this.m_file.getAbsolutePath());
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.m_file);
            this.m_prw = new PrintWriter((Writer)fileWriter, true);
            return;
        }
        catch (IOException iOException) {
            this.m_file = null;
            this.m_prw = null;
            ((TextComponent)this.m_fileNameTextField).setText(null);
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.getFrame(this), iOException.getMessage());
            return;
        }
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.setEchoFile((File)object);
            return;
        }
        this.cancelAction(object);
    }

    public void cancelAction(Object object) {
        this.m_file = null;
        this.m_prw = null;
        ((TextComponent)this.m_fileNameTextField).setText(null);
    }

    public PrintWriter getPrintWriter() {
        return this.m_prw;
    }

    static {
        s_height = 450;
        s_width = 80;
    }

    class WinAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)LESmartAgentLoggingDialog.this).setVisible(false);
            LESmartAgentLoggingDialog.this.dispose();
        }

        WinAdapter() {
            LESmartAgentLoggingDialog.this = LESmartAgentLoggingDialog.this;
        }
    }
}

